/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import javax.lang.model.element.ExecutableElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.writer.expression.NewClassWriter;
import org.stjs.javascript.annotation.Template;

public class NewClassObjectInitCheck
implements CheckContributor<NewClassTree> {
    private void checkStatement(StatementTree stmt, GenerationContext<Void> context) {
        ExpressionTree expr;
        boolean ok = true;
        ok = stmt instanceof ExpressionStatementTree ? this.isPlainAssignExpression(expr = ((ExpressionStatementTree)stmt).getExpression()) || this.isTemplateAssignExpression(expr) : false;
        if (!ok) {
            context.addError(stmt, "Only assign expression (or equivalent) are allowed in an object creation block");
        }
    }

    private boolean isPlainAssignExpression(ExpressionTree expr) {
        return expr instanceof AssignmentTree;
    }

    private boolean isTemplateAssignExpression(ExpressionTree expr) {
        if (!(expr instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree meth = (MethodInvocationTree)expr;
        ExpressionTree select = meth.getMethodSelect();
        if (!(select instanceof IdentifierTree)) {
            return false;
        }
        if (meth.getArguments().size() != 1) {
            return false;
        }
        ExecutableElement elem = TreeUtils.elementFromUse(meth);
        Template template = elem.getAnnotation(Template.class);
        if (template == null) {
            return false;
        }
        return "toProperty".equals(template.value());
    }

    @Override
    public Void visit(CheckVisitor visitor, NewClassTree tree, GenerationContext<Void> context) {
        BlockTree initBlock = NewClassWriter.getDoubleBracesBlock(tree);
        TreeWrapper tw = context.getCurrentWrapper();
        if (initBlock == null && !tw.child(tree.getIdentifier()).isSyntheticType()) {
            return null;
        }
        if (initBlock != null) {
            for (StatementTree statementTree : initBlock.getStatements()) {
                this.checkStatement(statementTree, context);
            }
        }
        return null;
    }
}

