/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.statement;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.util.TreePath;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;

public class BlockInstanceCheck
implements CheckContributor<BlockTree> {
    public static boolean isInitializationBlock(TreePath path) {
        return path.getParentPath().getLeaf() instanceof ClassTree;
    }

    private boolean isObjectinitializerBlock(TreePath path) {
        return BlockInstanceCheck.isInitializationBlock(path) && path.getParentPath().getParentPath().getLeaf() instanceof NewClassTree;
    }

    @Override
    public Void visit(CheckVisitor visitor, BlockTree tree, GenerationContext<Void> context) {
        if (!BlockInstanceCheck.isInitializationBlock(context.getCurrentPath())) {
            return null;
        }
        if (this.isObjectinitializerBlock(context.getCurrentPath())) {
            return null;
        }
        if (!tree.isStatic()) {
            context.addError(tree, "Initializing blocks are not supported by Javascript. Check also wrongly placed semicolons or double semicolons - ;;");
        }
        return null;
    }
}

