/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javac;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Locale;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.TreeUtils;

public final class AnnotationHelper {
    private static final String ANNOTATED_PACKAGE = "annotation.";

    private AnnotationHelper() {
    }

    public static <T extends Annotation> T getAnnotation(Elements elements, Element element, Class<T> annotationType) {
        if (!(element instanceof ExecutableElement)) {
            return element == null ? null : (T)element.getAnnotation(annotationType);
        }
        T t = element.getAnnotation(annotationType);
        if (t != null) {
            return t;
        }
        List<ExecutableElement> similar = ElementUtils.getSameMethodFromParents((ExecutableElement)element);
        for (ExecutableElement method : similar) {
            t = method.getAnnotation(annotationType);
            if (t == null) continue;
            return t;
        }
        t = AnnotationHelper.getAnnotationInHelpers(elements, (ExecutableElement)element, annotationType);
        return t;
    }

    private static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase(Locale.getDefault());
        }
        return s.substring(0, 1).toUpperCase(Locale.getDefault()) + s.substring(1);
    }

    private static <T extends Annotation> T getAnnotationInHelpers(Elements elements, ExecutableElement methodElement, Class<T> annotationClass) {
        String ownerClassName = ((TypeElement)methodElement.getEnclosingElement()).getQualifiedName().toString();
        T annotation = AnnotationHelper.getAnnotationInHelperClass(elements, ANNOTATED_PACKAGE + ownerClassName + AnnotationHelper.capitalize(methodElement.getSimpleName().toString()), methodElement, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return AnnotationHelper.getAnnotationInHelperClass(elements, ANNOTATED_PACKAGE + ownerClassName, methodElement, annotationClass);
    }

    private static <T extends Annotation> T getAnnotationInHelperClass(Elements elements, String helperClassName, ExecutableElement methodElement, Class<T> annotationClass) {
        TypeElement type = elements.getTypeElement(helperClassName);
        if (type == null) {
            return null;
        }
        for (Element element : elements.getAllMembers(type)) {
            if (!(element instanceof ExecutableElement) || !AnnotationHelper.sameSignature((ExecutableElement)element, methodElement)) continue;
            return element.getAnnotation(annotationClass);
        }
        return null;
    }

    private static boolean sameSignature(ExecutableElement member, ExecutableElement methodElement) {
        return member.getSimpleName().equals(methodElement.getSimpleName());
    }

    public static RetentionPolicy getRetentionType(Tree annotationType) {
        if (!(annotationType instanceof ExpressionTree)) {
            return null;
        }
        Element annotationElement = TreeUtils.elementFromUse((ExpressionTree)annotationType);
        Retention retention = annotationElement.getAnnotation(Retention.class);
        if (retention == null) {
            return null;
        }
        return retention.value();
    }
}

