/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javac;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import javax.tools.JavaFileObject;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.javac.CustomJavaFileObject;

public class PackageInternalsFinder {
    private final ClassLoader classLoader;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Map<String, List<JavaFileObject>> cachePackageEntries = Maps.newHashMap();

    public PackageInternalsFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<JavaFileObject> find(String packageName, boolean recursive) throws IOException {
        String javaPackageName = packageName.replaceAll("\\.", "/");
        List<JavaFileObject> result = this.cachePackageEntries.get(javaPackageName);
        if (result != null) {
            return result;
        }
        result = new ArrayList<JavaFileObject>();
        this.cachePackageEntries.put(javaPackageName, result);
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(javaPackageName);
        while (urlEnumeration.hasMoreElements()) {
            URL packageFolderURL = urlEnumeration.nextElement();
            result.addAll(this.listUnder(packageName, packageFolderURL, recursive));
        }
        return result;
    }

    private Collection<JavaFileObject> listUnder(String packageName, URL packageFolderURL, boolean recursive) throws IOException {
        File directory;
        try {
            directory = "file".equals(packageFolderURL.getProtocol()) ? new File(packageFolderURL.toURI()) : new File(packageFolderURL.getFile());
        }
        catch (URISyntaxException e) {
            directory = new File(packageFolderURL.getFile());
        }
        if (directory.isDirectory()) {
            return this.processDir(packageName, directory, recursive);
        }
        return this.processJar(packageFolderURL, recursive);
    }

    private void addFileObject(String jarUri, String name, String rootEntryName, int rootEnd, List<JavaFileObject> result, boolean recursive) {
        boolean acceptCurrentFolder;
        boolean bl = acceptCurrentFolder = recursive || name.indexOf(47, rootEnd) == -1;
        if (acceptCurrentFolder && name.startsWith(rootEntryName) && name.endsWith(CLASS_FILE_EXTENSION)) {
            URI uri = URI.create(jarUri + "!/" + name);
            String binaryName = name.replaceAll("/", ".");
            binaryName = binaryName.replaceAll(".class$", "");
            result.add(new CustomJavaFileObject(binaryName, uri));
        }
    }

    private List<JavaFileObject> processJar(URL packageFolderURL, boolean recursive) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        try {
            URLConnection urlConnection = packageFolderURL.openConnection();
            if (!(urlConnection instanceof JarURLConnection)) {
                return Collections.emptyList();
            }
            String jarUri = packageFolderURL.toExternalForm().split("!")[0];
            JarURLConnection jarConn = (JarURLConnection)urlConnection;
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                JarEntry jarEntry = entryEnum.nextElement();
                String name = jarEntry.getName();
                this.addFileObject(jarUri, name, rootEntryName, rootEnd, result, recursive);
            }
        }
        catch (IOException e) {
            throw new STJSRuntimeException("Wasn't able to open " + packageFolderURL + " as a jar file", e);
        }
        return result;
    }

    private List<JavaFileObject> processDir(String packageName, File directory, boolean recursive) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        File[] childFiles = directory.listFiles();
        assert (childFiles != null);
        for (File childFile : childFiles) {
            if (childFile.isFile() && childFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                String binaryName = packageName + "." + childFile.getName();
                binaryName = binaryName.replaceAll(".class$", "");
                result.add(new CustomJavaFileObject(binaryName, childFile.toURI()));
                continue;
            }
            if (!recursive || !childFile.isDirectory()) continue;
            result.addAll(this.processDir(packageName + "." + childFile.getName(), childFile, recursive));
        }
        return result;
    }
}

