/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.javascript.rhino;

import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.javascript.rhino.AstVisitor;
import org.stjs.generator.javascript.rhino.CodeFragment;
import org.stjs.generator.javascript.rhino.RhinoJavaScriptBuilder;
import org.stjs.generator.javascript.rhino.RhinoNodeVisitorSupport;
import org.stjs.generator.javascript.rhino.Statements;

public class RhinoJavaScriptWriter
implements AstVisitor<Boolean> {
    private static final String LINE_JAVA_DOC = " * ";
    private static final String INDENT = "    ";
    private static final String START_JAVA_DOC = "/**";
    private static final String END_JAVA_DOC = " */";
    private int level;
    private boolean indented;
    private final Writer writer;
    private int currentLine;
    private int currentColumn;
    private final RhinoNodeVisitorSupport visitorSupport = new RhinoNodeVisitorSupport();
    private final SourceMapGenerator sourceMapGenerator;
    private final boolean generateSourceMap;
    private final File inputFile;
    private FilePosition javaPosition;
    private FilePosition javaScriptPosition;

    public RhinoJavaScriptWriter(Writer writer, File inputFile, boolean generateSourceMap) {
        this.writer = writer;
        this.inputFile = inputFile;
        this.generateSourceMap = generateSourceMap;
        this.sourceMapGenerator = generateSourceMap ? SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3) : null;
    }

    protected RhinoJavaScriptWriter indent() {
        ++this.level;
        return this;
    }

    protected RhinoJavaScriptWriter unindent() {
        --this.level;
        return this;
    }

    protected void makeIndent() {
        for (int i = 0; i < this.level; ++i) {
            try {
                this.writer.append(INDENT);
            }
            catch (IOException e) {
                throw new STJSRuntimeException("Writing problem:" + e, e);
            }
            this.currentColumn += INDENT.length();
        }
    }

    protected RhinoJavaScriptWriter print(String arg) {
        if (!this.indented) {
            this.makeIndent();
            this.indented = true;
        }
        try {
            this.writer.append(arg);
        }
        catch (IOException e) {
            throw new STJSRuntimeException("Writing problem:" + e, e);
        }
        this.currentColumn += arg.length();
        return this;
    }

    protected RhinoJavaScriptWriter printComments(AstNode node) {
        String comment = node.getJsDoc();
        if (comment != null) {
            String[] lines;
            this.println(START_JAVA_DOC);
            for (String line : lines = comment.split("\n")) {
                this.print(LINE_JAVA_DOC).println(line);
            }
            this.println(END_JAVA_DOC);
        }
        return this;
    }

    public RhinoJavaScriptWriter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public RhinoJavaScriptWriter println() {
        try {
            this.writer.append('\n');
        }
        catch (IOException e) {
            throw new STJSRuntimeException("Writing problem:" + e, e);
        }
        this.indented = false;
        ++this.currentLine;
        this.currentColumn = 0;
        this.addMapping();
        return this;
    }

    protected void startPosition(AstNode node) {
        if (this.generateSourceMap) {
            this.javaPosition = new FilePosition(RhinoJavaScriptBuilder.getLineNumber(node) - 1, RhinoJavaScriptBuilder.getColumnNumber(node) - 1);
            this.javaScriptPosition = new FilePosition(this.currentLine, this.currentColumn);
        }
    }

    protected void endPosition(AstNode node) {
        if (this.generateSourceMap) {
            boolean hasPosition;
            boolean bl = hasPosition = this.javaScriptPosition != null && this.javaScriptPosition.getLine() != this.currentLine;
            if (hasPosition) {
                this.javaPosition = new FilePosition(RhinoJavaScriptBuilder.getEndLineNumber(node) - 1, RhinoJavaScriptBuilder.getEndColumnNumber(node) - 1);
                this.javaScriptPosition = new FilePosition(this.currentLine, this.currentColumn);
            }
        }
    }

    protected void addMapping() {
        if (this.generateSourceMap) {
            FilePosition endJavaScriptPosition = new FilePosition(this.currentLine, this.currentColumn);
            if (this.javaPosition != null && this.javaPosition.getLine() >= 0 && this.javaPosition.getColumn() >= 0) {
                this.sourceMapGenerator.addMapping(this.inputFile.getName(), null, this.javaPosition, this.javaScriptPosition, endJavaScriptPosition);
                this.javaPosition = null;
            }
        }
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral a, Boolean param) {
        this.print("[");
        if (a.getElements() != null) {
            this.printList(a.getElements(), param);
        }
        this.print("]");
    }

    protected <T extends AstNode> void printList(List<T> items, Boolean param) {
        int max = items.size();
        int count = 0;
        for (AstNode item : items) {
            this.visitorSupport.accept((Node)item, this, param);
            if (count < max - 1) {
                ++count;
                this.print(", ");
                continue;
            }
            if (!(item instanceof EmptyExpression)) continue;
            this.print(",");
        }
    }

    @Override
    public void visitAssignment(Assignment a, Boolean param) {
        this.printComments((AstNode)a);
        this.printBinaryOperator(a.getType(), a.getLeft(), a.getRight(), param);
    }

    protected void printBinaryOperator(int op, AstNode left, AstNode right, Boolean param) {
        this.visitorSupport.accept((Node)left, this, param);
        this.print(" ");
        this.print(AstNode.operatorToString((int)op));
        this.print(" ");
        this.visitorSupport.accept((Node)right, this, param);
    }

    @Override
    public void visitAstRoot(AstRoot r, Boolean param) {
        for (Node child : r) {
            this.visitorSupport.accept(child, this, param);
        }
        this.addSourceMapURL();
    }

    @Override
    public void visitBlock(Block block, Boolean param) {
        if (block.getFirstChild() == null) {
            this.print("{}");
            return;
        }
        this.println("{").indent();
        for (Node child : block) {
            this.visitorSupport.accept(child, this, param);
        }
        this.unindent().print("}");
    }

    @Override
    public void visitBreakStatemen(BreakStatement b, Boolean param) {
        this.startPosition((AstNode)b);
        this.print("break");
        if (b.getBreakLabel() != null) {
            this.print(" ");
            this.visitorSupport.accept((Node)b.getBreakLabel(), this, param);
        }
        this.println(";");
    }

    @Override
    public void visitCatchClause(CatchClause c, Boolean param) {
        this.print("catch (");
        this.visitorSupport.accept((Node)c.getVarName(), this, param);
        this.print(") ");
        this.visitorSupport.accept((Node)c.getBody(), this, param);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression c, Boolean param) {
        this.visitorSupport.accept((Node)c.getTestExpression(), this, param);
        this.print(" ? ");
        this.visitorSupport.accept((Node)c.getTrueExpression(), this, param);
        this.print(" : ");
        this.visitorSupport.accept((Node)c.getFalseExpression(), this, param);
    }

    @Override
    public void visitContinueStatement(ContinueStatement c, Boolean param) {
        this.startPosition((AstNode)c);
        this.print("continue");
        if (c.getLabel() != null) {
            this.print(" ");
            this.visitorSupport.accept((Node)c.getLabel(), this, param);
        }
        this.println(";");
    }

    @Override
    public void visitDoLoop(DoLoop d, Boolean param) {
        this.startPosition((AstNode)d);
        this.print("do ");
        this.visitorSupport.accept((Node)d.getBody(), this, param);
        this.print(" while (");
        this.visitorSupport.accept((Node)d.getCondition(), this, param);
        this.println(");");
    }

    @Override
    public void visitElementGet(ElementGet eg, Boolean param) {
        this.visitorSupport.accept((Node)eg.getTarget(), this, param);
        this.print("[");
        this.visitorSupport.accept((Node)eg.getElement(), this, param);
        this.print("]");
    }

    @Override
    public void visitEmptyStatement(EmptyStatement s, Boolean param) {
        this.startPosition((AstNode)s);
        this.println(";");
    }

    @Override
    public void visitEmptyExpression(EmptyExpression s, Boolean param) {
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement e, Boolean param) {
        this.printComments((AstNode)e);
        this.startPosition((AstNode)e);
        this.visitorSupport.accept((Node)e.getExpression(), this, param);
        this.endPosition((AstNode)e);
        this.println(";");
    }

    private void printStatementAsBlock(AstNode stmt, Boolean param) {
        this.printStatementAsBlock(stmt, param, true);
    }

    private void printStatementAsBlock(AstNode stmt, Boolean param, boolean addNewLineAfterBlock) {
        if (stmt instanceof Block) {
            this.visitorSupport.accept((Node)stmt, this, param);
            if (addNewLineAfterBlock) {
                this.println();
            }
        } else {
            this.println().indent();
            this.visitorSupport.accept((Node)stmt, this, param);
            this.unindent();
        }
    }

    @Override
    public void visitForInLoop(ForInLoop f, Boolean param) {
        this.startPosition((AstNode)f);
        this.print("for (");
        this.visitorSupport.accept((Node)f.getIterator(), this, param);
        this.print(" in ");
        this.visitorSupport.accept((Node)f.getIteratedObject(), this, param);
        this.print(") ");
        this.printStatementAsBlock(f.getBody(), param);
    }

    @Override
    public void visitForLoop(ForLoop f, Boolean param) {
        this.startPosition((AstNode)f);
        this.print("for (");
        this.visitorSupport.accept((Node)f.getInitializer(), this, param);
        this.print("; ");
        this.visitorSupport.accept((Node)f.getCondition(), this, param);
        this.print("; ");
        this.visitorSupport.accept((Node)f.getIncrement(), this, param);
        this.print(") ");
        this.printStatementAsBlock(f.getBody(), param);
    }

    @Override
    public void visitFunctionCall(FunctionCall fc, Boolean param) {
        this.visitorSupport.accept((Node)fc.getTarget(), this, param);
        this.print("(");
        if (fc.getArguments() != null) {
            this.printList(fc.getArguments(), param);
        }
        this.print(")");
    }

    @Override
    public void visitFunctionNode(FunctionNode f, Boolean param) {
        this.printComments((AstNode)f);
        this.print("function");
        if (f.getFunctionName() != null) {
            this.print(" ");
            this.visitorSupport.accept((Node)f.getFunctionName(), this, param);
        }
        if (f.getParams() == null) {
            this.print("() ");
        } else {
            this.print("(");
            this.printList(f.getParams(), param);
            this.print(") ");
        }
        this.visitorSupport.accept((Node)f.getBody(), this, param);
    }

    @Override
    public void visitIfStatement(IfStatement ifs, Boolean param) {
        this.startPosition((AstNode)ifs);
        this.print("if (");
        this.visitorSupport.accept((Node)ifs.getCondition(), this, param);
        this.print(") ");
        this.printStatementAsBlock(ifs.getThenPart(), param, ifs.getElsePart() == null);
        if (ifs.getElsePart() instanceof IfStatement) {
            this.print(" else ");
            this.visitorSupport.accept((Node)ifs.getElsePart(), this, param);
        } else if (ifs.getElsePart() != null) {
            this.print(" else ");
            this.printStatementAsBlock(ifs.getElsePart(), param);
        }
    }

    @Override
    public void visitInfixExpression(InfixExpression ie, Boolean param) {
        this.visitorSupport.accept((Node)ie.getLeft(), this, param);
        this.print(" ");
        this.print(AstNode.operatorToString((int)ie.getType()));
        this.print(" ");
        this.visitorSupport.accept((Node)ie.getRight(), this, param);
    }

    @Override
    public void visitKeywordLiteral(KeywordLiteral k, Boolean param) {
        switch (k.getType()) {
            case 43: {
                this.print("this");
                break;
            }
            case 42: {
                this.print("null");
                break;
            }
            case 45: {
                this.print("true");
                break;
            }
            case 44: {
                this.print("false");
                break;
            }
            case 160: {
                this.println("debugger;");
                break;
            }
        }
    }

    @Override
    public void visitLabel(Label label, Boolean param) {
        this.print(label.getName());
        this.println(":");
    }

    @Override
    public void visitLabeledStatement(LabeledStatement labelStatement, Boolean param) {
        for (Label label : labelStatement.getLabels()) {
            this.visitorSupport.accept((Node)label, this, param);
        }
        this.indent();
        this.visitorSupport.accept((Node)labelStatement.getStatement(), this, param);
        this.unindent();
    }

    @Override
    public void visitName(Name name, Boolean param) {
        this.print(name.getIdentifier());
    }

    @Override
    public void visitNewExpression(NewExpression ne, Boolean param) {
        this.print("new ");
        this.visitorSupport.accept((Node)ne.getTarget(), this, param);
        this.print("(");
        if (ne.getArguments() != null) {
            this.printList(ne.getArguments(), param);
        }
        this.print(")");
        if (ne.getInitializer() != null) {
            this.print(" ");
            this.visitorSupport.accept((Node)ne.getInitializer(), this, param);
        }
    }

    @Override
    public void visitNumberLitera(NumberLiteral n, Boolean param) {
        this.print(n.getValue());
    }

    @Override
    public void visitObjectLiteral(ObjectLiteral p, Boolean param) {
        this.print("{");
        if (p.getElements() != null) {
            this.printList(p.getElements(), param);
        }
        this.print("}");
    }

    @Override
    public void visitObjectProperty(ObjectProperty p, Boolean param) {
        this.visitorSupport.accept((Node)p.getLeft(), this, param);
        if (p.getType() == 103) {
            this.print(": ");
        }
        this.visitorSupport.accept((Node)p.getRight(), this, param);
    }

    @Override
    public void visitParenthesizedExpression(ParenthesizedExpression p, Boolean param) {
        this.print("(");
        this.visitorSupport.accept((Node)p.getExpression(), this, param);
        this.print(")");
    }

    @Override
    public void visitPropertyGet(PropertyGet p, Boolean param) {
        this.visitorSupport.accept((Node)p.getLeft(), this, param);
        this.print(".");
        this.visitorSupport.accept((Node)p.getRight(), this, param);
    }

    @Override
    public void visitReturnStatement(ReturnStatement r, Boolean param) {
        this.startPosition((AstNode)r);
        this.print("return");
        if (r.getReturnValue() != null) {
            this.print(" ");
            this.visitorSupport.accept((Node)r.getReturnValue(), this, param);
        }
        this.println(";");
    }

    @Override
    public void visitStatements(Statements s, Boolean param) {
        this.printComments(s);
        Iterator i$ = s.iterator();
        while (i$.hasNext()) {
            Node stmt = (Node)i$.next();
            this.visitorSupport.accept(stmt, this, param);
        }
    }

    @Override
    public void visitStringLiteral(StringLiteral expr, Boolean param) {
        this.print(Character.toString(expr.getQuoteCharacter()));
        this.print(ScriptRuntime.escapeString((String)expr.getValue(), (char)expr.getQuoteCharacter()));
        this.print(Character.toString(expr.getQuoteCharacter()));
    }

    @Override
    public void visitSwitchCase(SwitchCase s, Boolean param) {
        if (s.getExpression() == null) {
            this.println("default:");
        } else {
            this.print("case ");
            this.visitorSupport.accept((Node)s.getExpression(), this, param);
            this.println(":");
        }
        if (s.getStatements() != null) {
            this.indent();
            for (AstNode stmt : s.getStatements()) {
                this.visitorSupport.accept((Node)stmt, this, param);
            }
            this.unindent();
        }
    }

    @Override
    public void visitSwitchStatement(SwitchStatement s, Boolean param) {
        this.startPosition((AstNode)s);
        this.print("switch (");
        this.visitorSupport.accept((Node)s.getExpression(), this, param);
        this.println(") {");
        this.indent();
        for (SwitchCase sc : s.getCases()) {
            this.visitorSupport.accept((Node)sc, this, param);
        }
        this.unindent();
        this.println("}");
    }

    @Override
    public void visitTryStatement(TryStatement t, Boolean param) {
        this.startPosition((AstNode)t);
        this.print("try ");
        this.visitorSupport.accept((Node)t.getTryBlock(), this, param);
        for (CatchClause cc : t.getCatchClauses()) {
            this.visitorSupport.accept((Node)cc, this, param);
        }
        if (t.getFinallyBlock() != null) {
            this.print(" finally ");
            this.visitorSupport.accept((Node)t.getFinallyBlock(), this, param);
        }
        this.println();
    }

    @Override
    public void visitUnaryExpression(UnaryExpression u, Boolean param) {
        int type = u.getType();
        if (!u.isPostfix()) {
            this.print(AstNode.operatorToString((int)type));
            if (type == 32 || type == 31 || type == 126) {
                this.print(" ");
            }
        }
        this.visitorSupport.accept((Node)u.getOperand(), this, param);
        if (u.isPostfix()) {
            this.print(AstNode.operatorToString((int)type));
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration v, Boolean param) {
        this.printComments((AstNode)v);
        if (v.isStatement()) {
            this.startPosition((AstNode)v);
        }
        this.print("var ");
        this.printList(v.getVariables(), param);
        if (v.isStatement()) {
            this.println(";");
        }
    }

    @Override
    public void visitVariableInitializer(VariableInitializer v, Boolean param) {
        this.visitorSupport.accept((Node)v.getTarget(), this, param);
        if (v.getInitializer() != null) {
            this.print(" = ");
            this.visitorSupport.accept((Node)v.getInitializer(), this, param);
        }
    }

    @Override
    public void visitWhileLoop(WhileLoop w, Boolean param) {
        this.startPosition((AstNode)w);
        this.print(" while (");
        this.visitorSupport.accept((Node)w.getCondition(), this, param);
        this.print(")");
        this.printStatementAsBlock(w.getBody(), param);
    }

    @Override
    public void visitThrowStatement(ThrowStatement e, Boolean param) {
        this.startPosition((AstNode)e);
        this.print(" throw ");
        this.visitorSupport.accept((Node)e.getExpression(), this, param);
        this.println(";");
    }

    public void addSourceMapURL() {
        if (this.generateSourceMap) {
            this.addMapping();
            this.print("//# sourceMappingURL=").print(this.inputFile.getName().replaceAll("\\.java$", ".map"));
        }
    }

    public SourceMapGenerator getSourceMapGenerator() {
        return this.sourceMapGenerator;
    }

    @Override
    public void visitCodeFragment(CodeFragment c, Boolean param) {
        if (c.getCode() != null) {
            this.print(c.getCode());
        }
    }
}

