/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.name;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.GeneratorConfiguration;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.name.JavaScriptNameProvider;
import org.stjs.generator.utils.ClassUtils;
import org.stjs.generator.utils.JavaNodes;

public class DefaultJavaScriptNameProvider
implements JavaScriptNameProvider {
    private static final String JAVA_LANG_PACKAGE = "java.lang.";
    private static final int JAVA_LANG_LENGTH = "java.lang.".length();
    private final Map<String, DependencyType> resolvedRootTypes = new HashMap<String, DependencyType>();
    private final Map<TypeMirror, TypeInfo> resolvedTypes = new HashMap<TypeMirror, TypeInfo>();

    private String addNameSpace(Element rootTypeElement, GenerationContext<?> context, String name) {
        String namespace = context.wrap(rootTypeElement).getNamespace();
        if (namespace.isEmpty()) {
            return name;
        }
        return namespace + "." + name;
    }

    @Override
    public String getTypeName(GenerationContext<?> context, TypeMirror type, DependencyType dependencyType) {
        TypeInfo typeInfo = this.resolvedTypes.get(type);
        if (typeInfo != null) {
            this.addResolvedType(typeInfo.getRootTypeElement(), dependencyType);
            return typeInfo.getFullName();
        }
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            String name = InternalUtils.getSimpleName(declaredType.asElement());
            Element rootTypeElement = declaredType.asElement();
            DeclaredType enclosingType = JavaNodes.getEnclosingType(declaredType);
            while (enclosingType != null) {
                rootTypeElement = enclosingType.asElement();
                name = InternalUtils.getSimpleName(rootTypeElement) + "." + name;
                enclosingType = JavaNodes.getEnclosingType(enclosingType);
            }
            this.checkAllowedType(rootTypeElement, context);
            this.addResolvedType(rootTypeElement, dependencyType);
            String fullName = this.addNameSpace(rootTypeElement, context, name);
            this.resolvedTypes.put(type, new TypeInfo(fullName, rootTypeElement));
            return fullName;
        }
        if (type instanceof WildcardType) {
            return "Object";
        }
        return type.toString();
    }

    private void typeNotAllowedException(GenerationContext<?> context, String name) {
        context.addError(context.getCurrentPath().getLeaf(), "The usage of the class " + name + " is not allowed. If it's one of your own bridge types, " + "please add the annotation @STJSBridge to the class or to its package.");
    }

    private boolean isJavaLangClassAllowed(GenerationContext<?> context, String name) {
        GeneratorConfiguration configuration = context.getConfiguration();
        return name.startsWith(JAVA_LANG_PACKAGE) && configuration.getAllowedJavaLangClasses().contains(name.substring(JAVA_LANG_LENGTH));
    }

    private boolean isPackageAllowed(GenerationContext<?> context, String name) {
        if (name.startsWith(JAVA_LANG_PACKAGE)) {
            return false;
        }
        GeneratorConfiguration configuration = context.getConfiguration();
        for (String packageName : configuration.getAllowedPackages()) {
            if (!name.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isBridge(GenerationContext<?> context, String name) {
        if (name.startsWith(JAVA_LANG_PACKAGE)) {
            return false;
        }
        return ClassUtils.isBridge(context.getBuiltProjectClassLoader(), ClassUtils.getClazz(context.getBuiltProjectClassLoader(), name));
    }

    private void checkAllowedType(Element rootTypeElement, GenerationContext<?> context) {
        String name = ElementUtils.getQualifiedClassName(rootTypeElement).toString();
        if (name.isEmpty()) {
            return;
        }
        if (this.isJavaLangClassAllowed(context, name)) {
            return;
        }
        if (this.isImportedStjsClass(context, name)) {
            return;
        }
        if (this.isPackageAllowed(context, name)) {
            return;
        }
        if (this.isBridge(context, name)) {
            return;
        }
        this.typeNotAllowedException(context, name);
    }

    private boolean isImportedStjsClass(GenerationContext<?> context, String className) {
        String stjsPropertiesName = ClassUtils.getPropertiesFileName(className);
        return context.getBuiltProjectClassLoader().getResource(stjsPropertiesName) != null;
    }

    private void addResolvedType(Element rootTypeElement, DependencyType depType) {
        DependencyType prevDepType;
        String name = ElementUtils.getQualifiedClassName(rootTypeElement).toString();
        if (!name.startsWith(JAVA_LANG_PACKAGE) && ((prevDepType = this.resolvedRootTypes.get(name)) == null || depType.isStricter(prevDepType))) {
            this.resolvedRootTypes.put(name, depType);
        }
    }

    @Override
    public String getVariableName(GenerationContext<?> context, IdentifierTree treeNode, TreePath path) {
        return null;
    }

    @Override
    public String getMethodName(GenerationContext<?> context, MethodTree tree, TreePath path) {
        return tree.getName().toString();
    }

    @Override
    public String getMethodName(GenerationContext<?> context, MethodInvocationTree tree, TreePath path) {
        return null;
    }

    @Override
    public String getTypeName(GenerationContext<?> context, Element type, DependencyType dependencyType) {
        if (type == null) {
            return null;
        }
        return this.getTypeName(context, type.asType(), dependencyType);
    }

    @Override
    public Map<String, DependencyType> getResolvedTypes() {
        return this.resolvedRootTypes;
    }

    private class TypeInfo {
        private final String fullName;
        private final Element rootTypeElement;

        public TypeInfo(String fullName, Element rootTypeElement) {
            this.fullName = fullName;
            this.rootTypeElement = rootTypeElement;
        }

        public String getFullName() {
            return this.fullName;
        }

        public Element getRootTypeElement() {
            return this.rootTypeElement;
        }
    }
}

