/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.plugin;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.check.declaration.ArrayTypeForbiddenCheck;
import org.stjs.generator.check.declaration.ClassDuplicateMemberNameCheck;
import org.stjs.generator.check.declaration.ClassEnumWithoutMembersCheck;
import org.stjs.generator.check.declaration.ClassGlobalForbidInnerCheck;
import org.stjs.generator.check.declaration.ClassGlobalInstanceMembersCheck;
import org.stjs.generator.check.declaration.ClassImplementJavascriptFunctionCheck;
import org.stjs.generator.check.declaration.ClassNamespaceCheck;
import org.stjs.generator.check.declaration.FieldInitializerCheck;
import org.stjs.generator.check.declaration.MethodDeclarationTemplateCheck;
import org.stjs.generator.check.declaration.MethodOverloadCheck;
import org.stjs.generator.check.declaration.MethodSynchronizedCheck;
import org.stjs.generator.check.declaration.MethodVarArgParamCheck;
import org.stjs.generator.check.declaration.MethodWrongNameCheck;
import org.stjs.generator.check.expression.IdentifierAccessOuterScopeCheck;
import org.stjs.generator.check.expression.IdentifierAccessServerSideCheck;
import org.stjs.generator.check.expression.IdentifierGlobalScopeNameClashCheck;
import org.stjs.generator.check.expression.MemberSelectGlobalScopeNameClashCheck;
import org.stjs.generator.check.expression.MemberSelectOuterScopeCheck;
import org.stjs.generator.check.expression.MemberSelectServerSideCheck;
import org.stjs.generator.check.expression.MethodInvocationMapConstructorCheck;
import org.stjs.generator.check.expression.MethodInvocationOuterScopeCheck;
import org.stjs.generator.check.expression.MethodInvocationServerSideCheck;
import org.stjs.generator.check.expression.MethodInvocationSuperSynthCheck;
import org.stjs.generator.check.expression.NewArrayForbiddenCheck;
import org.stjs.generator.check.expression.NewClassInlineFunctionCheck;
import org.stjs.generator.check.expression.NewClassObjectInitCheck;
import org.stjs.generator.check.statement.AssertCheck;
import org.stjs.generator.check.statement.BlockInstanceCheck;
import org.stjs.generator.check.statement.SynchronizedCheck;
import org.stjs.generator.check.statement.VariableFinalInLoopCheck;
import org.stjs.generator.check.statement.VariableWrongNameCheck;
import org.stjs.generator.plugin.STJSGenerationPlugin;
import org.stjs.generator.visitor.DiscriminatorKey;
import org.stjs.generator.writer.CommentWriter;
import org.stjs.generator.writer.CompilationUnitWriter;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.declaration.ClassWriter;
import org.stjs.generator.writer.declaration.MethodWriter;
import org.stjs.generator.writer.expression.ArrayAccessWriter;
import org.stjs.generator.writer.expression.AssignmentWriter;
import org.stjs.generator.writer.expression.BinaryWriter;
import org.stjs.generator.writer.expression.CompoundAssignmentWriter;
import org.stjs.generator.writer.expression.ConditionalWriter;
import org.stjs.generator.writer.expression.IdentifierWriter;
import org.stjs.generator.writer.expression.InstanceofWriter;
import org.stjs.generator.writer.expression.LiteralWriter;
import org.stjs.generator.writer.expression.MemberSelectWriter;
import org.stjs.generator.writer.expression.MethodInvocationWriter;
import org.stjs.generator.writer.expression.NewArrayWriter;
import org.stjs.generator.writer.expression.NewClassWriter;
import org.stjs.generator.writer.expression.ParenthesizedWriter;
import org.stjs.generator.writer.expression.TypeCastWriter;
import org.stjs.generator.writer.expression.UnaryWriter;
import org.stjs.generator.writer.statement.AssertWriter;
import org.stjs.generator.writer.statement.BlockWriter;
import org.stjs.generator.writer.statement.BreakWriter;
import org.stjs.generator.writer.statement.CaseWriter;
import org.stjs.generator.writer.statement.CatchWriter;
import org.stjs.generator.writer.statement.ContinueWriter;
import org.stjs.generator.writer.statement.DoWhileLoopWriter;
import org.stjs.generator.writer.statement.EmptyStatementWriter;
import org.stjs.generator.writer.statement.EnhancedForLoopWriter;
import org.stjs.generator.writer.statement.ExpressionStatementWriter;
import org.stjs.generator.writer.statement.ForLoopWriter;
import org.stjs.generator.writer.statement.IfWriter;
import org.stjs.generator.writer.statement.LabeledStatementWriter;
import org.stjs.generator.writer.statement.ReturnWriter;
import org.stjs.generator.writer.statement.SwitchWriter;
import org.stjs.generator.writer.statement.SynchronizedWriter;
import org.stjs.generator.writer.statement.ThrowWriter;
import org.stjs.generator.writer.statement.TryWriter;
import org.stjs.generator.writer.statement.VariableWriter;
import org.stjs.generator.writer.statement.WhileLoopWriter;
import org.stjs.generator.writer.templates.AdapterTemplate;
import org.stjs.generator.writer.templates.ArrayTemplate;
import org.stjs.generator.writer.templates.AssertTemplate;
import org.stjs.generator.writer.templates.DefaultTemplate;
import org.stjs.generator.writer.templates.DeleteTemplate;
import org.stjs.generator.writer.templates.GetTemplate;
import org.stjs.generator.writer.templates.InvokeTemplate;
import org.stjs.generator.writer.templates.JsTemplate;
import org.stjs.generator.writer.templates.MapTemplate;
import org.stjs.generator.writer.templates.MethodToPropertyTemplate;
import org.stjs.generator.writer.templates.OrTemplate;
import org.stjs.generator.writer.templates.PrefixTemplate;
import org.stjs.generator.writer.templates.PropertiesTemplate;
import org.stjs.generator.writer.templates.PutTemplate;
import org.stjs.generator.writer.templates.SetTemplate;
import org.stjs.generator.writer.templates.SuffixTemplate;
import org.stjs.generator.writer.templates.TypeOfTemplate;
import org.stjs.generator.writer.templates.fields.DefaultAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.DefaultCompoundAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.DefaultIdentifierTemplate;
import org.stjs.generator.writer.templates.fields.DefaultMemberSelectTemplate;
import org.stjs.generator.writer.templates.fields.DefaultUnaryTemplate;
import org.stjs.generator.writer.templates.fields.GetterIdentifierTemplate;
import org.stjs.generator.writer.templates.fields.GetterMemberSelectTemplate;
import org.stjs.generator.writer.templates.fields.GlobalGetterIdentifierTemplate;
import org.stjs.generator.writer.templates.fields.GlobalGetterMemberSelectTemplate;
import org.stjs.generator.writer.templates.fields.GlobalSetterAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.GlobalSetterCompoundAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.GlobalSetterUnaryTemplate;
import org.stjs.generator.writer.templates.fields.PathGetterMemberSelectTemplate;
import org.stjs.generator.writer.templates.fields.SetterAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.SetterCompoundAssignmentTemplate;
import org.stjs.generator.writer.templates.fields.SetterUnaryTemplate;

public class MainGenerationPlugin<JS>
implements STJSGenerationPlugin<JS> {
    public GenerationContext<JS> newContext() {
        return null;
    }

    @Override
    public void contributeCheckVisitor(CheckVisitor visitor) {
        visitor.contribute(new VariableFinalInLoopCheck());
        visitor.contribute(new VariableWrongNameCheck());
        visitor.contribute(new MethodVarArgParamCheck());
        visitor.contribute(new FieldInitializerCheck());
        visitor.contribute(new ClassDuplicateMemberNameCheck());
        visitor.contribute(new NewClassInlineFunctionCheck());
        visitor.contribute(new ClassImplementJavascriptFunctionCheck());
        visitor.contribute(new ClassGlobalInstanceMembersCheck());
        visitor.contribute(new ClassNamespaceCheck());
        visitor.contribute(new MethodOverloadCheck());
        visitor.contribute(new NewClassObjectInitCheck());
        visitor.contribute(new ArrayTypeForbiddenCheck());
        visitor.contribute(new ClassEnumWithoutMembersCheck());
        visitor.contribute(new NewArrayForbiddenCheck());
        visitor.contribute(new BlockInstanceCheck());
        visitor.contribute(new MethodInvocationMapConstructorCheck());
        visitor.contribute(new SynchronizedCheck());
        visitor.contribute(new MethodSynchronizedCheck());
        visitor.contribute(new AssertCheck());
        visitor.contribute(new IdentifierGlobalScopeNameClashCheck());
        visitor.contribute(new MemberSelectGlobalScopeNameClashCheck());
        visitor.contribute(new MethodDeclarationTemplateCheck());
        visitor.contribute(new IdentifierAccessOuterScopeCheck());
        visitor.contribute(new MethodInvocationOuterScopeCheck());
        visitor.contribute(new MemberSelectOuterScopeCheck());
        visitor.contribute(new ClassGlobalForbidInnerCheck());
        visitor.contribute(new MethodInvocationSuperSynthCheck());
        visitor.contribute(new IdentifierAccessServerSideCheck());
        visitor.contribute(new MemberSelectServerSideCheck());
        visitor.contribute(new MethodInvocationServerSideCheck());
        visitor.contribute(new MethodWrongNameCheck());
    }

    @Override
    public void contributeWriteVisitor(WriterVisitor<JS> visitor) {
        visitor.contribute(new CompilationUnitWriter());
        visitor.contribute(new ClassWriter());
        visitor.contribute(new MethodWriter());
        visitor.contribute(new ArrayAccessWriter());
        visitor.contribute(new AssignmentWriter());
        visitor.contribute(new BinaryWriter());
        visitor.contribute(new CompoundAssignmentWriter());
        visitor.contribute(new ConditionalWriter());
        visitor.contribute(new IdentifierWriter());
        visitor.contribute(new InstanceofWriter());
        visitor.contribute(new LiteralWriter());
        visitor.contribute(new MemberSelectWriter());
        visitor.contribute(new MethodInvocationWriter());
        visitor.contribute(new NewArrayWriter());
        visitor.contribute(new NewClassWriter());
        visitor.contribute(new ParenthesizedWriter());
        visitor.contribute(new TypeCastWriter());
        visitor.contribute(new UnaryWriter());
        visitor.contribute(new AssertWriter());
        visitor.contribute(new BlockWriter());
        visitor.contribute(new BreakWriter());
        visitor.contribute(new CaseWriter());
        visitor.contribute(new CatchWriter());
        visitor.contribute(new ContinueWriter());
        visitor.contribute(new DoWhileLoopWriter());
        visitor.contribute(new EmptyStatementWriter());
        visitor.contribute(new EnhancedForLoopWriter());
        visitor.contribute(new ExpressionStatementWriter());
        visitor.contribute(new ForLoopWriter());
        visitor.contribute(new IfWriter());
        visitor.contribute(new LabeledStatementWriter());
        visitor.contribute(new ReturnWriter());
        visitor.contribute(new SwitchWriter());
        visitor.contribute(new SynchronizedWriter());
        visitor.contribute(new TryWriter());
        visitor.contribute(new VariableWriter());
        visitor.contribute(new WhileLoopWriter());
        visitor.contribute(new ThrowWriter());
        this.addMethodCallTemplates(visitor);
        this.addFieldTemplates(visitor);
        this.addJavaDocCommentFilter(visitor);
    }

    private void addJavaDocCommentFilter(WriterVisitor<JS> visitor) {
        CommentWriter cw = new CommentWriter();
        visitor.addFilter(cw, ClassTree.class);
        visitor.addFilter(cw, MethodTree.class);
        visitor.addFilter(cw, VariableTree.class);
    }

    private DiscriminatorKey template(String name) {
        return DiscriminatorKey.of(MethodInvocationWriter.class.getSimpleName(), name);
    }

    private DiscriminatorKey assignTemplate(String name) {
        return DiscriminatorKey.of(AssignmentWriter.class.getSimpleName(), name);
    }

    private DiscriminatorKey unaryTemplate(String name) {
        return DiscriminatorKey.of(UnaryWriter.class.getSimpleName(), name);
    }

    private DiscriminatorKey compoundAssignTemplate(String name) {
        return DiscriminatorKey.of(CompoundAssignmentWriter.class.getSimpleName(), name);
    }

    private DiscriminatorKey identifierTemplate(String name) {
        return DiscriminatorKey.of(IdentifierWriter.class.getSimpleName(), name);
    }

    private DiscriminatorKey memberSelectTemplate(String name) {
        return DiscriminatorKey.of(MemberSelectWriter.class.getSimpleName(), name);
    }

    protected void addMethodCallTemplates(WriterVisitor<JS> visitor) {
        visitor.contribute(this.template("adapter"), new AdapterTemplate());
        visitor.contribute(this.template("array"), new ArrayTemplate());
        visitor.contribute(this.template("delete"), new DeleteTemplate());
        visitor.contribute(this.template("get"), new GetTemplate());
        visitor.contribute(this.template("invoke"), new InvokeTemplate());
        visitor.contribute(this.template("js"), new JsTemplate());
        visitor.contribute(this.template("map"), new MapTemplate());
        visitor.contribute(this.template("toProperty"), new MethodToPropertyTemplate());
        visitor.contribute(this.template("or"), new OrTemplate());
        visitor.contribute(this.template("prefix"), new PrefixTemplate());
        visitor.contribute(this.template("suffix"), new SuffixTemplate());
        visitor.contribute(this.template("properties"), new PropertiesTemplate());
        visitor.contribute(this.template("put"), new PutTemplate());
        visitor.contribute(this.template("set"), new SetTemplate());
        visitor.contribute(this.template("typeOf"), new TypeOfTemplate());
        visitor.contribute(this.template("assert"), new AssertTemplate());
        visitor.contribute(this.template("none"), new DefaultTemplate());
    }

    protected void addFieldTemplates(WriterVisitor<JS> visitor) {
        String none = "none";
        String property = "property";
        String gproperty = "gproperty";
        String path = "path";
        visitor.contribute(this.assignTemplate(none), new DefaultAssignmentTemplate());
        visitor.contribute(this.assignTemplate(property), new SetterAssignmentTemplate());
        visitor.contribute(this.assignTemplate(gproperty), new GlobalSetterAssignmentTemplate());
        visitor.contribute(this.unaryTemplate(none), new DefaultUnaryTemplate());
        visitor.contribute(this.unaryTemplate(property), new SetterUnaryTemplate());
        visitor.contribute(this.unaryTemplate(gproperty), new GlobalSetterUnaryTemplate());
        visitor.contribute(this.compoundAssignTemplate(none), new DefaultCompoundAssignmentTemplate());
        visitor.contribute(this.compoundAssignTemplate(property), new SetterCompoundAssignmentTemplate());
        visitor.contribute(this.compoundAssignTemplate(gproperty), new GlobalSetterCompoundAssignmentTemplate());
        visitor.contribute(this.identifierTemplate(none), new DefaultIdentifierTemplate());
        visitor.contribute(this.identifierTemplate(property), new GetterIdentifierTemplate());
        visitor.contribute(this.identifierTemplate(gproperty), new GlobalGetterIdentifierTemplate());
        visitor.contribute(this.memberSelectTemplate(none), new DefaultMemberSelectTemplate());
        visitor.contribute(this.memberSelectTemplate(property), new GetterMemberSelectTemplate());
        visitor.contribute(this.memberSelectTemplate(gproperty), new GlobalGetterMemberSelectTemplate());
        visitor.contribute(this.memberSelectTemplate(path), new PathGetterMemberSelectTemplate());
    }

    @Override
    public boolean loadByDefault() {
        return true;
    }
}

