/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.sourcemap;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.google.debugging.sourcemap.SourceMapConsumerFactory;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapping;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.utils.PreConditions;

public class JavascriptToJava {
    private static final Pattern STACKTRACE_UNIVERSAL_JS_PATTERN = Pattern.compile("\\s*(?:at)?\\s*(?:([\\w$]+)\\.)*(\\w*\\s?\\w+)[\\s\\@]?\\(?([^\\)]+)\\)?");
    private static final Pattern STACKTRACE_FIREFOX_JS_PATTERN = Pattern.compile("(?:(\\w+)\\.)*(\\w*\\s?\\w+)\\@([^\\)]+)");
    private static final int STACKTRACE_GROUP_METHOD = 2;
    private static final int STACKTRACE_GROUP_LOCATION = 3;
    private final ClassLoader classLoader;

    public JavascriptToJava(ClassLoader testClassLoader) {
        this.classLoader = testClassLoader;
    }

    public int getJavaLine(String path, int lineNumber) {
        String sourceMapFile = path.replaceAll("\\.js$", ".map");
        URL url = this.classLoader.getResource(sourceMapFile.substring(1));
        if (url == null) {
            return lineNumber;
        }
        try {
            String contents = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            SourceMapping mapping = SourceMapConsumerFactory.parse((String)contents);
            return mapping.getMappingForLine(lineNumber, 1).getLineNumber();
        }
        catch (IOException e) {
            throw new STJSRuntimeException(e);
        }
        catch (SourceMapParseException e) {
            throw new STJSRuntimeException(e);
        }
    }

    private String getClassName(String propertiesFile) {
        String string;
        block8: {
            InputStream in;
            block6: {
                String string2;
                block7: {
                    in = null;
                    in = this.classLoader.getResourceAsStream(propertiesFile.substring(1));
                    if (in != null) break block6;
                    string2 = null;
                    if (in == null) break block7;
                    Closeables.closeQuietly((InputStream)in);
                }
                return string2;
            }
            try {
                Properties p = new Properties();
                p.load(in);
                string = p.getProperty("class");
                if (in == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw new STJSRuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        Closeables.closeQuietly(in);
                    }
                    throw throwable;
                }
            }
            Closeables.closeQuietly((InputStream)in);
        }
        return string;
    }

    private StackTraceElement buildStacktraceElement(String stacktraceLine) {
        Matcher m = STACKTRACE_UNIVERSAL_JS_PATTERN.matcher(stacktraceLine);
        if (!m.matches()) {
            throw new STJSRuntimeException("Unknown location format:" + stacktraceLine);
        }
        try {
            String methodName = m.group(2);
            URL url = new URL(m.group(3));
            String file = url.getFile();
            String[] fileParts = file.split(":");
            String jsSourceFile = fileParts[0];
            String sourceFile = jsSourceFile.replaceAll("\\.js$", ".java");
            String cleanJsPath = url.getPath().split(":")[0];
            int jsLineNumber = Integer.parseInt(fileParts[1]);
            int line = this.getJavaLine(cleanJsPath, jsLineNumber);
            String stjsPropertyFile = cleanJsPath.replaceAll("\\.js$", ".stjs");
            String className = this.getClassName(stjsPropertyFile);
            if (className == null) {
                className = "<Unknown class>";
                sourceFile = jsSourceFile;
            }
            return new StackTraceElement(className, methodName, sourceFile, line);
        }
        catch (MalformedURLException e) {
            throw new STJSRuntimeException(e);
        }
    }

    public StackTraceElement[] buildStacktrace(String javascriptStacktrace, String lineSeparator) {
        PreConditions.checkNotNull(javascriptStacktrace);
        String[] linesOriginal = javascriptStacktrace.split(lineSeparator);
        String[] lines = this.extractStacktrace(linesOriginal);
        StackTraceElement[] stackTrace = new StackTraceElement[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            stackTrace[i] = this.buildStacktraceElement(lines[i]);
        }
        return stackTrace;
    }

    private String[] extractStacktrace(String[] linesOriginal) {
        if (linesOriginal.length > 1 && !STACKTRACE_FIREFOX_JS_PATTERN.matcher(linesOriginal[0]).matches()) {
            return Arrays.copyOfRange(linesOriginal, 1, linesOriginal.length);
        }
        return linesOriginal;
    }
}

