/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.utils;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.stjs.generator.utils.PreConditions;

public final class Lists {
    private Lists() {
    }

    public static <T> T getOnlyElement(Iterable<T> elems) {
        if (elems instanceof List) {
            List list = (List)elems;
            PreConditions.checkState(list.size() == 1, "elems must contain exactly one element", new Object[0]);
            return (T)list.get(0);
        }
        Iterator<T> iterator = elems.iterator();
        PreConditions.checkState(iterator.hasNext(), "elems must not be empty", new Object[0]);
        T obj = iterator.next();
        PreConditions.checkState(!iterator.hasNext(), "elems must contain exactly one element", new Object[0]);
        return obj;
    }

    public static <T> List<T> union(final List<T> list1, final List<T> list2) {
        return new AbstractList<T>(){

            @Override
            public T get(int i) {
                if (i < list1.size()) {
                    return list1.get(i);
                }
                return list2.get(i - list1.size());
            }

            @Override
            public int size() {
                return list1.size() + list2.size();
            }
        };
    }

    public static <T> List<T> append(List<T> coll, T appendee) {
        return Lists.union(coll, Collections.singletonList(appendee));
    }

    public static <T> boolean isNullOrEmpty(Collection<T> list) {
        return list == null || list.isEmpty();
    }
}

