/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.stjs.generator.utils.PreConditions;

public abstract class Option<T>
implements Iterable<T> {
    private static final Option<?> NONE = new Option<Object>(){

        @Override
        public Object getOrNull() {
            return null;
        }

        @Override
        public Object getOrElse(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public Object getOrThrow() {
            return this.getOrThrow(new IllegalArgumentException());
        }

        @Override
        public Object getOrThrow(String message) {
            return this.getOrThrow(new IllegalArgumentException(message));
        }

        @Override
        public <E extends Throwable> Object getOrThrow(E e) throws E {
            throw e;
        }

        @Override
        public String toStringOr(String defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public String toString() {
            return "Option.None";
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }
            };
        }
    };

    public abstract T getOrNull();

    public abstract T getOrElse(T var1);

    public abstract T getOrThrow();

    public abstract T getOrThrow(String var1);

    public abstract <E extends Throwable> T getOrThrow(E var1) throws E;

    public abstract String toStringOr(String var1);

    public abstract boolean isEmpty();

    public boolean isDefined() {
        return !this.isEmpty();
    }

    public static <T> Option<T> none() {
        return NONE;
    }

    public static <T> Option<T> some(T t) {
        return new Some(t);
    }

    public static <T> Option<T> of(T t) {
        return t == null ? Option.none() : Option.some(t);
    }

    private static final class Some<U>
    extends Option<U> {
        private final U u;

        private Some(U u) {
            PreConditions.checkNotNull(u);
            this.u = u;
        }

        @Override
        public U getOrNull() {
            return this.u;
        }

        @Override
        public U getOrElse(U defaultValue) {
            return this.u;
        }

        @Override
        public U getOrThrow() {
            return this.u;
        }

        @Override
        public U getOrThrow(String message) {
            return this.u;
        }

        @Override
        public <E extends Throwable> U getOrThrow(E e) throws E {
            return this.u;
        }

        @Override
        public String toStringOr(String defaultValue) {
            return this.u.toString();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int hashCode() {
            return this.u.hashCode();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Some)) {
                return false;
            }
            return this.u.equals(((Some)that).u);
        }

        public String toString() {
            return String.format("Option.Some(%s)", this.u);
        }

        @Override
        public Iterator<U> iterator() {
            return new Iterator<U>(){
                private boolean produce = true;

                @Override
                public boolean hasNext() {
                    return this.produce;
                }

                @Override
                public U next() {
                    if (this.produce) {
                        this.produce = false;
                        return Some.this.u;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }
            };
        }
    }
}

