/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.visitor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.visitor.DiscriminatorKey;
import org.stjs.generator.visitor.TreePathHolder;
import org.stjs.generator.visitor.VisitorContributor;
import org.stjs.generator.visitor.VisitorFilterContributor;

public class TreePathScannerContributors<R, P extends TreePathHolder, V extends TreePathScannerContributors<R, P, V>>
extends TreeScanner<R, P> {
    private static final Logger LOG = Logger.getLogger(TreePathScannerContributors.class.getName());
    private final Map<Class<?>, ContributorHolder<? extends Tree>> contributors = Maps.newHashMap();
    private final Map<DiscriminatorKey, ContributorHolder<? extends Tree>> contributorsWithDiscriminator = Maps.newHashMap();
    private boolean continueScanning;
    private boolean onlyOneFinalContributor;

    public TreePathScannerContributors() {
    }

    public TreePathScannerContributors(TreePathScannerContributors<R, P, V> copy) {
        this.contributors.clear();
        for (Map.Entry<Class<?>, ContributorHolder<Tree>> entry : copy.contributors.entrySet()) {
            this.contributors.put(entry.getKey(), new ContributorHolder<Tree>(entry.getValue()));
        }
        this.contributorsWithDiscriminator.clear();
        for (Map.Entry<Object, ContributorHolder<? extends Tree>> entry : copy.contributorsWithDiscriminator.entrySet()) {
            this.contributorsWithDiscriminator.put((DiscriminatorKey)entry.getKey(), new ContributorHolder<Tree>(entry.getValue()));
        }
        this.continueScanning = copy.continueScanning;
        this.onlyOneFinalContributor = copy.continueScanning;
    }

    public boolean isContinueScanning() {
        return this.continueScanning;
    }

    public void setContinueScanning(boolean continueScanning) {
        this.continueScanning = continueScanning;
    }

    public boolean isOnlyOneFinalContributor() {
        return this.onlyOneFinalContributor;
    }

    public void setOnlyOneFinalContributor(boolean onlyOneFinalContributor) {
        this.onlyOneFinalContributor = onlyOneFinalContributor;
    }

    private <T extends Tree> ContributorHolder<T> getHolder(Class<?> contributorClass) {
        Class<?> treeNodeClass = this.getTreeNodeClass(contributorClass);
        if (treeNodeClass == null) {
            throw new STJSRuntimeException("Cannot guess the tree node class from the contributor " + contributorClass + ". ");
        }
        ContributorHolder<Tree> holder = this.contributors.get(treeNodeClass);
        if (holder == null) {
            holder = new ContributorHolder();
            this.contributors.put(treeNodeClass, holder);
        }
        return holder;
    }

    public <T extends Tree, C extends VisitorContributor<T, R, P, V>, N> void contribute(@Nonnull C contributor) {
        if (this.onlyOneFinalContributor) {
            this.getHolder(contributor.getClass()).setContributor(contributor);
        } else {
            this.getHolder(contributor.getClass()).addContributor(contributor);
        }
    }

    public <T extends Tree, C extends VisitorContributor<T, R, P, V>, N> void contribute(@Nonnull C contributor, Class<T> nodeClass) {
        if (this.onlyOneFinalContributor) {
            this.getHolder(nodeClass).setContributor(contributor);
        } else {
            this.getHolder(nodeClass).addContributor(contributor);
        }
    }

    public <T extends Tree, F extends VisitorFilterContributor<T, R, P, V>> void addFilter(@Nonnull F filter) {
        this.getHolder(filter.getClass()).addFilter(filter);
    }

    public <T extends Tree, F extends VisitorFilterContributor<T, R, P, V>> void addFilter(@Nonnull F filter, Class<?> nodeClass) {
        this.getHolder(nodeClass).addFilter(filter);
    }

    private <T extends Tree> ContributorHolder<T> getHolder(DiscriminatorKey discriminatorKey) {
        ContributorHolder<Tree> holder = this.contributorsWithDiscriminator.get(discriminatorKey);
        if (holder == null) {
            holder = new ContributorHolder();
            this.contributorsWithDiscriminator.put(discriminatorKey, holder);
        }
        return holder;
    }

    public <T extends Tree, C extends VisitorContributor<T, R, P, V>> void contribute(@Nonnull DiscriminatorKey discriminatorKey, @Nonnull C contributor) {
        if (this.onlyOneFinalContributor) {
            this.getHolder(discriminatorKey).setContributor(contributor);
        } else {
            this.getHolder(discriminatorKey).addContributor(contributor);
        }
    }

    public <T extends Tree, F extends VisitorFilterContributor<T, R, P, V>> void addFilter(@Nonnull DiscriminatorKey discriminatorKey, @Nonnull F filter) {
        this.getHolder(discriminatorKey).addFilter(filter);
    }

    private Class<?> getTreeNodeClassFromInteface(Type iface) {
        if (iface instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)iface;
            for (Type arg : ptype.getActualTypeArguments()) {
                if (!(arg instanceof Class) || !Tree.class.isAssignableFrom((Class)arg)) continue;
                return (Class)arg;
            }
        }
        return null;
    }

    private Class<?> getTreeNodeClass(Class<?> clazz) {
        Type[] interfaces;
        if (Tree.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        for (Type iface : interfaces = clazz.getGenericInterfaces()) {
            Class<?> nodeClass = this.getTreeNodeClassFromInteface(iface);
            if (nodeClass == null) continue;
            return nodeClass;
        }
        return null;
    }

    private Class<?> getTreeInteface(Class<?> clazz) {
        Type[] interfaces;
        for (Type iface : interfaces = clazz.getGenericInterfaces()) {
            Class type;
            if (!(iface instanceof Class) || !Tree.class.isAssignableFrom(type = (Class)iface)) continue;
            return type;
        }
        return null;
    }

    public <T extends Tree> R forward(DiscriminatorKey discriminator, T node, P param) {
        VisitorContributor contributor = this.contributorsWithDiscriminator.get(discriminator);
        if (contributor != null) {
            return contributor.visit(this, node, param);
        }
        LOG.warning("No contributor found with key:" + discriminator);
        return null;
    }

    protected <T extends Tree> R visit(T node, P p, R r) {
        R lastR;
        if (node == null) {
            return r;
        }
        ContributorHolder<? extends Tree> holder = this.contributors.get(this.getTreeInteface(node.getClass()));
        R r2 = lastR = holder == null ? null : (R)holder.visit(this, node, p);
        if (this.continueScanning) {
            lastR = node.accept(this, p);
        }
        return lastR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R scan(Tree tree, P p) {
        if (tree == null) {
            return null;
        }
        TreePath prev = p.getCurrentPath();
        p.setCurrentPath(new TreePath(prev, tree));
        try {
            R r = this.visit(tree, p, null);
            return r;
        }
        finally {
            p.setCurrentPath(prev);
        }
    }

    private class FilterChain<T extends Tree>
    implements VisitorContributor<T, R, P, V> {
        private final ContributorHolder<T> holder;
        private int nextFilter;

        public FilterChain(ContributorHolder<T> holder) {
            this.holder = holder;
        }

        @Override
        public R visit(V visitor, T tree, P p) {
            if (this.nextFilter < this.holder.getFilters().size()) {
                VisitorFilterContributor next = this.holder.getFilters().get(this.nextFilter);
                ++this.nextFilter;
                return next.visit(visitor, tree, p, this);
            }
            return this.holder.visitContributors(visitor, tree, p);
        }
    }

    private class ContributorHolder<T extends Tree>
    implements VisitorContributor<T, R, P, V> {
        private final List<VisitorFilterContributor<T, R, P, V>> filters = Lists.newArrayList();
        private final List<VisitorContributor<T, R, P, V>> contributors = Lists.newArrayList();

        public ContributorHolder() {
        }

        public ContributorHolder(ContributorHolder<T> copy) {
            this.filters.addAll(copy.filters);
            this.contributors.addAll(copy.contributors);
        }

        public void addFilter(VisitorFilterContributor<T, R, P, V> f) {
            this.filters.add(f);
        }

        public void addContributor(VisitorContributor<T, R, P, V> c) {
            this.contributors.add(c);
        }

        public void setContributor(VisitorContributor<T, R, P, V> c) {
            this.contributors.clear();
            this.contributors.add(c);
        }

        public List<VisitorFilterContributor<T, R, P, V>> getFilters() {
            return this.filters;
        }

        @Override
        public R visit(V visitor, T tree, P p) {
            if (!this.filters.isEmpty()) {
                return new FilterChain<T>(this).visit(visitor, tree, p);
            }
            return this.visitContributors(visitor, tree, p);
        }

        public R visitContributors(V visitor, T tree, P p) {
            Object lastR = null;
            for (VisitorContributor vc : this.contributors) {
                lastR = vc.visit(visitor, tree, p);
            }
            return lastR;
        }
    }
}

