/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.declaration;

import com.google.common.base.Defaults;
import com.google.common.primitives.Primitives;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.AssignOperator;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.declaration.AbstractMemberWriter;

public class FieldWriter<JS>
extends AbstractMemberWriter<JS>
implements WriterContributor<VariableTree, JS> {
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap();

    private Class<?> primitiveClass(TypeMirror type) {
        Class<?> cls = PRIMITIVE_CLASSES.get(type.toString());
        if (cls == null) {
            throw new STJSRuntimeException("Cannot load class " + type);
        }
        return cls;
    }

    private JS getPrimitiveDefaultValue(Element element, GenerationContext<JS> context) {
        Object defaultValue = Defaults.defaultValue(this.primitiveClass(element.asType()));
        if (defaultValue instanceof Number) {
            return context.js().number((Number)defaultValue);
        }
        if (defaultValue instanceof Character) {
            return context.js().character(defaultValue.toString());
        }
        if (defaultValue instanceof Boolean) {
            return context.js().keyword(Boolean.TRUE.equals(defaultValue) ? Keyword.TRUE : Keyword.FALSE);
        }
        return context.js().keyword(Keyword.NULL);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, VariableTree tree, GenerationContext<JS> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (MemberWriters.shouldSkip(tw)) {
            return null;
        }
        context.getCurrentWrapper().child(tree.getType()).getTypeName(DependencyType.OTHER);
        Object initializer = null;
        initializer = tree.getInitializer() == null ? (tw.isPrimitiveType() ? (Object)this.getPrimitiveDefaultValue(tw.getElement(), context) : (Object)context.js().keyword(Keyword.NULL)) : (Object)visitor.scan((Tree)tree.getInitializer(), context);
        String fieldName = tree.getName().toString();
        if (tw.getEnclosingType().isGlobal()) {
            return context.js().variableDeclaration(true, fieldName, initializer);
        }
        JS member = context.js().property(this.getMemberTarget(tw), fieldName);
        return context.js().expressionStatement(context.js().assignment(AssignOperator.ASSIGN, member, initializer));
    }

    static {
        for (Class cls : Primitives.allPrimitiveTypes()) {
            PRIMITIVE_CLASSES.put(cls.getName(), cls);
        }
    }
}

