/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.declaration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.AssignOperator;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.declaration.AbstractMemberWriter;

public class MethodWriter<JS>
extends AbstractMemberWriter<JS>
implements WriterContributor<MethodTree, JS> {
    private static String changeName(String name) {
        if (name.equals("arguments")) {
            return "_" + name;
        }
        return name;
    }

    private boolean isMethodOfJavascriptFunction(TreeWrapper<Tree, JS> treeWrapper) {
        TreeWrapper parent = treeWrapper.parent().parent();
        if (parent.getTree() instanceof NewClassTree) {
            return parent.child(((NewClassTree)parent.getTree()).getIdentifier()).isJavaScriptFunction();
        }
        return false;
    }

    private String getAnonymousTypeConstructorName(MethodTree tree, GenerationContext<JS> context) {
        if (!JavaNodes.isConstructor(tree)) {
            return null;
        }
        TypeElement typeElement = TreeUtils.elementFromDeclaration((ClassTree)context.getCurrentPath().getParentPath().getLeaf());
        boolean anonymous = typeElement.getSimpleName().toString().isEmpty();
        if (anonymous) {
            return InternalUtils.getSimpleName(typeElement);
        }
        return null;
    }

    public static <JS> List<JS> getParams(List<? extends VariableTree> treeParams, GenerationContext<JS> context) {
        ArrayList<JS> params = new ArrayList<JS>();
        for (VariableTree variableTree : treeParams) {
            params.add(context.js().name(MethodWriter.changeName(variableTree.getName().toString())));
        }
        return params;
    }

    public static int getTHISParamPos(List<? extends VariableTree> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            VariableTree param = parameters.get(i);
            if (!"THIS".equals(param.getName().toString())) continue;
            return i;
        }
        return -1;
    }

    protected boolean accept(TreeWrapper<MethodTree, JS> tw) {
        if (tw.isNative()) {
            return false;
        }
        return !MemberWriters.shouldSkip(tw);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, MethodTree tree, GenerationContext<JS> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (!this.accept(tw)) {
            return null;
        }
        List<JS> params = MethodWriter.getParams(tree.getParameters(), context);
        Object body = visitor.scan((Tree)tree.getBody(), context);
        String name = this.getAnonymousTypeConstructorName(tree, context);
        JS decl = context.js().function(name, params, body);
        if (!JavaNodes.isConstructor(tree) && !this.isMethodOfJavascriptFunction(context.getCurrentWrapper())) {
            String methodName = context.getNames().getMethodName(context, tree, context.getCurrentPath());
            if (tw.getEnclosingType().isGlobal()) {
                return context.js().variableDeclaration(true, methodName, decl);
            }
            JS member = context.js().property(this.getMemberTarget(tw), methodName);
            return context.js().expressionStatement(context.js().assignment(AssignOperator.ASSIGN, member, decl));
        }
        return decl;
    }
}

