/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.expression;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.JavaScriptBuilder;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.javascript.NameValue;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.declaration.MethodWriter;
import org.stjs.generator.writer.templates.MethodToPropertyTemplate;

public class NewClassWriter<JS>
implements WriterContributor<NewClassTree, JS> {
    public static BlockTree getDoubleBracesBlock(NewClassTree tree) {
        if (tree.getClassBody() == null) {
            return null;
        }
        for (Tree tree2 : tree.getClassBody().getMembers()) {
            BlockTree block;
            if (!(tree2 instanceof BlockTree) || (block = (BlockTree)tree2).isStatic()) continue;
            return block;
        }
        return null;
    }

    private String getPropertyName(ExpressionTree var) {
        if (var instanceof IdentifierTree) {
            return ((IdentifierTree)var).getName().toString();
        }
        if (var instanceof MemberSelectTree) {
            return ((MemberSelectTree)var).getIdentifier().toString();
        }
        return null;
    }

    private JS getObjectInitializer(WriterVisitor<JS> visitor, TreeWrapper<NewClassTree, JS> tw) {
        NewClassTree tree = tw.getTree();
        BlockTree initBlock = NewClassWriter.getDoubleBracesBlock(tree);
        if (initBlock == null && !tw.child(tree.getIdentifier()).isSyntheticType()) {
            return null;
        }
        ArrayList props = new ArrayList();
        if (initBlock != null) {
            for (StatementTree statementTree : initBlock.getStatements()) {
                ExpressionTree expr = ((ExpressionStatementTree)statementTree).getExpression();
                if (expr instanceof AssignmentTree) {
                    AssignmentTree assign = (AssignmentTree)expr;
                    props.add(NameValue.of(this.getPropertyName(assign.getVariable()), visitor.scan((Tree)assign.getExpression(), tw.getContext())));
                    continue;
                }
                MethodInvocationTree meth = (MethodInvocationTree)expr;
                String propertyName = MethodToPropertyTemplate.getPropertyName(meth);
                Object value = visitor.scan((Tree)meth.getArguments().get(0), tw.getContext());
                props.add(NameValue.of(propertyName, value));
            }
        }
        return tw.getContext().js().object(props);
    }

    private JS getInlineFunctionDeclaration(WriterVisitor<JS> visitor, TreeWrapper<NewClassTree, JS> tw) {
        if (!tw.child(tw.getTree().getIdentifier()).isJavaScriptFunction()) {
            return null;
        }
        Tree method = tw.getTree().getClassBody().getMembers().get(1);
        Object func = visitor.scan(method, tw.getContext());
        int specialThisParamPos = MethodWriter.getTHISParamPos(((MethodTree)method).getParameters());
        if (specialThisParamPos >= 0) {
            JavaScriptBuilder<JS> js = tw.getContext().js();
            JS target = js.keyword(Keyword.THIS);
            JS stjsBind = js.property(js.name("stjs"), "bind");
            return (JS)js.functionCall(stjsBind, Arrays.asList(target, func, js.number(specialThisParamPos)));
        }
        return (JS)func;
    }

    private JS getAnonymousClassDeclaration(WriterVisitor<JS> visitor, NewClassTree tree, GenerationContext<JS> context) {
        if (tree.getClassBody() == null) {
            return null;
        }
        Object typeDeclaration = visitor.scan((Tree)tree.getClassBody(), context);
        return context.js().newExpression(context.js().paren(typeDeclaration), this.arguments(visitor, tree, context));
    }

    private List<JS> arguments(WriterVisitor<JS> visitor, NewClassTree tree, GenerationContext<JS> context) {
        ArrayList arguments = new ArrayList();
        for (Tree tree2 : tree.getArguments()) {
            arguments.add(visitor.scan(tree2, context));
        }
        return arguments;
    }

    private JS getRegularNewExpression(WriterVisitor<JS> visitor, NewClassTree tree, GenerationContext<JS> context) {
        Element type = TreeUtils.elementFromUse(tree.getIdentifier());
        JS typeName = context.js().name(context.getNames().getTypeName(context, type, DependencyType.STATIC));
        return context.js().newExpression(typeName, this.arguments(visitor, tree, context));
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, NewClassTree tree, GenerationContext<JS> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        JS js = this.getInlineFunctionDeclaration(visitor, tw);
        if (js != null) {
            return js;
        }
        js = this.getObjectInitializer(visitor, tw);
        if (js != null) {
            return js;
        }
        js = this.getAnonymousClassDeclaration(visitor, tree, context);
        if (js != null) {
            return js;
        }
        return this.getRegularNewExpression(visitor, tree, context);
    }
}

