/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.statement;

import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;
import org.stjs.generator.writer.statement.MultipleVariableWriter;

public class ForLoopWriter<JS>
implements WriterContributor<ForLoopTree, JS> {
    private final MultipleVariableWriter<JS> initializerWriter = new MultipleVariableWriter();

    private JS initializer(WriterVisitor<JS> visitor, ForLoopTree tree, GenerationContext<JS> p) {
        if (tree.getInitializer().isEmpty()) {
            return p.js().emptyExpression();
        }
        if (tree.getInitializer().get(0) instanceof VariableTree) {
            return this.initializerWriter.visit(visitor, tree.getInitializer(), p, false);
        }
        ArrayList nodes = new ArrayList();
        for (Tree tree2 : tree.getInitializer()) {
            if (!(tree2 instanceof ExpressionStatementTree)) continue;
            nodes.add(visitor.scan((Tree)((ExpressionStatementTree)tree2).getExpression(), p));
        }
        return p.js().asExpressionList(nodes);
    }

    private JS condition(WriterVisitor<JS> visitor, ForLoopTree tree, GenerationContext<JS> p) {
        if (tree.getCondition() != null) {
            return (JS)visitor.scan((Tree)tree.getCondition(), p);
        }
        return null;
    }

    private JS update(WriterVisitor<JS> visitor, ForLoopTree tree, GenerationContext<JS> p) {
        ArrayList jsNodes = new ArrayList();
        for (ExpressionStatementTree expressionStatementTree : tree.getUpdate()) {
            jsNodes.add(visitor.scan((Tree)expressionStatementTree.getExpression(), p));
        }
        return p.js().asExpressionList(jsNodes);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, ForLoopTree tree, GenerationContext<JS> context) {
        JS init = this.initializer(visitor, tree, context);
        JS condition = this.condition(visitor, tree, context);
        JS update = this.update(visitor, tree, context);
        Object body = visitor.scan((Tree)tree.getStatement(), context);
        return context.withPosition(tree, context.js().forLoop(init, condition, update, body));
    }
}

