/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates.fields;

import com.sun.source.tree.IdentifierTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.name.DependencyType;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class DefaultIdentifierTemplate<JS>
implements WriterContributor<IdentifierTree, JS> {
    private JS visitField(IdentifierTree tree, GenerationContext<JS> context) {
        return context.js().property(MemberWriters.buildTarget(context.getCurrentWrapper()), tree.getName());
    }

    private JS visitEnumConstant(Element def, IdentifierTree tree, GenerationContext<JS> context) {
        JS target = context.js().name(context.getNames().getTypeName(context, def.getEnclosingElement(), DependencyType.STATIC));
        return context.js().property(target, tree.getName());
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, IdentifierTree tree, GenerationContext<JS> context) {
        String name = tree.getName().toString();
        if ("this".equals(name)) {
            return context.js().keyword(Keyword.THIS);
        }
        TreeWrapper tw = context.getCurrentWrapper();
        Element def = tw.getElement();
        if (def.getKind() == ElementKind.PACKAGE) {
            return null;
        }
        if (def.getKind() == ElementKind.FIELD) {
            return this.visitField(tree, context);
        }
        if (def.getKind() == ElementKind.ENUM_CONSTANT) {
            return this.visitEnumConstant(def, tree, context);
        }
        if (ElementUtils.isTypeKind(def)) {
            if (tw.isGlobal()) {
                context.getNames().getTypeName(context, def, DependencyType.STATIC);
                return null;
            }
            name = context.getNames().getTypeName(context, def, DependencyType.STATIC);
        }
        return context.js().name(name);
    }
}

