/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.writer.templates.fields;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.javac.ElementUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.javascript.Keyword;
import org.stjs.generator.utils.JavaNodes;
import org.stjs.generator.writer.MemberWriters;
import org.stjs.generator.writer.WriterContributor;
import org.stjs.generator.writer.WriterVisitor;

public class PathGetterMemberSelectTemplate<JS>
implements WriterContributor<MemberSelectTree, JS> {
    private JS getTarget(WriterVisitor<JS> visitor, TreeWrapper<ExpressionTree, JS> currentWrapper, ExpressionTree tree, GenerationContext<JS> context, boolean targetIsPartOfPath) {
        if (!targetIsPartOfPath) {
            return (JS)visitor.scan((Tree)currentWrapper.getTree(), context);
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree ms = (MemberSelectTree)tree;
            if (JavaNodes.isSuper(ms.getExpression())) {
                return context.js().keyword(Keyword.THIS);
            }
            TreeWrapper tw = context.getCurrentWrapper();
            ExpressionTree target = ms.getExpression();
            Object targetJS = visitor.scan((Tree)target, context);
            if (tw.isStatic() && !ElementUtils.isTypeKind(tw.child(target).getElement())) {
                targetJS = tw.getContext().js().property(targetJS, "constructor");
            }
            return (JS)targetJS;
        }
        return MemberWriters.buildTarget(context.getCurrentWrapper());
    }

    private String ident(Tree tree) {
        if (tree instanceof IdentifierTree) {
            return ((IdentifierTree)tree).getName().toString();
        }
        if (tree instanceof MemberSelectTree) {
            return ((MemberSelectTree)tree).getIdentifier().toString();
        }
        throw new STJSRuntimeException("Unexpected node type while building path:" + tree);
    }

    private boolean checkTemplateParams(String[] params, GenerationContext<JS> context, TreeWrapper<ExpressionTree, JS> currentWrapper) {
        if (params == null || params.length == 0) {
            context.addError(currentWrapper.getTree(), "The 'path' template needs a parameter designating the method to be called, like this @Template(\"path(methodName)\")");
            return false;
        }
        return true;
    }

    private JS getPath(WriterVisitor<JS> visitor, TreeWrapper<ExpressionTree, JS> tree, GenerationContext<JS> context) {
        String path = "";
        TreeWrapper<ExpressionTree, JS> currentWrapper = tree;
        String[] params = null;
        boolean targetIsPartOfPath = false;
        while (true) {
            ExpressionTree currentTree = currentWrapper.getTree();
            String template = currentWrapper.getFieldTemplate();
            if (!"path".equals(template)) {
                targetIsPartOfPath = false;
                break;
            }
            params = currentWrapper.getFieldTemplateParameters();
            path = this.ident(currentTree) + (path.length() > 0 ? "." + path : "");
            if (!(currentTree instanceof MemberSelectTree)) {
                targetIsPartOfPath = true;
                break;
            }
            currentWrapper = currentWrapper.child(((MemberSelectTree)currentTree).getExpression());
        }
        if (!this.checkTemplateParams(params, context, currentWrapper)) {
            return null;
        }
        JS target = this.getTarget(visitor, currentWrapper, currentWrapper.getTree(), context, targetIsPartOfPath);
        String methodName = params[0];
        JS pathString = context.js().string(path);
        List<JS> arguments = Collections.singletonList(pathString);
        return context.js().functionCall(context.js().property(target, methodName), arguments);
    }

    @Override
    public JS visit(WriterVisitor<JS> visitor, MemberSelectTree tree, GenerationContext<JS> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        Element element = tw.getElement();
        if (element == null || element.getKind() == ElementKind.PACKAGE) {
            return null;
        }
        return this.getPath(visitor, tw, context);
    }
}

