/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class CheckRequiresForConstructors
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final CheckLevel level;
    static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "''{0}'' used but not goog.require''d");

    CheckRequiresForConstructors(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
        this.level = level;
    }

    @Override
    public void process(Node externs, Node root) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        new NodeTraversal(this.compiler, callback).traverseRoots(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        new NodeTraversal(this.compiler, callback).traverseWithScope(scriptRoot, SyntacticScopeCreator.generateUntypedTopScope(this.compiler));
    }

    private static boolean isClassName(String name) {
        return name != null && name.length() > 1 && Character.isUpperCase(name.charAt(0)) && !name.equals(name.toUpperCase());
    }

    private static String getOutermostClassName(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (!CheckRequiresForConstructors.isClassName(part)) continue;
            return className.substring(0, className.indexOf(part) + part.length());
        }
        return null;
    }

    private class CheckRequiresForConstructorsCallback
    implements NodeTraversal.Callback {
        private final Set<String> constructors = new HashSet<String>();
        private final Set<String> requires = new HashSet<String>();
        private final List<Node> newAndImplementsNodes = new ArrayList<Node>();

        private CheckRequiresForConstructorsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || !parent.isScript() || !t.getInput().isExtern();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 86: 
                case 118: {
                    this.maybeAddConstructor(t, n);
                    break;
                }
                case 105: {
                    if (NodeUtil.isStatement(n)) {
                        this.maybeAddConstructor(t, n);
                    }
                    this.maybeAddImplements(t, n);
                    break;
                }
                case 37: {
                    this.visitCallNode(n, parent);
                    break;
                }
                case 132: {
                    this.visitScriptNode(t);
                    break;
                }
                case 30: {
                    this.visitNewNode(t, n);
                }
            }
        }

        private void visitScriptNode(NodeTraversal t) {
            HashSet<String> classNames = new HashSet<String>();
            for (Node node : this.newAndImplementsNodes) {
                boolean notProvidedByRequires;
                String className = node.isNew() ? node.getFirstChild().getQualifiedName() : node.getString();
                String outermostClassName = CheckRequiresForConstructors.getOutermostClassName(className);
                boolean notProvidedByConstructors = this.constructors == null || !this.constructors.contains(className);
                boolean bl = notProvidedByRequires = this.requires == null || !this.requires.contains(className) && !this.requires.contains(outermostClassName);
                if (!notProvidedByConstructors || !notProvidedByRequires || classNames.contains(className)) continue;
                CheckRequiresForConstructors.this.compiler.report(t.makeError(node, CheckRequiresForConstructors.this.level, MISSING_REQUIRE_WARNING, className));
                classNames.add(className);
            }
            this.newAndImplementsNodes.clear();
            this.requires.clear();
            this.constructors.clear();
        }

        private void visitCallNode(Node n, Node parent) {
            String required = CheckRequiresForConstructors.this.codingConvention.extractClassNameIfRequire(n, parent);
            if (required != null) {
                this.requires.add(required);
            }
        }

        private void visitNewNode(NodeTraversal t, Node n) {
            Node qNameNode = n.getFirstChild();
            if (!qNameNode.isQualifiedName()) {
                return;
            }
            Node root = NodeUtil.getRootOfQualifiedName(qNameNode);
            if (!root.isName()) {
                return;
            }
            String name = root.getString();
            Scope.Var var = t.getScope().getVar(name);
            if (var == null || var.isLocal() || var.isExtern()) {
                return;
            }
            this.newAndImplementsNodes.add(n);
        }

        private void maybeAddConstructor(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                String ctorName = n.getFirstChild().getQualifiedName();
                if (info.isConstructor() || info.isInterface()) {
                    this.constructors.add(ctorName);
                } else {
                    JSType type;
                    JSTypeExpression typeExpr = info.getType();
                    if (typeExpr != null && (type = typeExpr.evaluate(t.getScope(), CheckRequiresForConstructors.this.compiler.getTypeRegistry())).isConstructor()) {
                        this.constructors.add(ctorName);
                    }
                }
            }
        }

        private void maybeAddImplements(NodeTraversal t, Node n) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            if (info != null) {
                for (JSTypeExpression expr : info.getImplementedInterfaces()) {
                    Node implementsNode = expr.getRoot();
                    Preconditions.checkState((implementsNode.getType() == 306 ? 1 : 0) != 0);
                    Node child = implementsNode.getFirstChild();
                    Preconditions.checkState((boolean)child.isString());
                    String rootName = (String)Splitter.on((char)'.').split((CharSequence)child.getString()).iterator().next();
                    Scope.Var var = t.getScope().getVar(rootName);
                    if (var != null && var.isExtern()) {
                        return;
                    }
                    this.newAndImplementsNodes.add(child);
                }
            }
        }
    }
}

