/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.JqueryCodingConvention;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.WhitelistWarningsGuard;
import com.google.javascript.jscomp.XtbMessageBundle;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

public class CommandLineRunner
extends AbstractCommandLineRunner<Compiler, CompilerOptions> {
    public static final String OUTPUT_MARKER = "%output%";
    public static final int UTF8_BOM_CODE = 65279;
    private final Flags flags = new Flags();
    private boolean errors = false;
    private boolean runCompiler = false;
    private PrintStream errorStream;
    private static final List<String> DEFAULT_EXTERNS_NAMES = ImmutableList.of((Object)"es3.js", (Object)"es5.js", (Object)"es6.js", (Object)"intl.js", (Object)"w3c_event.js", (Object)"w3c_event3.js", (Object)"gecko_event.js", (Object)"ie_event.js", (Object)"webkit_event.js", (Object)"w3c_device_sensor_event.js", (Object)"w3c_dom1.js", (Object)"w3c_dom2.js", (Object[])new String[]{"w3c_dom3.js", "gecko_dom.js", "ie_dom.js", "webkit_dom.js", "w3c_css.js", "gecko_css.js", "ie_css.js", "webkit_css.js", "google.js", "chrome.js", "deprecated.js", "fileapi.js", "flash.js", "gecko_xml.js", "html5.js", "ie_vml.js", "iphone.js", "mediasource.js", "v8.js", "webstorage.js", "w3c_anim_timing.js", "w3c_css3d.js", "w3c_elementtraversal.js", "w3c_geolocation.js", "w3c_indexeddb.js", "w3c_navigation_timing.js", "w3c_range.js", "w3c_rtc.js", "w3c_selectors.js", "w3c_xml.js", "window.js", "webkit_notifications.js", "webgl.js"});

    protected CommandLineRunner(String[] args) {
        this.initConfigFromFlags(args, System.out, System.err);
    }

    protected CommandLineRunner(String[] args, PrintStream out, PrintStream err) {
        super(out, err);
        this.initConfigFromFlags(args, out, err);
    }

    private static List<String> processArgs(String[] args) {
        Pattern argPattern = Pattern.compile("(--?[a-zA-Z_]+)=(.*)");
        Pattern quotesPattern = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList<String> processedArgs = new ArrayList<String>();
        for (String arg : args) {
            Matcher matcher = argPattern.matcher(arg);
            if (matcher.matches()) {
                processedArgs.add(matcher.group(1));
                String value = matcher.group(2);
                Matcher quotesMatcher = quotesPattern.matcher(value);
                if (quotesMatcher.matches()) {
                    processedArgs.add(quotesMatcher.group(1));
                    continue;
                }
                processedArgs.add(value);
                continue;
            }
            processedArgs.add(arg);
        }
        return processedArgs;
    }

    private void reportError(String message) {
        this.errors = true;
        this.errorStream.println(message);
        this.errorStream.flush();
    }

    private void processFlagFile() throws CmdLineException, IOException {
        int c;
        Path flagFile = Paths.get(this.flags.flagFile, new String[0]);
        BufferedReader buffer = Files.newBufferedReader(flagFile, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        List<String> tokens = new ArrayList<String>();
        boolean quoted = false;
        boolean escaped = false;
        boolean isFirstCharacter = true;
        while ((c = buffer.read()) != -1) {
            if (isFirstCharacter) {
                isFirstCharacter = false;
                if (c == 65279) continue;
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) {
                if (quoted) {
                    builder.append((char)c);
                } else if (builder.length() != 0) {
                    tokens.add(builder.toString());
                    builder.setLength(0);
                }
            } else if (c == 34) {
                if (escaped) {
                    if (quoted) {
                        builder.setCharAt(builder.length() - 1, (char)c);
                    } else {
                        builder.append((char)c);
                    }
                } else {
                    quoted = !quoted;
                }
            } else {
                builder.append((char)c);
            }
            escaped = c == 92;
        }
        buffer.close();
        if (builder.length() != 0) {
            tokens.add(builder.toString());
        }
        this.flags.flagFile = "";
        tokens = CommandLineRunner.processArgs(tokens.toArray(new String[tokens.size()]));
        ArrayList previous = new ArrayList(Flags.guardLevels);
        Flags.guardLevels.clear();
        this.flags.parse(tokens);
        Flags.guardLevels.addAll(previous);
        if (!this.flags.flagFile.isEmpty()) {
            this.reportError("ERROR - Arguments in the file cannot contain --flagfile option.");
        }
    }

    private void initConfigFromFlags(String[] args, PrintStream out, PrintStream err) {
        this.errorStream = err;
        List<String> processedArgs = CommandLineRunner.processArgs(args);
        Flags.guardLevels.clear();
        List<String> jsFiles = null;
        List<SourceMap.LocationMapping> mappings = null;
        try {
            this.flags.parse(processedArgs);
            if (!this.flags.flagFile.isEmpty()) {
                this.processFlagFile();
            }
            jsFiles = this.flags.getJsFiles();
            mappings = this.flags.getSourceMapLocationMappings();
        }
        catch (CmdLineException e) {
            this.reportError(e.getMessage());
        }
        catch (IOException ioErr) {
            this.reportError("ERROR - " + this.flags.flagFile + " read error.");
        }
        if (this.flags.processCommonJsModules) {
            this.flags.processClosurePrimitives = true;
            this.flags.manageClosureDependencies = true;
            if (this.flags.commonJsEntryModule == null) {
                this.reportError("Please specify --common_js_entry_module.");
            }
            this.flags.closureEntryPoint = Lists.newArrayList((Object[])new String[]{ProcessCommonJSModules.toModuleName(this.flags.commonJsEntryModule)});
        }
        if (this.flags.outputWrapperFile != null && !this.flags.outputWrapperFile.isEmpty()) {
            this.flags.outputWrapper = "";
            try {
                this.flags.outputWrapper = com.google.common.io.Files.toString((File)new File(this.flags.outputWrapperFile), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                this.reportError("ERROR - invalid output_wrapper_file specified.");
            }
        }
        if (this.flags.outputWrapper != null && !this.flags.outputWrapper.isEmpty() && !this.flags.outputWrapper.contains(OUTPUT_MARKER)) {
            this.reportError("ERROR - invalid output_wrapper specified. Missing '%output%'.");
        }
        if (this.errors) {
            this.flags.printShortUsageAfterErrors(this.errorStream);
        } else if (this.flags.displayHelp) {
            this.flags.printUsage(out);
        } else if (this.flags.version) {
            out.println("Closure Compiler (http://github.com/google/closure-compiler)\nVersion: " + Compiler.getReleaseVersion() + "\n" + "Built on: " + Compiler.getReleaseDate());
            out.flush();
        } else {
            this.runCompiler = true;
            CodingConvention conv = this.flags.thirdParty ? CodingConventions.getDefault() : (this.flags.processJqueryPrimitives ? new JqueryCodingConvention() : new ClosureCodingConvention());
            this.getCommandLineConfig().setPrintTree(this.flags.printTree).setPrintAst(this.flags.printAst).setPrintPassGraph(this.flags.printPassGraph).setJscompDevMode(this.flags.jscompDevMode).setLoggingLevel(this.flags.loggingLevel).setExterns(this.flags.externs).setJs(jsFiles).setJsOutputFile(this.flags.jsOutputFile).setModule(this.flags.module).setVariableMapOutputFile(this.flags.variableMapOutputFile).setCreateNameMapFiles(this.flags.createNameMapFiles).setPropertyMapOutputFile(this.flags.propertyMapOutputFile).setCodingConvention(conv).setSummaryDetailLevel(this.flags.summaryDetailLevel).setOutputWrapper(this.flags.outputWrapper).setModuleWrapper(this.flags.moduleWrapper).setModuleOutputPathPrefix(this.flags.moduleOutputPathPrefix).setCreateSourceMap(this.flags.createSourceMap).setSourceMapFormat(this.flags.sourceMapFormat).setSourceMapLocationMappings(mappings).setWarningGuardSpec(Flags.getWarningGuardSpec()).setDefine(this.flags.define).setCharset(this.flags.charset).setManageClosureDependencies(this.flags.manageClosureDependencies).setOnlyClosureDependencies(this.flags.onlyClosureDependencies).setClosureEntryPoints(this.flags.closureEntryPoint).setOutputManifest((List<String>)ImmutableList.of((Object)this.flags.outputManifest)).setOutputModuleDependencies(this.flags.outputModuleDependencies).setAcceptConstKeyword(this.flags.acceptConstKeyword).setLanguageIn(this.flags.languageIn).setLanguageOut(this.flags.languageOut).setProcessCommonJSModules(this.flags.processCommonJsModules).setRewriteEs6Modules(this.flags.rewriteEs6Modules).setTranspileOnly(this.flags.transpileOnly).setCommonJSModulePathPrefix(this.flags.commonJsPathPrefix).setTransformAMDToCJSModules(this.flags.transformAmdModules).setWarningsWhitelistFile(this.flags.warningsWhitelistFile).setAngularPass(this.flags.angularPass).setTracerMode(this.flags.tracerMode).setNewTypeInference(this.flags.useNewTypeInference).setRenamePrefixNamespace(this.flags.renamePrefixNamespace);
        }
        this.errorStream = null;
    }

    @Override
    protected void addWhitelistWarningsGuard(CompilerOptions options, File whitelistFile) {
        options.addWarningsGuard(WhitelistWarningsGuard.fromFile(whitelistFile));
    }

    @Override
    protected CompilerOptions createOptions() {
        CompilerOptions options = new CompilerOptions();
        if (this.flags.processJqueryPrimitives) {
            options.setCodingConvention(new JqueryCodingConvention());
        } else {
            options.setCodingConvention(new ClosureCodingConvention());
        }
        options.setExtraAnnotationNames(this.flags.extraAnnotationName);
        CompilationLevel level = this.flags.compilationLevelParsed;
        level.setOptionsForCompilationLevel(options);
        if (this.flags.debug) {
            level.setDebugOptionsForCompilationLevel(options);
        }
        if (this.flags.useTypesForOptimization) {
            level.setTypeBasedOptimizationOptions(options);
        }
        if (this.flags.generateExports) {
            options.setGenerateExports(this.flags.generateExports);
        }
        WarningLevel wLevel = this.flags.warningLevel;
        wLevel.setOptionsForWarningLevel(options);
        for (FormattingOption formattingOption : this.flags.formatting) {
            formattingOption.applyToOptions(options);
        }
        options.closurePass = this.flags.processClosurePrimitives;
        options.jqueryPass = CompilationLevel.ADVANCED_OPTIMIZATIONS == level && this.flags.processJqueryPrimitives;
        options.angularPass = this.flags.angularPass;
        options.renamePrefixNamespace = this.flags.renamePrefixNamespace;
        if (!this.flags.translationsFile.isEmpty()) {
            try {
                options.messageBundle = new XtbMessageBundle(new FileInputStream(this.flags.translationsFile), this.flags.translationsProject);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading XTB file", e);
            }
        } else if (CompilationLevel.ADVANCED_OPTIMIZATIONS == level) {
            options.messageBundle = new EmptyMessageBundle();
            options.setWarningLevel(JsMessageVisitor.MSG_CONVENTIONS, CheckLevel.OFF);
        }
        options.setConformanceConfigs((List<ConformanceConfig>)this.loadConformanceConfigs(this.flags.conformanceConfigs));
        return options;
    }

    @Override
    protected Compiler createCompiler() {
        return new Compiler(this.getErrorPrintStream());
    }

    @Override
    protected List<SourceFile> createExterns() throws AbstractCommandLineRunner.FlagUsageException, IOException {
        List<SourceFile> externs = super.createExterns();
        if (this.flags.useOnlyCustomExterns || this.isInTestMode()) {
            return externs;
        }
        List<SourceFile> defaultExterns = CommandLineRunner.getDefaultExterns();
        defaultExterns.addAll(externs);
        return defaultExterns;
    }

    private ImmutableList<ConformanceConfig> loadConformanceConfigs(List<String> configPaths) {
        ImmutableList.Builder configs = ImmutableList.builder();
        for (String configPath : configPaths) {
            try {
                configs.add((Object)CommandLineRunner.loadConformanceConfig(configPath));
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading conformance config", e);
            }
        }
        return configs.build();
    }

    private static ConformanceConfig loadConformanceConfig(String configFile) throws IOException {
        String textProto = com.google.common.io.Files.toString((File)new File(configFile), (Charset)StandardCharsets.UTF_8);
        ConformanceConfig.Builder builder = ConformanceConfig.newBuilder();
        if (textProto.charAt(0) == '\ufeff') {
            textProto = textProto.substring(1);
        }
        try {
            TextFormat.merge((CharSequence)textProto, (Message.Builder)builder);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    public static List<SourceFile> getDefaultExterns() throws IOException {
        InputStream input = CommandLineRunner.class.getResourceAsStream("/externs.zip");
        if (input == null) {
            input = CommandLineRunner.class.getResourceAsStream("externs.zip");
        }
        Preconditions.checkNotNull((Object)input);
        ZipInputStream zip = new ZipInputStream(input);
        HashMap<String, SourceFile> externsMap = new HashMap<String, SourceFile>();
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            BufferedInputStream entryStream = new BufferedInputStream(ByteStreams.limit((InputStream)zip, (long)entry.getSize()));
            externsMap.put(entry.getName(), SourceFile.fromInputStream("externs.zip//" + entry.getName(), entryStream, StandardCharsets.UTF_8));
        }
        Preconditions.checkState((boolean)externsMap.keySet().equals(new HashSet<String>(DEFAULT_EXTERNS_NAMES)), (Object)"Externs zip must match our hard-coded list of externs.");
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        for (String key : DEFAULT_EXTERNS_NAMES) {
            externs.add((SourceFile)externsMap.get(key));
        }
        return externs;
    }

    public static List<String> findJsFiles(Collection<String> patterns) throws IOException {
        LinkedHashSet<String> allJsInputs = new LinkedHashSet<String>();
        for (String pattern : patterns) {
            if (!pattern.contains("*") && !pattern.startsWith("!")) {
                File matchedFile = new File(pattern);
                if (matchedFile.isDirectory()) {
                    CommandLineRunner.matchPaths(new File(matchedFile, "**.js").toString(), allJsInputs);
                    continue;
                }
                allJsInputs.add(pattern);
                continue;
            }
            CommandLineRunner.matchPaths(pattern, allJsInputs);
        }
        return new ArrayList<String>(allJsInputs);
    }

    private static void matchPaths(String pattern, final Set<String> allJsInputs) throws IOException {
        boolean remove;
        FileSystem fs = FileSystems.getDefault();
        boolean bl = remove = pattern.indexOf(33) == 0;
        if (remove) {
            pattern = pattern.substring(1);
        }
        if (File.separator.equals("\\")) {
            pattern = pattern.replace('\\', '/');
        }
        List patternParts = Splitter.on((char)'/').splitToList((CharSequence)pattern);
        String prefix = ".";
        for (int i = 0; i < patternParts.size(); ++i) {
            if (!((String)patternParts.get(i)).contains("*")) continue;
            if (i == 0) break;
            prefix = Joiner.on((String)"/").join(patternParts.subList(0, i));
            pattern = Joiner.on((String)"/").join(patternParts.subList(i, patternParts.size()));
        }
        final PathMatcher matcher = fs.getPathMatcher("glob:" + pattern);
        Files.walkFileTree(fs.getPath(prefix, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) {
                if (matcher.matches(p)) {
                    if (remove) {
                        allJsInputs.remove(p.toString());
                    } else {
                        allJsInputs.add(p.toString());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public boolean shouldRunCompiler() {
        return this.runCompiler;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public static void main(String[] args) {
        CommandLineRunner runner = new CommandLineRunner(args);
        if (runner.shouldRunCompiler()) {
            runner.run();
        }
        if (runner.hasErrors()) {
            System.exit(-1);
        }
    }

    private static enum FormattingOption {
        PRETTY_PRINT,
        PRINT_INPUT_DELIMITER,
        SINGLE_QUOTES;


        private void applyToOptions(CompilerOptions options) {
            switch (this) {
                case PRETTY_PRINT: {
                    options.prettyPrint = true;
                    break;
                }
                case PRINT_INPUT_DELIMITER: {
                    options.printInputDelimiter = true;
                    break;
                }
                case SINGLE_QUOTES: {
                    options.setPreferSingleQuotes(true);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown formatting option: " + (Object)((Object)this));
                }
            }
        }
    }

    private static class Flags {
        private static List<GuardLevel> guardLevels = new ArrayList<GuardLevel>();
        @Option(name="--help", hidden=true, handler=BooleanOptionHandler.class, usage="Displays this message on stdout and exit")
        private boolean displayHelp = false;
        @Option(name="--print_tree", hidden=true, handler=BooleanOptionHandler.class, usage="Prints out the parse tree and exits")
        private boolean printTree = false;
        @Option(name="--print_ast", hidden=true, handler=BooleanOptionHandler.class, usage="Prints a dot file describing the internal abstract syntax tree and exits")
        private boolean printAst = false;
        @Option(name="--print_pass_graph", hidden=true, handler=BooleanOptionHandler.class, usage="Prints a dot file describing the passes that will get run and exits")
        private boolean printPassGraph = false;
        @Option(name="--jscomp_dev_mode", aliases={"--dev_mode"})
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        @Option(name="--logging_level", hidden=true, usage="The logging level (standard java.util.logging.Level values) for Compiler progress. Does not control errors or warnings for the JavaScript code under compilation")
        private String loggingLevel = Level.WARNING.getName();
        @Option(name="--externs", usage="The file containing JavaScript externs. You may specify multiple")
        private List<String> externs = new ArrayList<String>();
        @Option(name="--js", usage="The JavaScript filename. You may specify multiple. The flag name is optional, because args are interpreted as files by default. You may also use minimatch-style glob patterns. For example, use --js='**.js' --js='!**_test.js' to recursively include all js files that do not end in _test.js")
        private List<String> js = new ArrayList<String>();
        @Option(name="--js_output_file", usage="Primary output filename. If not specified, output is written to stdout")
        private String jsOutputFile = "";
        @Option(name="--module", hidden=true, usage="A JavaScript module specification. The format is <name>:<num-js-files>[:[<dep>,...][:]]]. Module names must be unique. Each dep is the name of a module that this module depends on. Modules must be listed in dependency order, and JS source files must be listed in the corresponding order. Where --module flags occur in relation to --js flags is unimportant. Provide the value 'auto' to trigger module creation from CommonJSmodules.")
        private List<String> module = new ArrayList<String>();
        @Option(name="--variable_renaming_report", hidden=true, usage="File where the serialized version of the variable renaming map produced should be saved")
        private String variableMapOutputFile = "";
        @Option(name="--create_renaming_reports", hidden=true, handler=BooleanOptionHandler.class, usage="If true, variable renaming and property renaming report files will be produced as {binary name}_vars_renaming_report.out and {binary name}_props_renaming_report.out. Note that this flag cannot be used in conjunction with either variable_renaming_report or property_renaming_report")
        private boolean createNameMapFiles = false;
        @Option(name="--property_renaming_report", hidden=true, usage="File where the serialized version of the property renaming map produced should be saved")
        private String propertyMapOutputFile = "";
        @Option(name="--third_party", hidden=true, handler=BooleanOptionHandler.class, usage="Check source validity but do not enforce Closure style rules and conventions")
        private boolean thirdParty = false;
        @Option(name="--summary_detail_level", hidden=true, usage="Controls how detailed the compilation summary is. Values: 0 (never print summary), 1 (print summary only if there are errors or warnings), 2 (print summary if the 'checkTypes' diagnostic  group is enabled, see --jscomp_warning), 3 (always print summary). The default level is 1")
        private int summaryDetailLevel = 1;
        @Option(name="--output_wrapper", hidden=true, usage="Interpolate output into this string at the place denoted by the marker token %output%. Use marker token %output|jsstring% to do js string escaping on the output.")
        private String outputWrapper = "";
        @Option(name="--output_wrapper_file", hidden=true, usage="Loads the specified file and passes the file contents to the --output_wrapper flag, replacing the value if it exists.")
        private String outputWrapperFile = "";
        @Option(name="--module_wrapper", hidden=true, usage="An output wrapper for a JavaScript module (optional). The format is <name>:<wrapper>. The module name must correspond with a module specified using --module. The wrapper must contain %s as the code placeholder. The %basename% placeholder can also be used to substitute the base name of the module output file.")
        private List<String> moduleWrapper = new ArrayList<String>();
        @Option(name="--module_output_path_prefix", hidden=true, usage="Prefix for filenames of compiled JS modules. <module-name>.js will be appended to this prefix. Directories will be created as needed. Use with --module")
        private String moduleOutputPathPrefix = "./";
        @Option(name="--create_source_map", hidden=true, usage="If specified, a source map file mapping the generated source files back to the original source file will be output to the specified path. The %outname% placeholder will expand to the name of the output file that the source map corresponds to.")
        private String createSourceMap = "";
        @Option(name="--source_map_format", hidden=true, usage="The source map format to produce. Options are V3 and DEFAULT, which are equivalent.")
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        @Option(name="--source_map_location_mapping", hidden=true, usage="Source map location mapping separated by a '|' (i.e. filesystem-path|webserver-path)")
        private List<String> sourceMapLocationMapping = Lists.newArrayList();
        @Option(name="--jscomp_error", hidden=true, handler=WarningGuardErrorOptionHandler.class, usage="Make the named class of warnings an error. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkStructDictInheritance, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, inferredConstCheck, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn,newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, useOfGoogBase, visibility")
        private List<String> jscompError = new ArrayList<String>();
        @Option(name="--jscomp_warning", hidden=true, handler=WarningGuardWarningOptionHandler.class, usage="Make the named class of warnings a normal warning. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkStructDictInheritance, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, inferredConstCheck, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn,newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, useOfGoogBase, visibility")
        private List<String> jscompWarning = new ArrayList<String>();
        @Option(name="--jscomp_off", hidden=true, handler=WarningGuardOffOptionHandler.class, usage="Turn off the named class of warnings. Options:accessControls, ambiguousFunctionDecl, checkEventfulObjectDisposal, checkRegExp, checkStructDictInheritance, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, duplicateMessage, es3, es5Strict, externsValidation, fileoverviewTags, globalThis, inferredConstCheck, internetExplorerChecks, invalidCasts, misplacedTypeAnnotation, missingGetCssName, missingProperties, missingProvide, missingRequire, missingReturn,newCheckTypes, nonStandardJsDocs, reportUnknownTypes, suspiciousCode, strictModuleDepCheck, typeInvalidation, undefinedNames, undefinedVars, unknownDefines, uselessCode, useOfGoogBase, visibility")
        private List<String> jscompOff = new ArrayList<String>();
        @Option(name="--define", hidden=true, aliases={"--D", "-D"}, usage="Override the value of a variable annotated @define. The format is <name>[=<val>], where <name> is the name of a @define variable and <val> is a boolean, number, or a single-quoted string that contains no single quotes. If [=<val>] is omitted, the variable is marked true")
        private List<String> define = new ArrayList<String>();
        @Option(name="--charset", hidden=true, usage="Input and output charset for all files. By default, we accept UTF-8 as input and output US_ASCII")
        private String charset = "";
        @Option(name="--compilation_level", aliases={"-O"}, usage="Specifies the compilation level to use. Options: WHITESPACE_ONLY, SIMPLE, ADVANCED")
        private String compilationLevel = "SIMPLE";
        private CompilationLevel compilationLevelParsed = null;
        @Option(name="--use_types_for_optimization", hidden=true, usage="Experimental: perform additional optimizations based on available information.  Inaccurate type annotations may result in incorrect results.")
        private boolean useTypesForOptimization = false;
        @Option(name="--warning_level", aliases={"-W"}, usage="Specifies the warning level to use. Options: QUIET, DEFAULT, VERBOSE")
        private WarningLevel warningLevel = WarningLevel.DEFAULT;
        @Option(name="--use_only_custom_externs", hidden=true, handler=BooleanOptionHandler.class, usage="Specifies whether the default externs should be excluded")
        private boolean useOnlyCustomExterns = false;
        @Option(name="--debug", hidden=true, handler=BooleanOptionHandler.class, usage="Enable debugging options")
        private boolean debug = false;
        @Option(name="--generate_exports", hidden=true, handler=BooleanOptionHandler.class, usage="Generates export code for those marked with @export")
        private boolean generateExports = false;
        @Option(name="--formatting", hidden=true, usage="Specifies which formatting options, if any, should be applied to the output JS. Options: PRETTY_PRINT, PRINT_INPUT_DELIMITER, SINGLE_QUOTES")
        private List<FormattingOption> formatting = new ArrayList<FormattingOption>();
        @Option(name="--process_common_js_modules", hidden=true, usage="Process CommonJS modules to a concatenable form.")
        private boolean processCommonJsModules = false;
        @Option(name="--rewrite_es6_modules", hidden=true, usage="Rewrite ES6 modules to a concatenable form.")
        private boolean rewriteEs6Modules = false;
        @Option(name="--transpile_only", hidden=true, usage="Run ES6 to ES3 transpilation only, skip other passes.")
        private boolean transpileOnly = false;
        @Option(name="--common_js_module_path_prefix", hidden=true, usage="Path prefix to be removed from CommonJS module names.")
        private String commonJsPathPrefix = "./";
        @Option(name="--common_js_entry_module", hidden=true, usage="Root of your common JS dependency hierarchy. Your main script.")
        private String commonJsEntryModule;
        @Option(name="--transform_amd_modules", hidden=true, usage="Transform AMD to CommonJS modules.")
        private boolean transformAmdModules = false;
        @Option(name="--process_closure_primitives", hidden=true, handler=BooleanOptionHandler.class, usage="Processes built-ins from the Closure library, such as goog.require(), goog.provide(), and goog.exportSymbol()")
        private boolean processClosurePrimitives = true;
        @Option(name="--manage_closure_dependencies", hidden=true, handler=BooleanOptionHandler.class, usage="Automatically sort dependencies so that a file that goog.provides symbol X will always come before a file that goog.requires symbol X. If an input provides symbols, and those symbols are never required, then that input will not be included in the compilation.")
        private boolean manageClosureDependencies = false;
        @Option(name="--only_closure_dependencies", hidden=true, handler=BooleanOptionHandler.class, usage="Only include files in the transitive dependency of the entry points (specified by closure_entry_point). Files that do not provide dependencies will be removed. This supersedes manage_closure_dependencies")
        private boolean onlyClosureDependencies = false;
        @Option(name="--closure_entry_point", hidden=true, usage="Entry points to the program. Must be goog.provide'd symbols. Any goog.provide'd symbols that are not a transitive dependency of the entry points will be removed. Files without goog.provides, and their dependencies, will always be left in. If any entry points are specified, then the manage_closure_dependencies option will be set to true and all files will be sorted in dependency order.")
        private List<String> closureEntryPoint = new ArrayList<String>();
        @Option(name="--process_jquery_primitives", hidden=true, handler=BooleanOptionHandler.class, usage="Processes built-ins from the Jquery library, such as jQuery.fn and jQuery.extend()")
        private boolean processJqueryPrimitives = false;
        @Option(name="--angular_pass", hidden=true, handler=BooleanOptionHandler.class, usage="Generate $inject properties for AngularJS for functions annotated with @ngInject")
        private boolean angularPass = false;
        @Option(name="--output_manifest", hidden=true, usage="Prints out a list of all the files in the compilation. If --manage_closure_dependencies is on, this will not include files that got dropped because they were not required. The %outname% placeholder expands to the JS output file. If you're using modularization, using %outname% will create a manifest for each module.")
        private String outputManifest = "";
        @Option(name="--output_module_dependencies", hidden=true, usage="Prints out a JSON file of dependencies between modules.")
        private String outputModuleDependencies = "";
        @Option(name="--accept_const_keyword", hidden=true, usage="Allows usage of const keyword.")
        private boolean acceptConstKeyword = false;
        @Option(name="--language_in", hidden=true, usage="Sets what language spec that input sources conform. Options: ECMASCRIPT3 (default), ECMASCRIPT5, ECMASCRIPT5_STRICT, ECMASCRIPT6 (experimental), ECMASCRIPT6_STRICT (experimental)")
        private String languageIn = "ECMASCRIPT3";
        @Option(name="--language_out", hidden=true, usage="Sets what language spec the output should conform to.  If omitted, defaults to the value of language_in. Options: ECMASCRIPT3, ECMASCRIPT5, ECMASCRIPT5_STRICT")
        private String languageOut = "";
        @Option(name="--version", hidden=true, handler=BooleanOptionHandler.class, usage="Prints the compiler version to stdout and exit.")
        private boolean version = false;
        @Option(name="--translations_file", hidden=true, usage="Source of translated messages. Currently only supports XTB.")
        private String translationsFile = "";
        @Option(name="--translations_project", hidden=true, usage="Scopes all translations to the specified project.When specified, we will use different message ids so that messages in different projects can have different translations.")
        private String translationsProject = null;
        @Option(name="--flagfile", hidden=true, usage="A file containing additional command-line options.")
        private String flagFile = "";
        @Option(name="--warnings_whitelist_file", hidden=true, usage="A file containing warnings to suppress. Each line should be of the form\n<file-name>:<line-number>?  <warning-description>")
        private String warningsWhitelistFile = "";
        @Option(name="--extra_annotation_name", hidden=true, usage="A whitelist of tag names in JSDoc. You may specify multiple")
        private List<String> extraAnnotationName = new ArrayList<String>();
        @Option(name="--tracer_mode", hidden=true, usage="Shows the duration of each compiler pass and the impact to the compiled output size. Options: ALL, RAW_SIZE, TIMING_ONLY, OFF")
        private CompilerOptions.TracerMode tracerMode = CompilerOptions.TracerMode.OFF;
        @Option(name="--new_type_inf", hidden=true, usage="In development new type inference pass. DO NOT USE!")
        private boolean useNewTypeInference = false;
        @Option(name="--rename_prefix_namespace", usage="Specifies the name of an object that will be used to store all non-extern globals")
        private String renamePrefixNamespace = null;
        @Option(name="--conformance_configs", hidden=true, usage="A list of JS Conformance configurations in text protocol buffer format.")
        private List<String> conformanceConfigs = new ArrayList<String>();
        @Argument
        private List<String> arguments = new ArrayList<String>();
        private static final Map<String, CompilationLevel> COMPILATION_LEVEL_MAP = ImmutableMap.of((Object)"WHITESPACE_ONLY", (Object)((Object)CompilationLevel.WHITESPACE_ONLY), (Object)"SIMPLE", (Object)((Object)CompilationLevel.SIMPLE_OPTIMIZATIONS), (Object)"SIMPLE_OPTIMIZATIONS", (Object)((Object)CompilationLevel.SIMPLE_OPTIMIZATIONS), (Object)"ADVANCED", (Object)((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS), (Object)"ADVANCED_OPTIMIZATIONS", (Object)((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS));

        private Flags() {
        }

        private void parse(List<String> args) throws CmdLineException {
            CmdLineParser parser = new CmdLineParser((Object)this);
            parser.parseArgument(args.toArray(new String[0]));
            this.compilationLevelParsed = COMPILATION_LEVEL_MAP.get(this.compilationLevel.toUpperCase());
            if (this.compilationLevelParsed == null) {
                throw new CmdLineException(parser, "Bad value for --compilation_level: " + this.compilationLevel);
            }
        }

        private void printUsage(PrintStream ps) {
            CmdLineParser p = new CmdLineParser((Object)this);
            p.printUsage((Writer)new OutputStreamWriter(ps), null, OptionHandlerFilter.ALL);
            ps.flush();
        }

        private void printShortUsageAfterErrors(PrintStream ps) {
            ps.print("Sample usage: ");
            ps.println(new CmdLineParser((Object)this).printExample(OptionHandlerFilter.PUBLIC, null));
            ps.println("Run with --help for all options and details");
            ps.flush();
        }

        protected List<String> getJsFiles() throws CmdLineException, IOException {
            ArrayList<String> patterns = new ArrayList<String>();
            patterns.addAll(this.js);
            patterns.addAll(this.arguments);
            List<String> allJsInputs = CommandLineRunner.findJsFiles(patterns);
            if (!patterns.isEmpty() && allJsInputs.isEmpty()) {
                throw new CmdLineException(new CmdLineParser((Object)this), "No inputs matched");
            }
            return allJsInputs;
        }

        List<SourceMap.LocationMapping> getSourceMapLocationMappings() throws CmdLineException {
            ImmutableList.Builder locationMappings = ImmutableList.builder();
            Splitter splitter = Splitter.on((char)'|').limit(2);
            for (String locationMapping : this.sourceMapLocationMapping) {
                List parts = splitter.splitToList((CharSequence)locationMapping);
                if (parts.size() != 2) {
                    throw new CmdLineException("Bad value for --source_map_location_mapping: " + ImmutableList.of(this.sourceMapLocationMapping));
                }
                locationMappings.add((Object)new SourceMap.LocationMapping((String)parts.get(0), (String)parts.get(1)));
            }
            return locationMappings.build();
        }

        public static AbstractCommandLineRunner.WarningGuardSpec getWarningGuardSpec() {
            AbstractCommandLineRunner.WarningGuardSpec spec = new AbstractCommandLineRunner.WarningGuardSpec();
            for (GuardLevel guardLevel : guardLevels) {
                spec.add(guardLevel.level, guardLevel.name);
            }
            return spec;
        }

        private static class WarningGuardSetter
        implements Setter<String> {
            private final Setter<? super String> proxy;
            private final CheckLevel level;

            private WarningGuardSetter(Setter<? super String> proxy, CheckLevel level) {
                this.proxy = proxy;
                this.level = level;
            }

            public boolean isMultiValued() {
                return this.proxy.isMultiValued();
            }

            public Class<String> getType() {
                return this.proxy.getType();
            }

            public void addValue(String value) throws CmdLineException {
                this.proxy.addValue((Object)value);
                guardLevels.add(new GuardLevel(value, this.level));
            }

            public FieldSetter asFieldSetter() {
                return this.proxy.asFieldSetter();
            }

            public AnnotatedElement asAnnotatedElement() {
                return this.proxy.asAnnotatedElement();
            }
        }

        public static class WarningGuardOffOptionHandler
        extends StringOptionHandler {
            public WarningGuardOffOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.OFF));
            }
        }

        public static class WarningGuardWarningOptionHandler
        extends StringOptionHandler {
            public WarningGuardWarningOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.WARNING));
            }
        }

        public static class WarningGuardErrorOptionHandler
        extends StringOptionHandler {
            public WarningGuardErrorOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, (Setter)new WarningGuardSetter(setter, CheckLevel.ERROR));
            }
        }

        public static class BooleanOptionHandler
        extends OptionHandler<Boolean> {
            private static final Set<String> TRUES = ImmutableSet.of((Object)"true", (Object)"on", (Object)"yes", (Object)"1");
            private static final Set<String> FALSES = ImmutableSet.of((Object)"false", (Object)"off", (Object)"no", (Object)"0");

            public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
                super(parser, option, setter);
            }

            public int parseArguments(Parameters params) throws CmdLineException {
                String param = null;
                try {
                    param = params.getParameter(0);
                }
                catch (CmdLineException e) {
                    param = null;
                }
                if (param == null) {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                String lowerParam = param.toLowerCase();
                if (TRUES.contains(lowerParam)) {
                    this.setter.addValue((Object)true);
                } else if (FALSES.contains(lowerParam)) {
                    this.setter.addValue((Object)false);
                } else {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                return 1;
            }

            public String getDefaultMetaVariable() {
                return null;
            }
        }
    }

    private static class GuardLevel {
        final String name;
        final CheckLevel level;

        GuardLevel(String name, CheckLevel level) {
            this.name = name;
            this.level = level;
        }
    }
}

