/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6TemplateLiterals;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

public class Es6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6. {0}");
    static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6-to-ES3 conversion of ''{0}'' is not yet implemented.");
    static final DiagnosticType DYNAMIC_EXTENDS_TYPE = DiagnosticType.error("JSC_DYNAMIC_EXTENDS_TYPE", "The class in an extends clause must be a qualified name.");
    static final DiagnosticType CLASS_REASSIGNMENT = DiagnosticType.error("CLASS_REASSIGNMENT", "Class names defined inside a function cannot be reassigned.");
    private static final String THIS_VAR = "$jscomp$this";
    private static final String ARGUMENTS_VAR = "$jscomp$arguments";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final String DESTRUCTURING_TEMP_VAR = "$jscomp$destructuring$var";
    private int destructuringVarCounter = 0;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";
    private static final String ITER_BASE = "$jscomp$iter$";
    private static final String ITER_RESULT = "$jscomp$key$";
    public static final String COPY_PROP = "$jscomp.copyProperties";
    private static final String INHERITS = "$jscomp.inherits";
    static final String MAKE_ITER = "$jscomp.makeIterator";

    public Es6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isArrowFunction()) break;
                this.visitArrowFunction(t, n);
                break;
            }
            case 83: {
                this.visitParamList(n, parent);
                break;
            }
            case 147: 
            case 148: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                this.cannotConvert(n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getType()) {
            case 64: {
                for (Node child : n.children()) {
                    if (!child.isComputedProp()) continue;
                    this.visitObjectWithComputedProperty(n, parent);
                    break block0;
                }
                break;
            }
            case 160: {
                if (!parent.isObjectLit()) break;
                this.visitMemberDefInObjectLit(n, parent);
                break;
            }
            case 163: {
                this.visitForOf(n, parent);
                break;
            }
            case 154: {
                this.visitStringKey(n);
                break;
            }
            case 158: {
                for (Node member = n.getLastChild().getFirstChild(); member != null; member = member.getNext()) {
                    if (!member.isGetterDef() && !member.isSetterDef() && !member.getBooleanProp(73) && !member.getBooleanProp(74)) continue;
                    this.cannotConvert(member, "getters or setters in class definitions");
                    return;
                }
                this.visitClass(n, parent);
                break;
            }
            case 30: 
            case 37: 
            case 63: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
            case 176: {
                Es6TemplateLiterals.visitTemplateLiteral(t, n);
                break;
            }
            case 156: {
                this.visitArrayPattern(t, n, parent);
                break;
            }
            case 157: {
                this.visitObjectPattern(t, n, parent);
            }
        }
    }

    private void visitObjectPattern(NodeTraversal t, Node objectPattern, Node parent) {
        Node nodeToDetach;
        Node rhs;
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            rhs = objectPattern.getLastChild();
            nodeToDetach = parent;
        } else if (parent.isAssign() && parent.getParent().isExprResult()) {
            rhs = parent.getLastChild();
            nodeToDetach = parent.getParent();
        } else {
            if (parent.isStringKey() || parent.isArrayPattern() || parent.isDefaultValue()) {
                return;
            }
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(objectPattern);
                return;
            }
            if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(objectPattern);
                return;
            }
            throw new IllegalStateException("Unexpected OBJECT_PATTERN parent: " + parent);
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detachFromParent()).useSourceInfoIfMissingFromForTree(objectPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        Node child = objectPattern.getFirstChild();
        while (child != null) {
            Node newNode;
            Node newRHS;
            Node newLHS;
            Node next = child.getNext();
            if (child.isStringKey()) {
                Preconditions.checkState((boolean)child.hasChildren());
                Node getprop = new Node(child.isQuotedString() ? 35 : 33, IR.name(tempVarName), IR.string(child.getString()));
                Node value = child.removeFirstChild();
                if (!value.isDefaultValue()) {
                    newLHS = value;
                    newRHS = getprop;
                } else {
                    newLHS = value.removeFirstChild();
                    Node defaultValue = value.removeFirstChild();
                    newRHS = Es6ToEs3Converter.defaultValueHook(getprop, defaultValue);
                }
            } else if (child.isComputedProp()) {
                if (child.getLastChild().isDefaultValue()) {
                    newLHS = child.getLastChild().removeFirstChild();
                    Node getelem = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    String intermediateTempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
                    Node intermediateDecl = IR.var(IR.name(intermediateTempVarName), getelem);
                    intermediateDecl.useSourceInfoIfMissingFromForTree(child);
                    nodeToDetach.getParent().addChildBefore(intermediateDecl, nodeToDetach);
                    newRHS = Es6ToEs3Converter.defaultValueHook(IR.name(intermediateTempVarName), child.getLastChild().removeFirstChild());
                } else {
                    newRHS = IR.getelem(IR.name(tempVarName), child.removeFirstChild());
                    newLHS = child.removeFirstChild();
                }
            } else if (child.isDefaultValue()) {
                newLHS = child.removeFirstChild();
                Node defaultValue = child.removeFirstChild();
                Node getprop = IR.getprop(IR.name(tempVarName), IR.string(newLHS.getString()));
                newRHS = Es6ToEs3Converter.defaultValueHook(getprop, defaultValue);
            } else {
                throw new IllegalStateException("Unexpected OBJECT_PATTERN child: " + child);
            }
            if (NodeUtil.isNameDeclaration(parent)) {
                newNode = IR.declaration(newLHS, newRHS, parent.getType());
            } else if (parent.isAssign()) {
                newNode = IR.exprResult(IR.assign(newLHS, newRHS));
            } else {
                throw new IllegalStateException("not reached");
            }
            newNode.useSourceInfoIfMissingFromForTree(child);
            nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
            this.visit(t, newLHS, newLHS.getParent());
            child = next;
        }
        nodeToDetach.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitArrayPattern(NodeTraversal t, Node arrayPattern, Node parent) {
        Node nodeToDetach;
        Node rhs;
        if (NodeUtil.isNameDeclaration(parent) && !NodeUtil.isEnhancedFor(parent.getParent())) {
            Preconditions.checkState((arrayPattern.getNext() == null ? 1 : 0) != 0);
            rhs = arrayPattern.getLastChild();
            nodeToDetach = parent;
        } else if (parent.isAssign()) {
            rhs = arrayPattern.getNext();
            nodeToDetach = parent.getParent();
            Preconditions.checkState((boolean)nodeToDetach.isExprResult());
        } else {
            if (parent.isArrayPattern() || parent.isDefaultValue() || parent.isStringKey()) {
                return;
            }
            if (NodeUtil.isEnhancedFor(parent) || NodeUtil.isEnhancedFor(parent.getParent())) {
                this.visitDestructuringPatternInEnhancedFor(arrayPattern);
                return;
            }
            if (parent.isCatch()) {
                this.visitDestructuringPatternInCatch(arrayPattern);
                return;
            }
            throw new IllegalStateException("Unexpected ARRAY_PATTERN parent: " + parent);
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node tempDecl = IR.var(IR.name(tempVarName), rhs.detachFromParent()).useSourceInfoIfMissingFromForTree(arrayPattern);
        nodeToDetach.getParent().addChildBefore(tempDecl, nodeToDetach);
        int i = 0;
        Node child = arrayPattern.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (!child.isEmpty()) {
                Node newNode;
                Node newRHS;
                Node newLHS;
                if (child.isDefaultValue()) {
                    Node getElem = IR.getelem(IR.name(tempVarName), IR.number(i));
                    newLHS = child.getFirstChild().detachFromParent();
                    newRHS = Es6ToEs3Converter.defaultValueHook(getElem, child.getLastChild().detachFromParent());
                } else if (child.isRest()) {
                    newLHS = child.detachFromParent();
                    newLHS.setType(38);
                    newRHS = IR.call(IR.getprop(IR.getprop(IR.arraylit(new Node[0]), IR.string("slice")), IR.string("call")), IR.name(tempVarName), IR.number(i));
                } else {
                    newLHS = child.detachFromParent();
                    newRHS = IR.getelem(IR.name(tempVarName), IR.number(i));
                }
                if (parent.isAssign()) {
                    Node assignment = IR.assign(newLHS, newRHS);
                    newNode = IR.exprResult(assignment);
                } else {
                    newNode = IR.declaration(newLHS, newRHS, parent.getType());
                }
                newNode.useSourceInfoIfMissingFromForTree(arrayPattern);
                nodeToDetach.getParent().addChildBefore(newNode, nodeToDetach);
                this.visit(t, newLHS, newLHS.getParent());
            }
            child = next;
            ++i;
        }
        nodeToDetach.detachFromParent();
        this.compiler.reportCodeChange();
    }

    private void visitDestructuringPatternInCatch(Node pattern) {
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node catchBlock = pattern.getNext();
        pattern.getParent().replaceChild(pattern, IR.name(tempVarName));
        catchBlock.addChildToFront(IR.declaration(pattern, IR.name(tempVarName), 162));
    }

    private void visitDestructuringPatternInEnhancedFor(Node pattern) {
        int declarationType;
        Node forNode;
        if (NodeUtil.isEnhancedFor(pattern.getParent())) {
            forNode = pattern.getParent();
            declarationType = 86;
        } else {
            forNode = pattern.getParent().getParent();
            declarationType = pattern.getParent().getType();
            Preconditions.checkState((boolean)NodeUtil.isEnhancedFor(forNode));
        }
        String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
        Node block = forNode.getLastChild();
        if (declarationType == 86) {
            pattern.getParent().replaceChild(pattern, IR.declaration(IR.name(tempVarName), 162));
            block.addChildToFront(IR.exprResult(IR.assign(pattern, IR.name(tempVarName))));
        } else {
            pattern.getParent().replaceChild(pattern, IR.name(tempVarName));
            block.addChildToFront(IR.declaration(pattern, IR.name(tempVarName), declarationType));
        }
    }

    private void visitMemberDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node stringKey = IR.stringKey(name, n.getFirstChild().detachFromParent());
        parent.replaceChild(n, stringKey);
        this.compiler.reportCodeChange();
    }

    private void visitStringKey(Node n) {
        if (!n.hasChildren()) {
            Node name = IR.name(n.getString());
            name.copyInformationFrom(n);
            n.addChildToBack(name);
            this.compiler.reportCodeChange();
        }
    }

    private void visitForOf(Node node, Node parent) {
        Node variable = node.removeFirstChild();
        Node iterable = node.removeFirstChild();
        Node body = node.removeFirstChild();
        Node iterName = IR.name(ITER_BASE + (String)this.compiler.getUniqueNameIdSupplier().get());
        Node getNext = IR.call(IR.getprop(iterName.cloneTree(), IR.string("next")), new Node[0]);
        String variableName = variable.isName() ? variable.getQualifiedName() : variable.getFirstChild().getQualifiedName();
        Node iterResult = IR.name(ITER_RESULT + variableName);
        Node makeIter = IR.call(NodeUtil.newQName(this.compiler, MAKE_ITER), iterable);
        this.compiler.needsEs6Runtime = true;
        Node init = IR.var(iterName.cloneTree(), makeIter);
        Node initIterResult = iterResult.cloneTree();
        initIterResult.addChildToFront(getNext.cloneTree());
        init.addChildToBack(initIterResult);
        Node cond = IR.not(IR.getprop(iterResult.cloneTree(), IR.string("done")));
        Node incr = IR.assign(iterResult.cloneTree(), getNext.cloneTree());
        body.addChildToFront(IR.var(IR.name(variableName), IR.getprop(iterResult.cloneTree(), IR.string("value"))));
        Node newFor = IR.forNode(init, cond, incr, body);
        newFor.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, newFor);
        this.compiler.reportCodeChange();
    }

    private void checkClassReassignment(Node clazz) {
        Node name = NodeUtil.getClassNameNode(clazz);
        Node enclosingFunction = NodeUtil.getEnclosingFunction(clazz);
        if (enclosingFunction == null) {
            return;
        }
        CheckClassAssignments checkAssigns = new CheckClassAssignments(name);
        NodeTraversal.traverse(this.compiler, enclosingFunction, checkAssigns);
    }

    private void visitParamList(Node paramList, Node function) {
        Node insertSpot = null;
        Node block = function.getLastChild();
        for (int i = 0; i < paramList.getChildCount(); ++i) {
            Node param = paramList.getChildAtIndex(i);
            if (param.isDefaultValue()) {
                Node nameOrPattern = param.removeFirstChild();
                Node defaultValue = param.removeFirstChild();
                Node newParam = nameOrPattern.isName() ? nameOrPattern : IR.name(DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++);
                Node lhs = nameOrPattern.cloneTree();
                Node rhs = Es6ToEs3Converter.defaultValueHook(newParam.cloneTree(), defaultValue);
                Node newStatement = nameOrPattern.isName() ? IR.exprResult(IR.assign(lhs, rhs)) : IR.var(lhs, rhs);
                newStatement.useSourceInfoIfMissingFromForTree(param);
                block.addChildAfter(newStatement, insertSpot);
                insertSpot = newStatement;
                paramList.replaceChild(param, newParam);
                newParam.setOptionalArg(true);
                this.compiler.reportCodeChange();
                continue;
            }
            if (param.isRest()) {
                param.setType(38);
                param.setVarArgs(true);
                Node newArr = IR.exprResult(IR.assign(IR.name(param.getString()), IR.call(IR.getprop(IR.getprop(IR.arraylit(new Node[0]), IR.string("slice")), IR.string("call")), IR.name("arguments"), IR.number(i))));
                block.addChildAfter(newArr.useSourceInfoIfMissingFromForTree(param), insertSpot);
                this.compiler.reportCodeChange();
                continue;
            }
            if (!param.isDestructuringPattern()) continue;
            String tempVarName = DESTRUCTURING_TEMP_VAR + this.destructuringVarCounter++;
            paramList.replaceChild(param, IR.name(tempVarName));
            Node newDecl = IR.var(param, IR.name(tempVarName));
            block.addChildAfter(newDecl, insertSpot);
            insertSpot = newDecl;
        }
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((node.isCall() || node.isArrayLit() || node.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node callee = node.isArrayLit() ? null : node.removeFirstChild();
        Node currElement = node.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                if (currGroup != null) {
                    groups.add(currGroup);
                    currGroup = null;
                }
                groups.add(currElement.removeFirstChild());
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = node.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        Node result = null;
        Node joinedGroups = IR.call(IR.getprop(IR.arraylit(new Node[0]), IR.string("concat")), groups.toArray(new Node[groups.size()]));
        if (node.isArrayLit()) {
            result = joinedGroups;
        } else if (node.isCall()) {
            if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
                Node statement = node;
                while (!NodeUtil.isStatement(statement)) {
                    statement = statement.getParent();
                }
                Node freshVar = IR.name(FRESH_SPREAD_VAR + (String)this.compiler.getUniqueNameIdSupplier().get());
                Node n = IR.var(freshVar.cloneTree());
                n.useSourceInfoIfMissingFromForTree(statement);
                statement.getParent().addChildBefore(n, statement);
                callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
                result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
            } else {
                Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
                result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
            }
        } else {
            Node bindApply = NodeUtil.newQName(this.compiler, "Function.prototype.bind.apply");
            result = IR.newNode(bindApply, callee, joinedGroups);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportCodeChange();
    }

    private void visitObjectWithComputedProperty(Node obj, Node parent) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List<Node> props = new ArrayList();
        Node currElement = obj.getFirstChild();
        while (currElement != null) {
            if (currElement.getBooleanProp(73) || currElement.getBooleanProp(74)) {
                this.cannotConvertYet(currElement, "computed getter/setter");
                return;
            }
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + (String)this.compiler.getUniqueNameIdSupplier().get();
        props = Lists.reverse(props);
        Node result = IR.name(objName);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = IR.comma(IR.assign(IR.getelem(IR.name(objName), propertyExpression), value), result);
                continue;
            }
            if (!propdef.hasChildren()) {
                Node name = IR.name(propdef.getString()).copyInformationFrom(propdef);
                propdef.addChildToBack(name);
            }
            Node val = propdef.removeFirstChild();
            propdef.setType(40);
            int type = propdef.isQuotedString() ? 35 : 33;
            Node access = new Node(type, IR.name(objName), propdef);
            result = IR.comma(IR.assign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        parent.replaceChild(obj, result);
        Node var = IR.var(IR.name(objName), obj);
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportCodeChange();
    }

    private void visitClass(Node classNode, Node parent) {
        Node var;
        Node insertionPoint;
        boolean anonymous;
        this.checkClassReassignment(classNode);
        Node className = classNode.getFirstChild();
        Node superClassName = className.getNext();
        Node classMembers = classNode.getLastChild();
        if (!superClassName.isEmpty() && !superClassName.isQualifiedName()) {
            this.compiler.report(JSError.make(superClassName, DYNAMIC_EXTENDS_TYPE, new String[0]));
            return;
        }
        String fullClassName = null;
        if (NodeUtil.isStatement(classNode)) {
            fullClassName = className.getString();
            anonymous = false;
            insertionPoint = classNode;
        } else if (parent.isAssign() && parent.getParent().isExprResult()) {
            fullClassName = parent.getFirstChild().getQualifiedName();
            if (fullClassName == null) {
                this.cannotConvert(parent, "Can only convert classes that are declarations or the right hand side of a simple assignment.");
                return;
            }
            anonymous = true;
            insertionPoint = parent.getParent();
        } else if (parent.isName()) {
            fullClassName = parent.getString();
            anonymous = true;
            insertionPoint = parent.getParent();
        } else {
            this.cannotConvert(parent, "Can only convert classes that are declarations or the right hand side of a simple assignment.");
            return;
        }
        if (!className.isEmpty() && !className.getString().equals(fullClassName)) {
            this.cannotConvertYet(classNode, "named class in an assignment");
            return;
        }
        boolean useUnique = NodeUtil.isStatement(classNode) && !NodeUtil.isInFunction(classNode);
        String uniqueFullClassName = useUnique ? Es6ToEs3Converter.getUniqueClassName(fullClassName) : fullClassName;
        String superClassString = superClassName.getQualifiedName();
        Verify.verify((boolean)NodeUtil.isStatement(insertionPoint));
        Node constructor = null;
        JSDocInfo ctorJSDocInfo = null;
        for (Node member : classMembers.children()) {
            Node method;
            Node qualifiedMemberName;
            if (member.isEmpty()) continue;
            if (member.isMemberDef() && member.getString().equals("constructor")) {
                ctorJSDocInfo = member.getJSDocInfo();
                constructor = member.getFirstChild().detachFromParent();
                if (anonymous) continue;
                constructor.replaceChild(constructor.getFirstChild(), className.cloneNode());
                continue;
            }
            if (member.isMemberDef()) {
                qualifiedMemberName = member.isStaticMember() ? NodeUtil.newQName(this.compiler, Joiner.on((String)".").join((Object)uniqueFullClassName, (Object)member.getString(), new Object[0])) : NodeUtil.newQName(this.compiler, Joiner.on((String)".").join((Object)uniqueFullClassName, (Object)"prototype", new Object[]{member.getString()}));
                method = member.getFirstChild().detachFromParent();
            } else if (member.isComputedProp()) {
                qualifiedMemberName = member.isStaticMember() ? IR.getelem(NodeUtil.newQName(this.compiler, uniqueFullClassName), member.removeFirstChild()) : IR.getelem(NodeUtil.newQName(this.compiler, Joiner.on((char)'.').join((Object)uniqueFullClassName, (Object)"prototype", new Object[0])), member.removeFirstChild());
                method = member.getLastChild().detachFromParent();
            } else {
                throw new IllegalStateException("Unexpected class member: " + member);
            }
            Node assign = IR.assign(qualifiedMemberName, method);
            assign.useSourceInfoIfMissingFromForTree(member);
            JSDocInfo info = member.getJSDocInfo();
            if (member.isStaticMember() && NodeUtil.referencesThis(assign.getLastChild())) {
                JSDocInfoBuilder memberDoc = info == null ? new JSDocInfoBuilder(true) : JSDocInfoBuilder.copyFrom(info);
                memberDoc.recordThisType(new JSTypeExpression(new Node(306, new Node(304)), member.getSourceFileName()));
                info = memberDoc.build(assign);
            }
            if (info != null) {
                info.setAssociatedNode(assign);
                assign.setJSDocInfo(info);
            }
            Node newNode = NodeUtil.newExpr(assign);
            insertionPoint.getParent().addChildAfter(newNode, insertionPoint);
            insertionPoint = newNode;
        }
        Preconditions.checkNotNull(constructor);
        JSDocInfo classJSDoc = classNode.getJSDocInfo();
        JSDocInfoBuilder newInfo = classJSDoc != null ? JSDocInfoBuilder.copyFrom(classJSDoc) : new JSDocInfoBuilder(true);
        newInfo.recordConstructor();
        if (!superClassName.isEmpty()) {
            if (newInfo.isInterfaceRecorded()) {
                newInfo.recordExtendedInterface(new JSTypeExpression(new Node(306, IR.string(superClassString)), superClassName.getSourceFileName()));
            } else {
                Node inherits = IR.call(NodeUtil.newQName(this.compiler, INHERITS), NodeUtil.newQName(this.compiler, fullClassName), NodeUtil.newQName(this.compiler, superClassString));
                Node inheritsCall = IR.exprResult(inherits);
                this.compiler.needsEs6Runtime = true;
                inheritsCall.useSourceInfoIfMissingFromForTree(classNode);
                Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
                enclosingStatement.getParent().addChildAfter(inheritsCall, enclosingStatement);
                newInfo.recordBaseType(new JSTypeExpression(new Node(306, IR.string(superClassString)), superClassName.getSourceFileName()));
                Node copyProps = IR.call(NodeUtil.newQName(this.compiler, COPY_PROP), NodeUtil.newQName(this.compiler, fullClassName), NodeUtil.newQName(this.compiler, superClassString));
                this.compiler.needsEs6Runtime = true;
                copyProps.useSourceInfoIfMissingFromForTree(classNode);
                enclosingStatement.getParent().addChildAfter(IR.exprResult(copyProps).srcref(classNode), enclosingStatement);
            }
        }
        if (!(newInfo.isUnrestrictedRecorded() || newInfo.isDictRecorded() || newInfo.isStructRecorded())) {
            newInfo.recordStruct();
        }
        if (ctorJSDocInfo != null) {
            newInfo.recordSuppressions(ctorJSDocInfo.getSuppressions());
            for (String param : ctorJSDocInfo.getParameterNames()) {
                newInfo.recordParameter(param, ctorJSDocInfo.getParameterType(param));
            }
        }
        insertionPoint = constructor;
        if (NodeUtil.isStatement(classNode)) {
            constructor.getFirstChild().setString("");
            Node ctorVar = IR.var(IR.name(fullClassName), constructor);
            ctorVar.useSourceInfoIfMissingFromForTree(classNode);
            parent.replaceChild(classNode, ctorVar);
        } else {
            parent.replaceChild(classNode, constructor);
        }
        if (NodeUtil.isStatement(constructor)) {
            insertionPoint.setJSDocInfo(newInfo.build(insertionPoint));
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(newInfo.build(var));
        } else if (constructor.getParent().isName()) {
            var = constructor.getParent().getParent();
            var.setJSDocInfo(newInfo.build(var));
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(newInfo.build(parent));
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        this.compiler.reportCodeChange();
    }

    private void visitArrowFunction(NodeTraversal t, Node n) {
        n.setIsArrowFunction(false);
        Node body = n.getLastChild();
        if (!body.isBlock()) {
            body.detachFromParent();
            body = IR.block(IR.returnNode(body).srcref(body)).srcref(body);
            n.addChildToBack(body);
        }
        UpdateThisAndArgumentsReferences updater = new UpdateThisAndArgumentsReferences();
        NodeTraversal.traverse(this.compiler, body, updater);
        this.addVarDecls(t, updater.changedThis, updater.changedArguments);
        this.compiler.reportCodeChange();
    }

    private void addVarDecls(NodeTraversal t, boolean addThis, boolean addArguments) {
        Node name;
        Node parent;
        Scope scope = t.getScope();
        if (scope.isDeclared(THIS_VAR, false)) {
            addThis = false;
        }
        if (scope.isDeclared(ARGUMENTS_VAR, false)) {
            addArguments = false;
        }
        if ((parent = t.getScopeRoot()).isFunction()) {
            parent = parent.getLastChild();
        }
        if (parent.isSyntheticBlock() && parent.getFirstChild().isScript()) {
            parent = parent.getFirstChild();
        }
        CompilerInput input = this.compiler.getInput(parent.getInputId());
        if (addArguments) {
            name = IR.name(ARGUMENTS_VAR).srcref(parent);
            Node argumentsVar = IR.var(name, IR.name("arguments").srcref(parent));
            argumentsVar.srcref(parent);
            parent.addChildToFront(argumentsVar);
            scope.declare(ARGUMENTS_VAR, name, null, input);
        }
        if (addThis) {
            name = IR.name(THIS_VAR).srcref(parent);
            Node thisVar = IR.var(name, IR.thisNode().srcref(parent));
            thisVar.srcref(parent);
            parent.addChildToFront(thisVar);
            scope.declare(THIS_VAR, name, null, input);
        }
    }

    static String getUniqueClassName(String qualifiedName) {
        return qualifiedName;
    }

    private static Node defaultValueHook(Node getprop, Node defaultValue) {
        return IR.hook(IR.sheq(getprop, IR.name("undefined")), defaultValue, getprop.cloneTree());
    }

    private void cannotConvert(Node n, String message) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    private void cannotConvertYet(Node n, String feature) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    private class CheckClassAssignments
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node className;

        public CheckClassAssignments(Node className) {
            this.className = className;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isAssign() || n.getFirstChild() == this.className) {
                return;
            }
            if (this.className.matchesQualifiedName(n.getFirstChild())) {
                Es6ToEs3Converter.this.compiler.report(JSError.make(n, CLASS_REASSIGNMENT, new String[0]));
            }
        }
    }

    private static class UpdateThisAndArgumentsReferences
    implements NodeTraversal.Callback {
        private boolean changedThis = false;
        private boolean changedArguments = false;

        private UpdateThisAndArgumentsReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                Node name = IR.name(Es6ToEs3Converter.THIS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedThis = true;
            } else if (n.isName() && n.getString().equals("arguments")) {
                Node name = IR.name(Es6ToEs3Converter.ARGUMENTS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedArguments = true;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }
}

