/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Map;
import java.util.Set;

public class InlineProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final PropertyInfo INVALIDATED = new PropertyInfo(null, null);
    private final Map<String, PropertyInfo> props = Maps.newHashMap();
    private Set<JSType> invalidatingTypes;

    InlineProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.buildInvalidatingTypeSet();
        this.invalidateExternProperties();
    }

    private void buildInvalidatingTypeSet() {
        JSTypeRegistry registry = this.compiler.getTypeRegistry();
        this.invalidatingTypes = Sets.newHashSet((Object[])new JSType[]{registry.getNativeType(JSTypeNative.ALL_TYPE), registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), registry.getNativeType(JSTypeNative.NO_TYPE), registry.getNativeType(JSTypeNative.NULL_TYPE), registry.getNativeType(JSTypeNative.VOID_TYPE), registry.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), registry.getNativeType(JSTypeNative.GLOBAL_THIS), registry.getNativeType(JSTypeNative.OBJECT_TYPE), registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), registry.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)});
        for (TypeValidator.TypeMismatch mis : this.compiler.getTypeValidator().getMismatches()) {
            this.addInvalidatingType(mis.typeA);
            this.addInvalidatingType(mis.typeB);
        }
    }

    private void invalidateExternProperties() {
        for (String name : this.compiler.getExternProperties()) {
            this.props.put(name, INVALIDATED);
        }
    }

    private void addInvalidatingType(JSType type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.addInvalidatingType(alt);
            }
        }
        this.invalidatingTypes.add(type);
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && objType.isInstanceType()) {
            this.invalidatingTypes.add(objType.getImplicitPrototype());
        }
    }

    private boolean isInvalidatingType(JSType type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!this.isInvalidatingType(alt)) continue;
                return true;
            }
            return false;
        }
        ObjectType objType = ObjectType.cast(type);
        return objType == null || this.invalidatingTypes.contains(objType) || !objType.hasReferenceName() || objType.isUnknownType() || objType.isEmptyType() || objType.isEnumType() || objType.autoboxesTo() != null;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherCandidates());
        NodeTraversal.traverse(this.compiler, root, new ReplaceCandidates());
    }

    class ReplaceCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        ReplaceCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp() && !NodeUtil.isLValue(n)) {
                Node target = n.getFirstChild();
                String propName = n.getLastChild().getString();
                PropertyInfo info = (PropertyInfo)InlineProperties.this.props.get(propName);
                if (info != null && info != INVALIDATED && this.isMatchingType(target, info.type)) {
                    Node replacement = info.value.cloneTree();
                    if (NodeUtil.mayHaveSideEffects(n.getFirstChild(), InlineProperties.this.compiler)) {
                        replacement = IR.comma(n.removeFirstChild(), replacement).srcref(n);
                    }
                    parent.replaceChild(n, replacement);
                    InlineProperties.this.compiler.reportCodeChange();
                }
            }
        }

        private boolean isMatchingType(Node n, JSType src) {
            src = src.restrictByNotNullOrUndefined();
            JSType dest = InlineProperties.this.getJSType(n).restrictByNotNullOrUndefined();
            return !InlineProperties.this.isInvalidatingType(dest) && dest.isSubtype(src);
        }
    }

    class GatherCandidates
    extends NodeTraversal.AbstractPostOrderCallback {
        GatherCandidates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean invalidatingPropRef = false;
            String propName = null;
            if (n.isGetProp()) {
                propName = n.getLastChild().getString();
                invalidatingPropRef = parent.isAssign() ? !this.maybeCandidateDefinition(t, n, parent) : (NodeUtil.isLValue(n) ? true : parent.isDelProp());
            } else if (n.isStringKey()) {
                propName = n.getString();
                invalidatingPropRef = true;
            }
            if (invalidatingPropRef) {
                Preconditions.checkNotNull((Object)propName);
                this.invalidateProperty(propName);
            }
        }

        private boolean maybeCandidateDefinition(NodeTraversal t, Node n, Node parent) {
            JSType instanceType;
            Preconditions.checkState((n.isGetProp() && parent.isAssign() ? 1 : 0) != 0);
            boolean isCandidate = false;
            Node src = n.getFirstChild();
            String propName = n.getLastChild().getString();
            Node value = parent.getLastChild();
            if (src.isThis()) {
                if (this.inConstructor(t)) {
                    isCandidate = this.maybeStoreCandidateValue(InlineProperties.this.getJSType(src), propName, value);
                }
            } else if (t.inGlobalScope() && src.isGetProp() && src.getLastChild().getString().equals("prototype") && (instanceType = this.maybeGetInstanceTypeFromPrototypeRef(src)) != null) {
                isCandidate = this.maybeStoreCandidateValue(instanceType, propName, value);
            }
            return isCandidate;
        }

        private JSType maybeGetInstanceTypeFromPrototypeRef(Node src) {
            JSType ownerType = InlineProperties.this.getJSType(src.getFirstChild());
            if (ownerType.isFunctionType() && ownerType.isConstructor()) {
                FunctionType functionType = (FunctionType)ownerType;
                return functionType.getInstanceType();
            }
            return null;
        }

        private void invalidateProperty(String propName) {
            InlineProperties.this.props.put(propName, INVALIDATED);
        }

        private boolean maybeStoreCandidateValue(JSType type, String propName, Node value) {
            Preconditions.checkNotNull((Object)value);
            if (!InlineProperties.this.props.containsKey(propName) && !InlineProperties.this.isInvalidatingType(type) && NodeUtil.isImmutableValue(value) && NodeUtil.isExecutedExactlyOnce(value)) {
                InlineProperties.this.props.put(propName, new PropertyInfo(type, value));
                return true;
            }
            return false;
        }

        private boolean inConstructor(NodeTraversal t) {
            Node root = t.getScopeRoot();
            JSDocInfo info = NodeUtil.getBestJSDocInfo(root);
            return info != null && info.isConstructor();
        }
    }

    static class PropertyInfo {
        final JSType type;
        final Node value;

        PropertyInfo(JSType type, Node value) {
            this.type = type;
            this.value = value;
        }
    }
}

