/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.BlockFuzzer;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class SwitchFuzzer
extends AbstractFuzzer {
    SwitchFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 2;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int numCases = budget > 2 ? this.context.random.nextInt(budget - 2) : 0;
        Object[] fuzzers = new AbstractFuzzer[numCases + 1];
        CaseFuzzer caseFuzzer = new CaseFuzzer(this.context, 111);
        Arrays.fill(fuzzers, caseFuzzer);
        fuzzers[0] = new ExpressionFuzzer(this.context);
        if (numCases > 0) {
            int defaultClauseIndex = this.context.random.nextInt(numCases);
            fuzzers[defaultClauseIndex + 1] = new CaseFuzzer(this.context, 112);
        }
        Scope localScope = this.context.scopeManager.localScope();
        ++localScope.switchNesting;
        Node[] components = this.distribute(budget - 1, (AbstractFuzzer[])fuzzers);
        --localScope.switchNesting;
        return new Node(110, components);
    }

    @Override
    protected String getConfigName() {
        return "switch";
    }

    private static class CaseFuzzer
    extends AbstractFuzzer {
        private int nodeType;

        CaseFuzzer(FuzzingContext context, int nodeType) {
            super(context);
            this.nodeType = nodeType;
        }

        @Override
        protected boolean isEnough(int budget) {
            if (this.nodeType == 111) {
                return budget >= 3;
            }
            return budget >= 2;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            Node clause = new Node(this.nodeType);
            if (this.nodeType == 111) {
                int valueBudget = (int)((double)budget * this.getOwnConfig().get("valueBudget").getAsDouble());
                if (valueBudget == 0) {
                    valueBudget = 1;
                }
                clause.addChildToBack(new ExpressionFuzzer(this.context).generate(valueBudget));
                budget -= valueBudget;
            }
            Node block = new BlockFuzzer(this.context).generate(budget + 1);
            block.setIsSyntheticBlock(true);
            clause.addChildrenToBack(block);
            return clause;
        }

        @Override
        protected String getConfigName() {
            return "case";
        }
    }
}

