/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkedDirectedGraph<N, E>
extends DiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedDirectedGraphNode<N, E>> nodes = new HashMap<N, LinkedDirectedGraphNode<N, E>>();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> create() {
        return new LinkedDirectedGraph<N, E>(true, true);
    }

    protected LinkedDirectedGraph(boolean useNodeAnnotations, boolean useEdgeAnnotations) {
        this.useNodeAnnotations = useNodeAnnotations;
        this.useEdgeAnnotations = useEdgeAnnotations;
    }

    @Override
    public void connect(N srcValue, E edgeValue, N destValue) {
        LinkedDirectedGraphNode src = (LinkedDirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedDirectedGraphNode dest = (LinkedDirectedGraphNode)this.getNodeOrFail(destValue);
        LinkedDirectedGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedDirectedGraphEdge(src, edgeValue, dest) : new LinkedDirectedGraphEdge(src, edgeValue, dest);
        src.getOutEdges().add(edge);
        dest.getInEdges().add(edge);
    }

    @Override
    public void connect(DiGraph.DiGraphNode<N, E> src, E edgeValue, DiGraph.DiGraphNode<N, E> dest) {
        LinkedDirectedGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedDirectedGraphEdge<N, E>(src, edgeValue, dest) : new LinkedDirectedGraphEdge<N, E>(src, edgeValue, dest);
        src.getOutEdges().add(edge);
        dest.getInEdges().add(edge);
    }

    public void connectIfNotConnectedInDirection(N srcValue, E edgeValue, N destValue) {
        DiGraph.DiGraphNode src = this.createDirectedGraphNode((Object)srcValue);
        DiGraph.DiGraphNode dest = this.createDirectedGraphNode((Object)destValue);
        if (!this.isConnectedInDirection((N)src, (Predicate<E>)Predicates.equalTo(edgeValue), (N)dest)) {
            this.connect(src, edgeValue, dest);
        }
    }

    @Override
    public void disconnect(N n1, N n2) {
        this.disconnectInDirection(n1, n2);
        this.disconnectInDirection(n2, n1);
    }

    @Override
    public void disconnectInDirection(N srcValue, N destValue) {
        LinkedDirectedGraphNode src = (LinkedDirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedDirectedGraphNode dest = (LinkedDirectedGraphNode)this.getNodeOrFail(destValue);
        for (DiGraph.DiGraphEdge<N, E> edge : this.getDirectedGraphEdges(srcValue, destValue)) {
            src.getOutEdges().remove(edge);
            dest.getInEdges().remove(edge);
        }
    }

    @Override
    public Iterable<DiGraph.DiGraphNode<N, E>> getDirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public DiGraph.DiGraphNode<N, E> getDirectedGraphNode(N nodeValue) {
        return this.nodes.get(nodeValue);
    }

    @Override
    public GraphNode<N, E> getNode(N nodeValue) {
        return this.getDirectedGraphNode(nodeValue);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getInEdges(N nodeValue) {
        LinkedDirectedGraphNode node = (LinkedDirectedGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getInEdges());
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getOutEdges(N nodeValue) {
        LinkedDirectedGraphNode node = (LinkedDirectedGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getOutEdges());
    }

    @Override
    public LinkedDirectedGraphNode<N, E> createDirectedGraphNode(N nodeValue) {
        LinkedDirectedGraphNode<N, E> node = this.nodes.get(nodeValue);
        if (node == null) {
            node = this.useNodeAnnotations ? new AnnotatedLinkedDirectedGraphNode(nodeValue) : new LinkedDirectedGraphNode(nodeValue);
            this.nodes.put(nodeValue, node);
        }
        return node;
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getEdges(N n1, N n2) {
        List<DiGraph.DiGraphEdge<N, E>> forwardEdges = this.getDirectedGraphEdges(n1, n2);
        List<DiGraph.DiGraphEdge<N, E>> backwardEdges = this.getDirectedGraphEdges(n2, n1);
        int totalSize = forwardEdges.size() + backwardEdges.size();
        ArrayList<DiGraph.DiGraphEdge<N, DiGraph.DiGraphEdge<N, E>>> edges = new ArrayList<DiGraph.DiGraphEdge<N, DiGraph.DiGraphEdge<N, E>>>(totalSize);
        edges.addAll(forwardEdges);
        edges.addAll(backwardEdges);
        return edges;
    }

    @Override
    public Graph.GraphEdge<N, E> getFirstEdge(N n1, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2) continue;
            return outEdge;
        }
        for (DiGraph.DiGraphEdge outEdge : dNode2.getOutEdges()) {
            if (outEdge.getDestination() != dNode1) continue;
            return outEdge;
        }
        return null;
    }

    @Override
    public GraphNode<N, E> createNode(N value) {
        return this.createDirectedGraphNode((Object)value);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getDirectedGraphEdges(N n1, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        ArrayList edges = new ArrayList();
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2) continue;
            edges.add(outEdge);
        }
        return edges;
    }

    @Override
    public boolean isConnectedInDirection(N n1, N n2) {
        return this.isConnectedInDirection(n1, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnectedInDirection(N n1, E edgeValue, N n2) {
        return this.isConnectedInDirection(n1, Predicates.equalTo(edgeValue), n2);
    }

    @Override
    public boolean isConnectedInDirection(DiGraph.DiGraphNode<N, E> dNode1, Predicate<E> edgeMatcher, DiGraph.DiGraphNode<N, E> dNode2) {
        List<DiGraph.DiGraphEdge<N, E>> outEdges = dNode1.getOutEdges();
        int len = outEdges.size();
        for (int i = 0; i < len; ++i) {
            DiGraph.DiGraphEdge<N, E> outEdge = outEdges.get(i);
            if (outEdge.getDestination() != dNode2 || !edgeMatcher.apply(outEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    private boolean isConnectedInDirection(N n1, Predicate<E> edgeMatcher, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2 || !edgeMatcher.apply(outEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(N nodeValue) {
        return this.getDirectedPredNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(N nodeValue) {
        return this.getDirectedSuccNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(DiGraph.DiGraphNode<N, E> dNode) {
        Preconditions.checkNotNull(dNode);
        ArrayList<DiGraph.DiGraphNode<N, DiGraph.DiGraphNode<N, E>>> nodeList = new ArrayList<DiGraph.DiGraphNode<N, DiGraph.DiGraphNode<N, E>>>(dNode.getInEdges().size());
        for (DiGraph.DiGraphEdge<N, E> edge : dNode.getInEdges()) {
            nodeList.add(edge.getSource());
        }
        return nodeList;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(DiGraph.DiGraphNode<N, E> dNode) {
        Preconditions.checkNotNull(dNode);
        ArrayList<DiGraph.DiGraphNode<N, DiGraph.DiGraphNode<N, E>>> nodeList = new ArrayList<DiGraph.DiGraphNode<N, DiGraph.DiGraphNode<N, E>>>(dNode.getOutEdges().size());
        for (DiGraph.DiGraphEdge<N, E> edge : dNode.getOutEdges()) {
            nodeList.add(edge.getDestination());
        }
        return nodeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList<GraphvizGraph.GraphvizEdge> edgeList = new ArrayList<GraphvizGraph.GraphvizEdge>();
        for (LinkedDirectedGraphNode<N, E> node : this.nodes.values()) {
            for (DiGraph.DiGraphEdge<N, E> edge : node.getOutEdges()) {
                edgeList.add((LinkedDirectedGraphEdge)edge);
            }
        }
        return edgeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList<GraphvizGraph.GraphvizNode> nodeList = new ArrayList<GraphvizGraph.GraphvizNode>(this.nodes.size());
        for (LinkedDirectedGraphNode<N, E> node : this.nodes.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public String getName() {
        return "LinkedGraph";
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public Collection<DiGraph.DiGraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N value) {
        DiGraph.DiGraphNode<N, E> node = this.getDirectedGraphNode(value);
        ArrayList<GraphNode<N, DiGraph.DiGraphNode<N, E>>> result = new ArrayList<GraphNode<N, DiGraph.DiGraphNode<N, E>>>(node.getInEdges().size() + node.getOutEdges().size());
        for (DiGraph.DiGraphEdge<N, E> inEdge : node.getInEdges()) {
            result.add(inEdge.getSource());
        }
        for (DiGraph.DiGraphEdge<N, E> outEdge : node.getOutEdges()) {
            result.add(outEdge.getDestination());
        }
        return result;
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getEdges() {
        ArrayList result = new ArrayList();
        for (DiGraph.DiGraphNode diGraphNode : this.nodes.values()) {
            result.addAll(diGraphNode.getOutEdges());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getNodeDegree(N value) {
        DiGraph.DiGraphNode node = (DiGraph.DiGraphNode)this.getNodeOrFail(value);
        return node.getInEdges().size() + node.getOutEdges().size();
    }

    static class AnnotatedLinkedDirectedGraphEdge<N, E>
    extends LinkedDirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> sourceNode, E edgeValue, DiGraph.DiGraphNode<N, E> destNode) {
            super(sourceNode, edgeValue, destNode);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedDirectedGraphEdge<N, E>
    implements DiGraph.DiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private DiGraph.DiGraphNode<N, E> sourceNode;
        private DiGraph.DiGraphNode<N, E> destNode;
        protected final E value;

        LinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> sourceNode, E edgeValue, DiGraph.DiGraphNode<N, E> destNode) {
            this.value = edgeValue;
            this.sourceNode = sourceNode;
            this.destNode = destNode;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getSource() {
            return this.sourceNode;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getDestination() {
            return this.destNode;
        }

        @Override
        public void setDestination(DiGraph.DiGraphNode<N, E> node) {
            this.destNode = node;
        }

        @Override
        public void setSource(DiGraph.DiGraphNode<N, E> node) {
            this.sourceNode = node;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return String.valueOf(this.value);
        }

        @Override
        public String getNode1Id() {
            return ((LinkedDirectedGraphNode)this.sourceNode).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedDirectedGraphNode)this.destNode).getId();
        }

        public String toString() {
            return this.sourceNode + " -> " + this.destNode;
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.sourceNode;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.destNode;
        }
    }

    static class AnnotatedLinkedDirectedGraphNode<N, E>
    extends LinkedDirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphNode(N nodeValue) {
            super(nodeValue);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    public static class LinkedDirectedGraphNode<N, E>
    implements DiGraph.DiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        List<DiGraph.DiGraphEdge<N, E>> inEdgeList = new ArrayList<DiGraph.DiGraphEdge<N, E>>();
        List<DiGraph.DiGraphEdge<N, E>> outEdgeList = new ArrayList<DiGraph.DiGraphEdge<N, E>>();
        protected final N value;

        LinkedDirectedGraphNode(N nodeValue) {
            this.value = nodeValue;
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getInEdges() {
            return this.inEdgeList;
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getOutEdges() {
            return this.outEdgeList;
        }
    }
}

