/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FunctionType {
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    final NominalType nominalType;
    private final NominalType receiverType;
    private final ImmutableList<String> typeParameters;
    private static final boolean DEBUGGING = false;
    static final FunctionType TOP_FUNCTION = new FunctionType(false);
    private static final FunctionType LOOSE_TOP_FUNCTION = new FunctionType(true);
    static final FunctionType QMARK_FUNCTION = FunctionType.normalized(null, null, JSType.UNKNOWN, JSType.UNKNOWN, null, null, null, null, true);
    private static final FunctionType BOTTOM_FUNCTION = FunctionType.normalized(null, null, null, JSType.BOTTOM, null, null, null, null, false);

    private FunctionType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, NominalType receiverType, ImmutableMap<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.receiverType = receiverType;
        this.outerVarPreconditions = outerVars;
        this.typeParameters = typeParameters;
        this.isLoose = isLoose;
        this.checkValid();
    }

    private FunctionType(boolean isLoose) {
        this.requiredFormals = null;
        this.optionalFormals = null;
        this.restFormals = null;
        this.returnType = null;
        this.nominalType = null;
        this.receiverType = null;
        this.outerVarPreconditions = null;
        this.typeParameters = null;
        this.isLoose = isLoose;
    }

    void checkValid() {
        if (this.isTopFunction() || this.isQmarkFunction()) {
            return;
        }
        Preconditions.checkNotNull(this.requiredFormals, (String)"null required formals for function: %s", (Object[])new Object[]{this});
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkNotNull((Object)formal);
        }
        Preconditions.checkNotNull(this.requiredFormals, (String)"null optional formals for function: %s", (Object[])new Object[]{this});
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkNotNull((Object)formal);
        }
        Preconditions.checkNotNull((Object)this.returnType);
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isLoose()) {
            return this;
        }
        if (this.isTopFunction()) {
            return LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.outerVarPreconditions, this.typeParameters, true);
    }

    static FunctionType normalized(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, NominalType receiverType, Map<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (restFormals != null) {
            for (int i = optionalFormals.size() - 1; i >= 0 && restFormals.equals(optionalFormals.get(i)); --i) {
                optionalFormals.remove(i);
            }
        }
        return new FunctionType((ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, nominalType, receiverType, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), typeParameters, isLoose);
    }

    public boolean isTopFunction() {
        return this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION;
    }

    public boolean isConstructor() {
        return this.nominalType != null && !this.nominalType.isInterface();
    }

    public boolean isInterfaceDefinition() {
        return this.nominalType != null && this.nominalType.isInterface();
    }

    public boolean isQmarkFunction() {
        return this == QMARK_FUNCTION;
    }

    static boolean isInhabitable(FunctionType f) {
        return f != BOTTOM_FUNCTION;
    }

    public boolean hasRestFormals() {
        return this.restFormals != null;
    }

    public JSType getFormalType(int argpos) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            Preconditions.checkState((null != this.requiredFormals.get(argpos) ? 1 : 0) != 0);
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            Preconditions.checkState((null != this.optionalFormals.get(argpos - numReqFormals) ? 1 : 0) != 0);
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public boolean isRequiredArg(int i) {
        return i < this.requiredFormals.size();
    }

    public boolean isOptionalArg(int i) {
        return i >= this.requiredFormals.size() && i < this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getInstanceTypeOfCtor() {
        if (!this.isGeneric()) {
            return this.nominalType.getInstanceAsJSType();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeVar : this.getTypeParameters()) {
            builder.put((Object)typeVar, (Object)JSType.UNKNOWN);
        }
        return this.instantiateGenerics((Map<String, JSType>)builder.build()).nominalType.getInstanceAsJSType();
    }

    public JSType getThisType() {
        if (this.receiverType != null) {
            return this.receiverType.getInstanceAsJSType();
        }
        if (this.nominalType != null) {
            return this.nominalType.getInstanceAsJSType();
        }
        return null;
    }

    public JSType createConstructorObject(NominalType fnNominal) {
        Preconditions.checkState((this.nominalType != null ? 1 : 0) != 0);
        return NominalType.createConstructorObject(this, fnNominal);
    }

    public DeclaredFunctionType toDeclaredFunctionType() {
        if (this.isQmarkFunction()) {
            return FunctionTypeBuilder.qmarkFunctionBuilder().buildDeclaration();
        }
        Preconditions.checkState((!this.isLoose() ? 1 : 0) != 0);
        if (this.typeParameters != null) {
            return null;
        }
        if (this.nominalType != null) {
            return null;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType type : this.requiredFormals) {
            builder.addReqFormal(type);
        }
        for (JSType type : this.optionalFormals) {
            builder.addOptFormal(type);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType);
        builder.addNominalType(this.nominalType);
        builder.addReceiverType(this.receiverType);
        return builder.buildDeclaration();
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.meet(t1, t2);
    }

    private static FunctionType looseJoin(FunctionType f1, FunctionType f2) {
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        return builder.addRetType(JSType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isSubtypeOf(FunctionType other) {
        if (other.isTopFunction() || other.isQmarkFunction() || this.isQmarkFunction()) {
            return true;
        }
        if (this.isTopFunction()) {
            return false;
        }
        Preconditions.checkState((!this.isLoose() && !other.isLoose() ? 1 : 0) != 0);
        if (this.isGeneric()) {
            if (this.equals(other)) {
                return true;
            }
            return FunctionType.instantiateGenericsWithUnknown(this).isSubtypeOf(other);
        }
        if (this.requiredFormals.size() > other.requiredFormals.size()) {
            return false;
        }
        int otherMaxTotalArity = other.requiredFormals.size() + other.optionalFormals.size();
        for (int i = 0; i < otherMaxTotalArity; ++i) {
            JSType thisFormal = this.getFormalType(i);
            JSType otherFormal = other.getFormalType(i);
            if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal)) continue;
            return false;
        }
        if (other.restFormals != null) {
            int thisMaxTotalArity = this.requiredFormals.size() + this.optionalFormals.size();
            if (this.restFormals != null) {
                ++thisMaxTotalArity;
            }
            for (int i = otherMaxTotalArity; i < thisMaxTotalArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal)) continue;
                return false;
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null || this.nominalType != null && other.nominalType != null && !this.nominalType.isSubclassOf(other.nominalType)) {
            return false;
        }
        if (this.receiverType != null && other.receiverType == null || this.receiverType != null && other.receiverType != null && !this.receiverType.isSubclassOf(other.receiverType)) {
            return false;
        }
        return this.returnType.isUnknown() || other.returnType.isUnknown() || this.returnType.isSubtypeOf(other.returnType);
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addReqFormal(reqFormal);
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = maxRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addOptFormal(optFormal);
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        builder.addNominalType(NominalType.pickSuperclass(f1.nominalType, f2.nominalType));
        builder.addReceiverType(NominalType.pickSuperclass(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        if (other == null || other.isQmarkFunction() || !this.isLoose() && other.isLoose()) {
            return this;
        }
        FunctionType result = FunctionType.meet(this, other);
        if (this.isLoose() && !result.isLoose()) {
            result = result.withLoose();
        }
        return result;
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        JSType retType;
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        if (f1.isGeneric() && f1.isSubtypeOf(f2)) {
            return f1;
        }
        if (f2.isGeneric() && f2.isSubtypeOf(f1)) {
            return f2;
        }
        if (f1.isGeneric()) {
            f1 = FunctionType.instantiateGenericsWithUnknown(f1);
        }
        if (f2.isGeneric()) {
            f2 = FunctionType.instantiateGenericsWithUnknown(f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            builder.addRestFormals(JSType.nullAcceptingJoin(f1.restFormals, f2.restFormals));
        }
        if ((retType = JSType.meet(f1.returnType, f2.returnType)).isBottom()) {
            return BOTTOM_FUNCTION;
        }
        builder.addRetType(retType);
        builder.addNominalType(NominalType.pickSubclass(f1.nominalType, f2.nominalType));
        builder.addReceiverType(NominalType.pickSubclass(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int minRequiredArity = Math.min(this.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            if (!JSType.meet(this.getFormalType(i), f2.getFormalType(i)).isBottom()) continue;
            return false;
        }
        return this.getReturnType().isBottom() || f2.getReturnType().isBottom() || !JSType.meet(this.getReturnType(), f2.getReturnType()).isBottom();
    }

    public boolean isGeneric() {
        return this.typeParameters != null;
    }

    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    boolean unifyWith(FunctionType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        Preconditions.checkState((this.typeParameters == null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        if (this == LOOSE_TOP_FUNCTION || other == LOOSE_TOP_FUNCTION) {
            return true;
        }
        Preconditions.checkState((this.requiredFormals != null && other.requiredFormals != null ? 1 : 0) != 0, (String)"Cannot run unification algorithm on %s and %s", (Object[])new Object[]{this, other});
        if (this.requiredFormals.size() != other.requiredFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisReqFormals = this.requiredFormals.iterator();
        UnmodifiableIterator otherReqFormals = other.requiredFormals.iterator();
        while (thisReqFormals.hasNext()) {
            JSType otherReqFormal;
            JSType reqFormal = (JSType)thisReqFormals.next();
            if (reqFormal.unifyWith(otherReqFormal = (JSType)otherReqFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.optionalFormals.size() != other.optionalFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisOptFormals = this.optionalFormals.iterator();
        UnmodifiableIterator otherOptFormals = other.optionalFormals.iterator();
        while (thisOptFormals.hasNext()) {
            JSType otherOptFormal;
            JSType optFormal = (JSType)thisOptFormals.next();
            if (optFormal.unifyWith(otherOptFormal = (JSType)otherOptFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.restFormals == null && other.restFormals != null || this.restFormals != null && other.restFormals == null) {
            return false;
        }
        if (this.restFormals != null && !this.restFormals.unifyWith(other.restFormals, typeParameters, typeMultimap)) {
            return false;
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null) {
            return false;
        }
        if (this.nominalType != null && !this.nominalType.unifyWith(other.nominalType, typeParameters, typeMultimap)) {
            return false;
        }
        if (this.receiverType != null && other.receiverType != null && !this.receiverType.unifyWith(other.receiverType, typeParameters, typeMultimap)) {
            return false;
        }
        return this.returnType.unifyWith(other.returnType, typeParameters, typeMultimap);
    }

    private static FunctionType instantiateGenericsWithUnknown(FunctionType f) {
        if (!f.isGeneric()) {
            return f;
        }
        HashMap<String, JSType> tmpTypeMap = new HashMap<String, JSType>();
        for (String typeParam : f.typeParameters) {
            tmpTypeMap.put(typeParam, JSType.UNKNOWN);
        }
        return f.instantiateGenerics(tmpTypeMap);
    }

    static FunctionType unifyUnknowns(FunctionType f1, FunctionType f2) {
        JSType t;
        Preconditions.checkState((f1 != null || f2 != null ? 1 : 0) != 0);
        if (f1 == null || f2 == null) {
            return null;
        }
        Preconditions.checkArgument((f1.typeParameters == null ? 1 : 0) != 0);
        Preconditions.checkArgument((f2.typeParameters == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)f1.outerVarPreconditions.isEmpty());
        Preconditions.checkArgument((boolean)f2.outerVarPreconditions.isEmpty());
        if (f1.equals(f2)) {
            return f1;
        }
        ImmutableList<JSType> formals1 = f1.requiredFormals;
        ImmutableList<JSType> formals2 = f2.requiredFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int numReqFormals = formals1.size();
        for (int i = 0; i < numReqFormals; ++i) {
            JSType t2 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t2 == null) {
                return null;
            }
            builder.addReqFormal(t2);
        }
        formals1 = f1.optionalFormals;
        formals2 = f2.optionalFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        int numOptFormals = formals1.size();
        for (int i = 0; i < numOptFormals; ++i) {
            JSType t3 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t3 == null) {
                return null;
            }
            builder.addOptFormal(t3);
        }
        if (f1.restFormals == null && f2.restFormals != null || f1.restFormals != null && f2.restFormals == null) {
            return null;
        }
        if (f1.restFormals != null) {
            JSType t4 = JSType.unifyUnknowns(f1.restFormals, f2.restFormals);
            if (t4 == null) {
                return null;
            }
            builder.addRestFormals(t4);
        }
        if ((t = JSType.unifyUnknowns(f1.returnType, f2.returnType)) == null) {
            return null;
        }
        builder.addRetType(t);
        if (!Objects.equals(f1.nominalType, f2.nominalType)) {
            return null;
        }
        builder.addNominalType(f1.nominalType);
        if (!Objects.equals(f1.receiverType, f2.receiverType)) {
            return null;
        }
        builder.addReceiverType(f1.receiverType);
        return builder.buildFunction();
    }

    private FunctionType applyInstantiation(boolean keepTypeParams, Map<String, JSType> typeMap) {
        if (typeMap.isEmpty()) {
            return this;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose()) {
            builder.addLoose();
        }
        if (this.nominalType != null) {
            builder.addNominalType(this.nominalType.instantiateGenerics(typeMap));
        }
        if (this.receiverType != null) {
            builder.addReceiverType(this.receiverType.instantiateGenerics(typeMap));
        }
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        if (keepTypeParams) {
            builder.addTypeParameters(this.typeParameters);
        }
        return builder.buildFunction();
    }

    FunctionType substituteGenerics(Map<String, JSType> concreteTypes) {
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        ImmutableMap typeMap = concreteTypes;
        if (this.typeParameters != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, JSType> concreteTypeEntry : concreteTypes.entrySet()) {
                if (this.typeParameters.contains((Object)concreteTypeEntry.getKey())) continue;
                builder.put(concreteTypeEntry);
            }
            typeMap = builder.build();
        }
        return this.applyInstantiation(true, (Map<String, JSType>)typeMap);
    }

    public FunctionType instantiateGenerics(Map<String, JSType> typeMap) {
        for (String typeParam : typeMap.keySet()) {
            Preconditions.checkState((boolean)this.typeParameters.contains((Object)typeParam));
        }
        return this.applyInstantiation(false, typeMap);
    }

    public FunctionType instantiateGenericsFromArgumentTypes(List<JSType> argTypes) {
        if (argTypes.size() < this.getMinArity() || argTypes.size() > this.getMaxArity()) {
            return null;
        }
        HashMultimap typeMultimap = HashMultimap.create();
        int size = argTypes.size();
        for (int i = 0; i < size; ++i) {
            if (this.getFormalType(i).unifyWith(argTypes.get(i), (List<String>)this.typeParameters, (Multimap<String, JSType>)typeMultimap)) continue;
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : this.typeParameters) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() != 1) {
                return null;
            }
            builder.put((Object)typeParam, Iterables.getOnlyElement((Iterable)types));
        }
        return this.applyInstantiation(false, (Map<String, JSType>)builder.build());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Preconditions.checkArgument((boolean)(obj instanceof FunctionType), (String)"obj is: %s", (Object[])new Object[]{obj});
        FunctionType f2 = (FunctionType)obj;
        return Objects.equals(this.requiredFormals, f2.requiredFormals) && Objects.equals(this.optionalFormals, f2.optionalFormals) && Objects.equals(this.restFormals, f2.restFormals) && Objects.equals(this.returnType, f2.returnType) && Objects.equals(this.nominalType, f2.nominalType) && Objects.equals(this.receiverType, f2.receiverType);
    }

    public int hashCode() {
        return Objects.hash(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (this == LOOSE_TOP_FUNCTION) {
            return builder.append("LOOSE_TOP_FUNCTION");
        }
        if (this == TOP_FUNCTION) {
            return builder.append("TOP_FUNCTION");
        }
        if (this == QMARK_FUNCTION) {
            return builder.append("QMARK_FUNCTION");
        }
        builder.append("function(");
        if (this.nominalType != null) {
            builder.append("new:");
            builder.append(this.nominalType);
            builder.append(',');
        } else if (this.receiverType != null) {
            builder.append("this:");
            builder.append(this.receiverType);
            builder.append(',');
        }
        for (i = 0; i < this.requiredFormals.size(); ++i) {
            ((JSType)this.requiredFormals.get(i)).appendTo(builder);
            builder.append(',');
        }
        for (i = 0; i < this.optionalFormals.size(); ++i) {
            ((JSType)this.optionalFormals.get(i)).appendTo(builder);
            builder.append("=,");
        }
        if (this.restFormals != null) {
            builder.append("...");
            this.restFormals.appendTo(builder);
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(')');
        if (this.returnType != null) {
            builder.append(':');
            this.returnType.appendTo(builder);
        }
        if (this.isLoose()) {
            builder.append(" (loose)");
        }
        return builder;
    }
}

