/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MaskType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.NullableObjsType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.ObjsType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeWithPropertiesStatics;
import com.google.javascript.jscomp.newtypes.UnionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public abstract class JSType {
    protected static final int BOTTOM_MASK = 0;
    protected static final int TYPEVAR_MASK = 1;
    protected static final int NON_SCALAR_MASK = 2;
    protected static final int ENUM_MASK = 4;
    protected static final int TRUE_MASK = 8;
    protected static final int FALSE_MASK = 16;
    protected static final int NULL_MASK = 32;
    protected static final int NUMBER_MASK = 64;
    protected static final int STRING_MASK = 128;
    protected static final int UNDEFINED_MASK = 256;
    protected static final int END_MASK = 512;
    protected static final int TRUTHY_MASK = 512;
    protected static final int FALSY_MASK = 1024;
    protected static final int UNKNOWN_MASK = Integer.MAX_VALUE;
    protected static final int TOP_MASK = -1;
    protected static final int BOOLEAN_MASK = 24;
    protected static final int TOP_SCALAR_MASK = 504;
    public static boolean mockToString = false;
    public static final JSType BOOLEAN = new MaskType(24);
    public static final JSType BOTTOM = new MaskType(0);
    public static final JSType FALSE_TYPE = new MaskType(16);
    public static final JSType FALSY = new MaskType(1024);
    public static final JSType NULL = new MaskType(32);
    public static final JSType NUMBER = new MaskType(64);
    public static final JSType STRING = new MaskType(128);
    public static final JSType TOP = new MaskType(-1);
    public static final JSType TOP_SCALAR = JSType.makeType(504);
    public static final JSType TRUE_TYPE = new MaskType(8);
    public static final JSType TRUTHY = new MaskType(512);
    public static final JSType UNDEFINED = new MaskType(256);
    public static final JSType UNKNOWN = new MaskType(Integer.MAX_VALUE);
    public static final JSType TOP_OBJECT = JSType.fromObjectType(ObjectType.TOP_OBJECT);
    public static final JSType TOP_STRUCT = JSType.fromObjectType(ObjectType.TOP_STRUCT);
    public static final JSType TOP_DICT = JSType.fromObjectType(ObjectType.TOP_DICT);
    public static final JSType NULL_OR_UNDEF = new MaskType(288);
    public static final JSType NUM_OR_STR = new MaskType(192);
    private static final JSType ALMOST_TOP = JSType.makeType(506, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT), null, null);
    private static final Joiner PIPE_JOINER = Joiner.on((String)"|");

    private static JSType makeType(int mask, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
        if (enums != null) {
            mask = enums.isEmpty() ? (mask &= 0xFFFFFFFB) : (mask |= 4);
        }
        if (objs != null) {
            mask = objs.isEmpty() ? (mask &= 0xFFFFFFFD) : (mask |= 2);
        }
        if (objs == null && typeVar == null && enums == null) {
            return MaskType.make(mask);
        }
        if (!JSType.isInhabitable(objs)) {
            return BOTTOM;
        }
        if (mask == 2) {
            return new ObjsType(objs);
        }
        if (mask == 34) {
            return new NullableObjsType(objs);
        }
        return new UnionType(mask, objs, typeVar, enums);
    }

    private static JSType makeType(int mask) {
        return JSType.makeType(mask, null, null, null);
    }

    protected abstract int getMask();

    abstract ImmutableSet<ObjectType> getObjs();

    protected abstract String getTypeVar();

    protected abstract ImmutableSet<EnumType> getEnums();

    static JSType fromFunctionType(FunctionType fn, NominalType fnNominal) {
        return JSType.makeType(2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.fromFunction(fn, fnNominal)), null, null);
    }

    public static JSType fromObjectType(ObjectType obj) {
        return JSType.makeType(2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)obj), null, null);
    }

    public static JSType fromTypeVar(String template) {
        return JSType.makeType(1, null, template, null);
    }

    static JSType fromEnum(EnumType e) {
        return JSType.makeType(4, null, null, (ImmutableSet<EnumType>)ImmutableSet.of((Object)e));
    }

    boolean isValidType() {
        if (this.isUnknown() || this.isTop()) {
            return true;
        }
        if ((this.getMask() & 2) != 0 && (this.getObjs() == null || this.getObjs().isEmpty())) {
            return false;
        }
        if ((this.getMask() & 2) == 0 && this.getObjs() != null) {
            return false;
        }
        if ((this.getMask() & 4) != 0 && (this.getEnums() == null || this.getEnums().isEmpty())) {
            return false;
        }
        if ((this.getMask() & 4) == 0 && this.getEnums() != null) {
            return false;
        }
        return (this.getMask() & 1) != 0 == (this.getTypeVar() != null);
    }

    public boolean isTop() {
        return -1 == this.getMask();
    }

    public boolean isBottom() {
        return 0 == this.getMask();
    }

    public boolean isUnknown() {
        return Integer.MAX_VALUE == this.getMask();
    }

    public boolean isTruthy() {
        return 512 == this.getMask() || 8 == this.getMask();
    }

    public boolean isFalsy() {
        return 1024 == this.getMask() || 16 == this.getMask();
    }

    public boolean isBoolean() {
        return (this.getMask() & 0xFFFFFFE7) == 0 && (this.getMask() & 0x18) != 0;
    }

    public boolean isNullOrUndef() {
        int nullUndefMask = 288;
        return this.getMask() != 0 && (this.getMask() | nullUndefMask) == nullUndefMask;
    }

    public boolean isScalar() {
        return this.getMask() == 64 || this.getMask() == 128 || this.getMask() == 32 || this.getMask() == 256 || this.isBoolean();
    }

    private static boolean isInhabitable(Set<ObjectType> objs) {
        if (objs == null) {
            return true;
        }
        for (ObjectType obj : objs) {
            if (obj.isInhabitable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonScalar() {
        return this.getObjs() != null || EnumType.hasNonScalar(this.getEnums());
    }

    public boolean isNullable() {
        return (this.getMask() & 0x20) != 0;
    }

    boolean isTypeVariable() {
        return (this.getMask() & 1) != 0 && (this.getMask() & 0xFFFFFFFE) == 0;
    }

    public boolean isStruct() {
        if (this.getObjs() == null) {
            return false;
        }
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isStruct()) continue;
            return true;
        }
        return false;
    }

    public boolean isLooseStruct() {
        if (this.getObjs() == null) {
            return false;
        }
        boolean foundLooseStruct = false;
        boolean foundNonLooseStruct = false;
        for (ObjectType objType : this.getObjs()) {
            if (objType.isLooseStruct()) {
                foundLooseStruct = true;
                continue;
            }
            if (!objType.isStruct()) continue;
            foundNonLooseStruct = true;
        }
        return foundLooseStruct && !foundNonLooseStruct;
    }

    public boolean isLoose() {
        ImmutableSet<ObjectType> objs = this.getObjs();
        return objs != null && objs.size() == 1 && ((ObjectType)Iterables.getOnlyElement(objs)).isLoose();
    }

    public boolean isDict() {
        if (this.getObjs() == null) {
            return false;
        }
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isDict()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnumElement() {
        return this.getMask() == 4 && this.getEnums().size() == 1;
    }

    public boolean isUnion() {
        if (this.isBottom() || this.isTop() || this.isUnknown() || this.isScalar() || this.isTypeVariable() || this.isEnumElement()) {
            return false;
        }
        return this.getMask() != 2 || this.getObjs().size() != 1;
    }

    public static boolean areCompatibleScalarTypes(JSType lhs, JSType rhs) {
        Preconditions.checkArgument((lhs.isSubtypeOf(TOP_SCALAR) || rhs.isSubtypeOf(TOP_SCALAR) ? 1 : 0) != 0);
        return lhs.isBottom() || rhs.isBottom() || lhs.isUnknown() || rhs.isUnknown() || lhs.isBoolean() && rhs.isBoolean() || lhs.equals(rhs);
    }

    public JSType getEnumeratedType() {
        return this.isEnumElement() ? ((EnumType)Iterables.getOnlyElement(this.getEnums())).getEnumeratedType() : null;
    }

    public JSType autobox(JSTypes commonTypes) {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        int mask = this.getMask();
        if ((mask & 0xD8) == 0) {
            return this;
        }
        switch (mask) {
            case 64: {
                return commonTypes.getNumberInstance();
            }
            case 8: 
            case 16: 
            case 24: {
                return commonTypes.getBooleanInstance();
            }
            case 128: {
                return commonTypes.getStringInstance();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.getObjs() != null) {
            builder.addAll(this.getObjs());
        }
        if ((mask & 0x40) != 0) {
            builder.add((Object)commonTypes.getNumberInstanceObjType());
        }
        if ((mask & 0x80) != 0) {
            builder.add((Object)commonTypes.getStringInstanceObjType());
        }
        if ((mask & 0x18) != 0) {
            builder.add((Object)commonTypes.getBooleanInstanceObjType());
        }
        return JSType.makeType(mask & 0xFFFFFF27, (ImmutableSet<ObjectType>)builder.build(), this.getTypeVar(), this.getEnums());
    }

    static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    public static JSType join(JSType lhs, JSType rhs) {
        if (lhs.isTop() || rhs.isTop()) {
            return TOP;
        }
        if (lhs.isUnknown() || rhs.isUnknown()) {
            return UNKNOWN;
        }
        if (lhs.isBottom()) {
            return rhs;
        }
        if (rhs.isBottom()) {
            return lhs;
        }
        if (lhs.getTypeVar() != null && rhs.getTypeVar() != null && !lhs.getTypeVar().equals(rhs.getTypeVar())) {
            return UNKNOWN;
        }
        int newMask = lhs.getMask() | rhs.getMask();
        ImmutableSet<ObjectType> newObjs = ObjectType.joinSets(lhs.getObjs(), rhs.getObjs());
        String newTypevar = lhs.getTypeVar() != null ? lhs.getTypeVar() : rhs.getTypeVar();
        ImmutableSet<EnumType> newEnums = EnumType.union(lhs.getEnums(), rhs.getEnums());
        if (newEnums == null) {
            return JSType.makeType(newMask, newObjs, newTypevar, null);
        }
        JSType tmpJoin = JSType.makeType(newMask & 0xFFFFFFFB, newObjs, newTypevar, null);
        return JSType.makeType(newMask, newObjs, newTypevar, EnumType.normalizeForJoin(newEnums, tmpJoin));
    }

    public JSType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (this.isTop() || this.isUnknown() || this.getObjs() == null && this.getTypeVar() == null || concreteTypes.isEmpty()) {
            return this;
        }
        ImmutableSet newObjs = null;
        if (this.getObjs() != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ObjectType obj : this.getObjs()) {
                builder.add((Object)obj.substituteGenerics(concreteTypes));
            }
            newObjs = builder.build();
        }
        JSType current = JSType.makeType(this.getMask() & 0xFFFFFFFE, newObjs, null, this.getEnums());
        if ((this.getMask() & 1) != 0) {
            current = JSType.join(current, concreteTypes.containsKey(this.getTypeVar()) ? concreteTypes.get(this.getTypeVar()) : JSType.fromTypeVar(this.getTypeVar()));
        }
        return current;
    }

    private static void updateTypemap(Multimap<String, JSType> typeMultimap, String typeParam, JSType type) {
        HashSet<JSType> typesToRemove = new HashSet<JSType>();
        for (JSType other : typeMultimap.get((Object)typeParam)) {
            JSType unified = JSType.unifyUnknowns(type, other);
            if (unified == null) continue;
            typesToRemove.add(other);
            type = unified;
        }
        for (JSType typeToRemove : typesToRemove) {
            typeMultimap.remove((Object)typeParam, (Object)typeToRemove);
        }
        typeMultimap.put((Object)typeParam, (Object)type);
    }

    private static int promoteBoolean(int mask) {
        if ((mask & 0x18) != 0) {
            return mask | 8 | 0x10;
        }
        return mask;
    }

    static JSType unifyUnknowns(JSType t1, JSType t2) {
        if (t1.isUnknown()) {
            return t2;
        }
        if (t2.isUnknown()) {
            return t1;
        }
        if (t1.isTop() && t2.isTop()) {
            return TOP;
        }
        if (t1.isTop() || t2.isTop()) {
            return null;
        }
        ImmutableSet<EnumType> newEnums = null;
        if (t1.getEnums() == null) {
            if (t2.getEnums() != null) {
                return null;
            }
            newEnums = null;
        } else {
            if (t2.getEnums() == null) {
                return null;
            }
            if (!t1.getEnums().equals(t2.getEnums())) {
                return null;
            }
            newEnums = t1.getEnums();
        }
        int t1Mask = JSType.promoteBoolean(t1.getMask());
        int t2Mask = JSType.promoteBoolean(t2.getMask());
        if (t1Mask != t2Mask || !Objects.equals(t1.getTypeVar(), t2.getTypeVar())) {
            return null;
        }
        if ((t1Mask & 2) == 0) {
            return t1;
        }
        if (t1.getObjs().size() != t2.getObjs().size()) {
            return null;
        }
        HashSet<ObjectType> ununified = new HashSet<ObjectType>((Collection<ObjectType>)t2.getObjs());
        HashSet<ObjectType> unifiedObjs = new HashSet<ObjectType>();
        Iterator i$ = t1.getObjs().iterator();
        while (i$.hasNext()) {
            ObjectType objType1;
            ObjectType unified = objType1 = (ObjectType)i$.next();
            boolean hasUnified = false;
            for (ObjectType objType2 : t2.getObjs()) {
                ObjectType tmp = ObjectType.unifyUnknowns(unified, objType2);
                if (tmp == null) continue;
                hasUnified = true;
                ununified.remove(objType2);
                unified = tmp;
            }
            if (!hasUnified) {
                return null;
            }
            unifiedObjs.add(unified);
        }
        if (!ununified.isEmpty()) {
            return null;
        }
        return JSType.makeType(t1Mask, (ImmutableSet<ObjectType>)ImmutableSet.copyOf(unifiedObjs), t1.getTypeVar(), newEnums);
    }

    public boolean unifyWith(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        if (this.isUnknown()) {
            return true;
        }
        if (this.isTop()) {
            return other.isTop();
        }
        if (this.getMask() == 1 && typeParameters.contains(this.getTypeVar())) {
            JSType.updateTypemap(typeMultimap, this.getTypeVar(), JSType.makeType(JSType.promoteBoolean(other.getMask()), other.getObjs(), other.getTypeVar(), other.getEnums()));
            return true;
        }
        if (other.isTop()) {
            return false;
        }
        if (other.isUnknown()) {
            return true;
        }
        Object ununifiedEnums = null;
        if (this.getEnums() == null) {
            ununifiedEnums = other.getEnums();
        } else {
            if (other.getEnums() == null) {
                return false;
            }
            ununifiedEnums = new HashSet();
            for (EnumType e : this.getEnums()) {
                if (other.getEnums().contains((Object)e)) continue;
                return false;
            }
            for (EnumType e : other.getEnums()) {
                if (this.getEnums().contains((Object)e)) continue;
                ununifiedEnums.add(e);
            }
            if (ununifiedEnums.isEmpty()) {
                ununifiedEnums = null;
            }
        }
        Object ununified = ImmutableSet.of();
        if (other.getObjs() != null) {
            ununified = new HashSet<ObjectType>((Collection<ObjectType>)other.getObjs());
        }
        if (this.getObjs() != null) {
            if (other.getObjs() == null) {
                return false;
            }
            for (ObjectType targetObj : this.getObjs()) {
                boolean hasUnified = false;
                for (ObjectType sourceObj : other.getObjs()) {
                    if (!targetObj.unifyWith(sourceObj, typeParameters, typeMultimap)) continue;
                    ununified.remove(sourceObj);
                    hasUnified = true;
                }
                if (hasUnified) continue;
                return false;
            }
        }
        String thisTypevar = this.getTypeVar();
        String otherTypevar = other.getTypeVar();
        if (thisTypevar == null) {
            return otherTypevar == null && this.getMask() == other.getMask();
        }
        if (!typeParameters.contains(thisTypevar)) {
            return thisTypevar.equals(otherTypevar) && this.getMask() == other.getMask();
        }
        int templateMask = 0;
        int thisScalarBits = this.getMask() & 0xFFFFFFFD & 0xFFFFFFFE;
        int otherScalarBits = other.getMask() & 0xFFFFFFFD;
        if ((templateMask |= otherScalarBits & ~thisScalarBits) == 0) {
            return false;
        }
        JSType templateType = JSType.makeType(JSType.promoteBoolean(templateMask), (ImmutableSet<ObjectType>)ImmutableSet.copyOf((Collection)ununified), otherTypevar, (ImmutableSet<EnumType>)(ununifiedEnums == null ? null : ImmutableSet.copyOf((Collection)ununifiedEnums)));
        JSType.updateTypemap(typeMultimap, this.getTypeVar(), templateType);
        return true;
    }

    public JSType specialize(JSType other) {
        String newTypevar;
        if (other.isTop() || other.isUnknown() || this == other) {
            return this;
        }
        if (other.isTruthy()) {
            return this.makeTruthy();
        }
        if (other.isFalsy()) {
            return this.makeFalsy();
        }
        if (this.isTop() || this.isUnknown()) {
            return other;
        }
        int newMask = this.getMask() & other.getMask();
        if (Objects.equals(this.getTypeVar(), other.getTypeVar())) {
            newTypevar = this.getTypeVar();
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(newMask, this.getMask() | other.getMask(), ObjectType.specializeSet(this.getObjs(), other.getObjs()), newTypevar, this.getObjs(), other.getObjs(), this.getEnums(), other.getEnums());
    }

    public static JSType meet(JSType lhs, JSType rhs) {
        String newTypevar;
        if (lhs.isTop()) {
            return rhs;
        }
        if (rhs.isTop()) {
            return lhs;
        }
        if (lhs.isUnknown()) {
            return rhs;
        }
        if (rhs.isUnknown()) {
            return lhs;
        }
        int newMask = lhs.getMask() & rhs.getMask();
        if (Objects.equals(lhs.getTypeVar(), rhs.getTypeVar())) {
            newTypevar = lhs.getTypeVar();
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(newMask, lhs.getMask() | rhs.getMask(), ObjectType.meetSets(lhs.getObjs(), rhs.getObjs()), newTypevar, lhs.getObjs(), rhs.getObjs(), lhs.getEnums(), rhs.getEnums());
    }

    private static JSType meetEnums(int newMask, int unionMask, ImmutableSet<ObjectType> newObjs, String newTypevar, ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2, ImmutableSet<EnumType> enums1, ImmutableSet<EnumType> enums2) {
        if (Objects.equals(enums1, enums2)) {
            return JSType.makeType(newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, enums1);
        }
        ImmutableSet.Builder enumBuilder = ImmutableSet.builder();
        ImmutableSet<EnumType> allEnums = EnumType.union(enums1, enums2);
        for (EnumType e : allEnums) {
            if (enums1 != null && enums1.contains((Object)e) && enums2 != null && enums2.contains((Object)e)) {
                enumBuilder.add((Object)e);
                continue;
            }
            JSType enumeratedType = e.getEnumeratedType();
            if (enumeratedType.isUnknown()) {
                enumBuilder.add((Object)e);
                continue;
            }
            if (enumeratedType.getMask() != 2) {
                if ((enumeratedType.getMask() & unionMask) == 0) continue;
                enumBuilder.add((Object)e);
                newMask &= ~enumeratedType.getMask();
                continue;
            }
            if (objs1 == null && objs2 == null) continue;
            HashSet<ObjectType> objsToRemove = new HashSet<ObjectType>();
            ObjectType enumObj = (ObjectType)Iterables.getOnlyElement(enumeratedType.getObjs());
            if (objs1 != null) {
                for (ObjectType obj1 : objs1) {
                    if (!enumObj.isSubtypeOf(obj1)) continue;
                    enumBuilder.add((Object)e);
                    objsToRemove.add(obj1);
                }
            }
            if (objs2 != null) {
                for (ObjectType obj2 : objs2) {
                    if (!enumObj.isSubtypeOf(obj2)) continue;
                    enumBuilder.add((Object)e);
                    objsToRemove.add(obj2);
                }
            }
            if (objsToRemove.isEmpty() || newObjs == null) continue;
            newObjs = Sets.difference((Set)newObjs, objsToRemove).immutableCopy();
        }
        return JSType.makeType(newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, (ImmutableSet<EnumType>)enumBuilder.build());
    }

    private JSType makeTruthy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return JSType.makeType(this.getMask() & 0xFFFFFFDF & 0xFFFFFFEF & 0xFFFFFEFF, this.getObjs(), this.getTypeVar(), this.getEnums());
    }

    private JSType makeFalsy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return JSType.makeType(this.getMask() & 0xFFFFFFF7 & 0xFFFFFFFD, null, this.getTypeVar(), this.getEnums());
    }

    public static JSType plus(JSType lhs, JSType rhs) {
        int newtype = (lhs.getMask() | rhs.getMask()) & 0x80;
        if ((lhs.getMask() & 0xFFFFFF7F) != 0 && (rhs.getMask() & 0xFFFFFF7F) != 0) {
            newtype |= 0x40;
        }
        return JSType.makeType(newtype);
    }

    public JSType negate() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        if (this.isTruthy()) {
            return FALSY;
        }
        if (this.isFalsy()) {
            return TRUTHY;
        }
        return UNKNOWN;
    }

    public JSType toBoolean() {
        if (this.isTruthy()) {
            return TRUE_TYPE;
        }
        if (this.isFalsy()) {
            return FALSE_TYPE;
        }
        return BOOLEAN;
    }

    public boolean isNonLooseSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(false, other);
    }

    public boolean isSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(true, other);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, JSType other) {
        if (this.isUnknown() || other.isUnknown() || other.isTop()) {
            return true;
        }
        if (!EnumType.areSubtypes(this, other)) {
            return false;
        }
        int mask = this.getMask() & 0xFFFFFFFB;
        if ((mask | other.getMask()) != other.getMask()) {
            return false;
        }
        if (!Objects.equals(this.getTypeVar(), other.getTypeVar())) {
            return false;
        }
        if (this.getObjs() == null) {
            return true;
        }
        return ObjectType.isUnionSubtype(keepLoosenessOfThis, this.getObjs(), other.getObjs());
    }

    public JSType removeType(JSType other) {
        ImmutableSet.Builder builder;
        int otherMask = other.getMask();
        Preconditions.checkState((!other.isTop() && !other.isUnknown() && (otherMask & 1) == 0 && (otherMask & 4) == 0 ? 1 : 0) != 0);
        if (this.isUnknown()) {
            return this;
        }
        if (this.isTop()) {
            return ALMOST_TOP.removeType(other);
        }
        int newMask = this.getMask() & ~otherMask;
        if ((otherMask & 2) == 0) {
            return JSType.makeType(newMask, this.getObjs(), this.getTypeVar(), this.getEnums());
        }
        Preconditions.checkState((other.getObjs().size() == 1 ? 1 : 0) != 0, (String)"Invalid type to remove: %s", (Object[])new Object[]{other});
        ObjectType otherObj = (ObjectType)Iterables.getOnlyElement(other.getObjs());
        ImmutableSet newObjs = null;
        ImmutableSet newEnums = null;
        if (this.getObjs() != null) {
            builder = ImmutableSet.builder();
            for (ObjectType obj : this.getObjs()) {
                if (obj.isSubtypeOf(otherObj)) continue;
                builder.add((Object)obj);
            }
            newObjs = builder.build();
        }
        if (this.getEnums() != null) {
            builder = ImmutableSet.builder();
            for (EnumType e : this.getEnums()) {
                if (e.getEnumeratedType().isSubtypeOf(other)) continue;
                builder.add((Object)e);
            }
            newEnums = builder.build();
        }
        return JSType.makeType(newMask, newObjs, this.getTypeVar(), newEnums);
    }

    public FunctionType getFunTypeIfSingletonObj() {
        if (this.getMask() != 2 || this.getObjs().size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getFunType();
    }

    public FunctionType getFunType() {
        if (this.getObjs() == null) {
            return null;
        }
        if (this.getObjs().size() == 1) {
            return ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getFunType();
        }
        FunctionType result = FunctionType.TOP_FUNCTION;
        for (ObjectType obj : this.getObjs()) {
            result = FunctionType.meet(result, obj.getFunType());
        }
        return result;
    }

    NominalType getNominalTypeIfUnique() {
        if (this.getObjs() == null || this.getObjs().size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getNominalType();
    }

    public boolean isInterfaceDefinition() {
        if (this.getObjs() == null || this.getObjs().size() > 1) {
            return false;
        }
        FunctionType ft = ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getFunType();
        return ft != null && ft.isInterfaceDefinition();
    }

    public JSType withLoose() {
        if (this.getObjs() == null) {
            Preconditions.checkState((this.getEnums() != null ? 1 : 0) != 0);
            return this;
        }
        return JSType.makeType(this.getMask(), ObjectType.withLooseObjects(this.getObjs()), this.getTypeVar(), this.getEnums());
    }

    public JSType getProp(QualifiedName qname) {
        if (this.isBottom() || this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.getObjs() != null || this.getEnums() != null ? 1 : 0) != 0, (String)"Can't getProp of type %s", (Object[])new Object[]{this});
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getProp(this.getObjs(), qname), TypeWithPropertiesStatics.getProp(this.getEnums(), qname));
    }

    public JSType getDeclaredProp(QualifiedName qname) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.getObjs() != null || this.getEnums() != null ? 1 : 0) != 0);
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getDeclaredProp(this.getObjs(), qname), TypeWithPropertiesStatics.getDeclaredProp(this.getEnums(), qname));
    }

    public boolean mayHaveProp(QualifiedName qname) {
        return TypeWithPropertiesStatics.mayHaveProp(this.getObjs(), qname) || TypeWithPropertiesStatics.mayHaveProp(this.getEnums(), qname);
    }

    public boolean hasProp(QualifiedName qname) {
        if (this.getObjs() != null && !TypeWithPropertiesStatics.hasProp(this.getObjs(), qname)) {
            return false;
        }
        if (this.getEnums() != null && !TypeWithPropertiesStatics.hasProp(this.getEnums(), qname)) {
            return false;
        }
        return this.getEnums() != null || this.getObjs() != null;
    }

    public boolean hasConstantProp(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return TypeWithPropertiesStatics.hasConstantProp(this.getObjs(), pname) || TypeWithPropertiesStatics.hasConstantProp(this.getEnums(), pname);
    }

    public JSType withoutProperty(QualifiedName qname) {
        return this.getObjs() == null ? this : JSType.makeType(this.getMask(), ObjectType.withoutProperty(this.getObjs(), qname), this.getTypeVar(), this.getEnums());
    }

    public JSType withProperty(QualifiedName qname, JSType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (this.isUnknown() || this.isBottom() || this.getObjs() == null) {
            return this;
        }
        return JSType.makeType(this.getMask(), ObjectType.withProperty(this.getObjs(), qname, type), this.getTypeVar(), this.getEnums());
    }

    public JSType withDeclaredProperty(QualifiedName qname, JSType type, boolean isConstant) {
        Preconditions.checkState((this.getObjs() != null ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = UNKNOWN;
        }
        return JSType.makeType(this.getMask(), ObjectType.withDeclaredProperty(this.getObjs(), qname, type, isConstant), this.getTypeVar(), this.getEnums());
    }

    public JSType withPropertyRequired(String pname) {
        return this.isUnknown() || this.getObjs() == null ? this : JSType.makeType(this.getMask(), ObjectType.withPropertyRequired(this.getObjs(), pname), this.getTypeVar(), this.getEnums());
    }

    public String toString() {
        if (mockToString) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.typeToString(builder);
    }

    private StringBuilder typeToString(StringBuilder builder) {
        switch (this.getMask()) {
            case 0: {
                return builder.append("bottom");
            }
            case -1: {
                return builder.append("*");
            }
            case 0x7FFFFFFF: {
                return builder.append("?");
            }
        }
        int tags = this.getMask();
        boolean firstIteration = true;
        block15: for (int tag = 1; tag != 512; tag <<= 1) {
            if ((tags & tag) == 0) continue;
            if (!firstIteration) {
                builder.append('|');
            }
            firstIteration = false;
            switch (tag) {
                case 8: 
                case 16: {
                    builder.append("boolean");
                    tags &= 0xFFFFFFE7;
                    continue block15;
                }
                case 32: {
                    builder.append("null");
                    tags &= 0xFFFFFFDF;
                    continue block15;
                }
                case 64: {
                    builder.append("number");
                    tags &= 0xFFFFFFBF;
                    continue block15;
                }
                case 128: {
                    builder.append("string");
                    tags &= 0xFFFFFF7F;
                    continue block15;
                }
                case 256: {
                    builder.append("undefined");
                    tags &= 0xFFFFFEFF;
                    continue block15;
                }
                case 1: {
                    builder.append(this.getTypeVar());
                    tags &= 0xFFFFFFFE;
                    continue block15;
                }
                case 2: {
                    TreeSet<String> strReps;
                    if (this.getObjs().size() == 1) {
                        ((ObjectType)Iterables.getOnlyElement(this.getObjs())).appendTo(builder);
                    } else {
                        strReps = new TreeSet<String>();
                        for (ObjectType obj : this.getObjs()) {
                            strReps.add(obj.toString());
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFD;
                    continue block15;
                }
                case 4: {
                    TreeSet<String> strReps;
                    if (this.getEnums().size() == 1) {
                        builder.append(Iterables.getOnlyElement(this.getEnums()));
                    } else {
                        strReps = new TreeSet();
                        for (EnumType e : this.getEnums()) {
                            strReps.add(e.toString());
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFB;
                    continue block15;
                }
            }
        }
        if (tags == 0) {
            return builder;
        }
        if (tags == 512) {
            return builder.append("truthy");
        }
        if (tags == 1024) {
            return builder.append("falsy");
        }
        return builder.append("Unrecognized type: " + tags);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof JSType));
        JSType t2 = (JSType)o;
        return this.getMask() == t2.getMask() && Objects.equals(this.getObjs(), t2.getObjs());
    }

    public int hashCode() {
        return Objects.hash(this.getMask(), this.getObjs());
    }
}

