/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import java.util.Map;

public class JSTypes {
    private JSType numberInstance;
    private JSType booleanInstance;
    private JSType stringInstance;
    private ObjectType numberInstanceObjtype;
    private ObjectType booleanInstanceObjtype;
    private ObjectType stringInstanceObjtype;
    private JSType numberOrNumber;
    private JSType stringOrString;
    private JSType anyNumOrStr;
    private JSType regexpType;
    private NominalType.RawNominalType arrayType;
    private NominalType.RawNominalType builtinObject;
    private NominalType.RawNominalType builtinFunction;

    private JSTypes() {
    }

    public static JSTypes make() {
        return new JSTypes();
    }

    public JSType fromFunctionType(FunctionType fn) {
        return JSType.fromFunctionType(fn, this.getFunctionType());
    }

    public NominalType getFunctionType() {
        if (this.builtinFunction == null) {
            return null;
        }
        return this.builtinFunction.getAsNominalType();
    }

    public JSType looseTopFunction() {
        return this.topFunction().withLoose();
    }

    public JSType topFunction() {
        return this.fromFunctionType(FunctionType.TOP_FUNCTION);
    }

    JSType qmarkFunction() {
        return this.fromFunctionType(FunctionType.QMARK_FUNCTION);
    }

    public JSType getArrayInstance() {
        return this.getArrayInstance(JSType.UNKNOWN);
    }

    public NominalType getObjectType() {
        if (this.builtinObject == null) {
            return null;
        }
        return this.builtinObject.getAsNominalType();
    }

    public JSType getArrayInstance(JSType t) {
        if (this.arrayType == null) {
            return JSType.UNKNOWN;
        }
        ImmutableList<String> typeParams = this.arrayType.getTypeParameters();
        JSType result = this.arrayType.getInstanceAsJSType();
        if (typeParams.size() == 1) {
            String typeParam = (String)Iterables.getOnlyElement(typeParams);
            result = result.substituteGenerics((Map<String, JSType>)ImmutableMap.of((Object)typeParam, (Object)t));
        }
        return result;
    }

    public JSType getRegexpType() {
        return this.regexpType != null ? this.regexpType : JSType.UNKNOWN;
    }

    JSType getNumberInstance() {
        return this.numberInstance != null ? this.numberInstance : JSType.NUMBER;
    }

    JSType getBooleanInstance() {
        return this.booleanInstance != null ? this.booleanInstance : JSType.BOOLEAN;
    }

    JSType getStringInstance() {
        return this.stringInstance != null ? this.stringInstance : JSType.STRING;
    }

    ObjectType getNumberInstanceObjType() {
        return this.numberInstanceObjtype != null ? this.numberInstanceObjtype : ObjectType.TOP_OBJECT;
    }

    ObjectType getBooleanInstanceObjType() {
        return this.booleanInstanceObjtype != null ? this.booleanInstanceObjtype : ObjectType.TOP_OBJECT;
    }

    ObjectType getStringInstanceObjType() {
        return this.stringInstanceObjtype != null ? this.stringInstanceObjtype : ObjectType.TOP_OBJECT;
    }

    public void setFunctionType(NominalType.RawNominalType builtinFunction) {
        this.builtinFunction = builtinFunction;
    }

    public void setObjectType(NominalType.RawNominalType builtinObject) {
        this.builtinObject = builtinObject;
    }

    public void setArrayType(NominalType.RawNominalType arrayType) {
        this.arrayType = arrayType;
    }

    public void setRegexpInstance(JSType regexpType) {
        this.regexpType = regexpType;
    }

    public void setNumberInstance(JSType t) {
        Preconditions.checkState((this.numberInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.numberInstance = t;
        this.numberOrNumber = JSType.join(JSType.NUMBER, this.numberInstance);
        this.numberInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
        if (this.stringInstance != null) {
            this.anyNumOrStr = JSType.join(this.numberOrNumber, this.stringOrString);
        }
    }

    public void setBooleanInstance(JSType t) {
        Preconditions.checkState((this.booleanInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.booleanInstance = t;
        this.booleanInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
    }

    public void setStringInstance(JSType t) {
        Preconditions.checkState((this.stringInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.stringInstance = t;
        this.stringOrString = JSType.join(JSType.STRING, this.stringInstance);
        this.stringInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
        if (this.numberInstance != null) {
            this.anyNumOrStr = JSType.join(this.numberOrNumber, this.stringOrString);
        }
    }

    public boolean isNumberScalarOrObj(JSType t) {
        if (this.numberOrNumber == null) {
            return t.isSubtypeOf(JSType.NUMBER);
        }
        return t.isSubtypeOf(this.numberOrNumber);
    }

    public boolean isStringScalarOrObj(JSType t) {
        if (this.numberOrNumber == null) {
            return t.isSubtypeOf(JSType.STRING);
        }
        return t.isSubtypeOf(this.stringOrString);
    }

    public boolean isNumStrScalarOrObj(JSType t) {
        if (this.anyNumOrStr == null) {
            return t.isSubtypeOf(JSType.NUM_OR_STR);
        }
        return t.isSubtypeOf(this.anyNumOrStr);
    }
}

