/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.PersistentSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TypeEnv {
    private final PersistentMap<String, JSType> typeMap;
    private static final int SIZE_THRESHOLD = 100;
    private PersistentSet<String> changedVars = null;

    public TypeEnv() {
        this.typeMap = PersistentMap.create();
    }

    private TypeEnv(PersistentMap<String, JSType> typeMap) {
        this.typeMap = typeMap;
        if (typeMap.size() >= 100) {
            this.changedVars = PersistentSet.create();
        }
    }

    private TypeEnv(PersistentMap<String, JSType> typeMap, PersistentSet<String> changedVars) {
        Preconditions.checkState((typeMap.size() >= 100 ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.changedVars = changedVars;
    }

    public JSType getType(String n) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        return (JSType)this.typeMap.get(n);
    }

    public TypeEnv putType(String n, JSType t) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((t != null ? 1 : 0) != 0);
        if (this.changedVars == null) {
            return new TypeEnv(this.typeMap.with(n, t));
        }
        JSType oldType = (JSType)this.typeMap.get(n);
        if (oldType == null) {
            return new TypeEnv(this.typeMap.with(n, t));
        }
        if (t.equals(oldType)) {
            return this;
        }
        return new TypeEnv(this.typeMap.with(n, t), this.changedVars.with(n));
    }

    public TypeEnv clearChangeLog() {
        if (this.changedVars == null || this.changedVars.isEmpty()) {
            return this;
        }
        return new TypeEnv(this.typeMap);
    }

    public static TypeEnv join(TypeEnv e1, TypeEnv e2) {
        return TypeEnv.join((Collection<TypeEnv>)ImmutableSet.of((Object)e1, (Object)e2));
    }

    public static TypeEnv join(Collection<TypeEnv> envs) {
        Preconditions.checkArgument((!envs.isEmpty() ? 1 : 0) != 0);
        Iterator<TypeEnv> envsIter = envs.iterator();
        TypeEnv firstEnv = envsIter.next();
        if (!envsIter.hasNext()) {
            return firstEnv;
        }
        PersistentMap<String, JSType> newMap = firstEnv.typeMap;
        if (firstEnv.changedVars == null) {
            while (envsIter.hasNext()) {
                TypeEnv env = envsIter.next();
                for (Map.Entry entry : env.typeMap.entrySet()) {
                    String name = (String)entry.getKey();
                    JSType currentType = (JSType)newMap.get(name);
                    JSType otherType = (JSType)entry.getValue();
                    Preconditions.checkNotNull((Object)currentType, (String)"%s is missing from an env", (Object[])new Object[]{name});
                    if (currentType.equals(otherType)) continue;
                    newMap = newMap.with(name, JSType.join(currentType, otherType));
                }
            }
            return new TypeEnv(newMap);
        }
        PersistentSet<String> newLog = PersistentSet.create();
        for (TypeEnv env : envs) {
            for (String varName : env.changedVars) {
                newLog = newLog.with(varName);
            }
        }
        while (envsIter.hasNext()) {
            TypeEnv env = envsIter.next();
            for (String changedVar : newLog) {
                JSType otherType;
                JSType currentType = (JSType)newMap.get(changedVar);
                if (currentType.equals(otherType = (JSType)env.typeMap.get(changedVar))) continue;
                newMap = newMap.with(changedVar, JSType.join(currentType, otherType));
            }
        }
        return new TypeEnv(newMap, newLog);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (String key : this.typeMap.keySet()) {
            helper.add(key, (Object)this.getType(key));
        }
        return helper.toString();
    }
}

