/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.trees;

import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;

public class ParseTree {
    public final ParseTreeType type;
    public final SourceRange location;

    protected ParseTree(ParseTreeType type, SourceRange location) {
        this.type = type;
        this.location = location;
    }

    public ArgumentListTree asArgumentList() {
        return (ArgumentListTree)this;
    }

    public ArrayLiteralExpressionTree asArrayLiteralExpression() {
        return (ArrayLiteralExpressionTree)this;
    }

    public ArrayPatternTree asArrayPattern() {
        return (ArrayPatternTree)this;
    }

    public AssignmentRestElementTree asAssignmentRestElement() {
        return (AssignmentRestElementTree)this;
    }

    public BinaryOperatorTree asBinaryOperator() {
        return (BinaryOperatorTree)this;
    }

    public BlockTree asBlock() {
        return (BlockTree)this;
    }

    public BreakStatementTree asBreakStatement() {
        return (BreakStatementTree)this;
    }

    public CallExpressionTree asCallExpression() {
        return (CallExpressionTree)this;
    }

    public CaseClauseTree asCaseClause() {
        return (CaseClauseTree)this;
    }

    public CatchTree asCatch() {
        return (CatchTree)this;
    }

    public ClassDeclarationTree asClassDeclaration() {
        return (ClassDeclarationTree)this;
    }

    public CommaExpressionTree asCommaExpression() {
        return (CommaExpressionTree)this;
    }

    public ComprehensionIfTree asComprehensionIf() {
        return (ComprehensionIfTree)this;
    }

    public ComprehensionForTree asComprehensionFor() {
        return (ComprehensionForTree)this;
    }

    public ComprehensionTree asComprehension() {
        return (ComprehensionTree)this;
    }

    public ComputedPropertyDefinitionTree asComputedPropertyDefinition() {
        return (ComputedPropertyDefinitionTree)this;
    }

    public ComputedPropertyGetterTree asComputedPropertyGetter() {
        return (ComputedPropertyGetterTree)this;
    }

    public ComputedPropertyMethodTree asComputedPropertyMethod() {
        return (ComputedPropertyMethodTree)this;
    }

    public ComputedPropertySetterTree asComputedPropertySetter() {
        return (ComputedPropertySetterTree)this;
    }

    public ConditionalExpressionTree asConditionalExpression() {
        return (ConditionalExpressionTree)this;
    }

    public ContinueStatementTree asContinueStatement() {
        return (ContinueStatementTree)this;
    }

    public DebuggerStatementTree asDebuggerStatement() {
        return (DebuggerStatementTree)this;
    }

    public DefaultClauseTree asDefaultClause() {
        return (DefaultClauseTree)this;
    }

    public DefaultParameterTree asDefaultParameter() {
        return (DefaultParameterTree)this;
    }

    public DoWhileStatementTree asDoWhileStatement() {
        return (DoWhileStatementTree)this;
    }

    public EmptyStatementTree asEmptyStatement() {
        return (EmptyStatementTree)this;
    }

    public ExportDeclarationTree asExportDeclaration() {
        return (ExportDeclarationTree)this;
    }

    public ExportSpecifierTree asExportSpecifier() {
        return (ExportSpecifierTree)this;
    }

    public ExpressionStatementTree asExpressionStatement() {
        return (ExpressionStatementTree)this;
    }

    public FinallyTree asFinally() {
        return (FinallyTree)this;
    }

    public ForOfStatementTree asForOfStatement() {
        return (ForOfStatementTree)this;
    }

    public ForInStatementTree asForInStatement() {
        return (ForInStatementTree)this;
    }

    public FormalParameterListTree asFormalParameterList() {
        return (FormalParameterListTree)this;
    }

    public ForStatementTree asForStatement() {
        return (ForStatementTree)this;
    }

    public FunctionDeclarationTree asFunctionDeclaration() {
        return (FunctionDeclarationTree)this;
    }

    public GetAccessorTree asGetAccessor() {
        return (GetAccessorTree)this;
    }

    public IdentifierExpressionTree asIdentifierExpression() {
        return (IdentifierExpressionTree)this;
    }

    public IfStatementTree asIfStatement() {
        return (IfStatementTree)this;
    }

    public ImportDeclarationTree asImportDeclaration() {
        return (ImportDeclarationTree)this;
    }

    public ImportSpecifierTree asImportSpecifier() {
        return (ImportSpecifierTree)this;
    }

    public LabelledStatementTree asLabelledStatement() {
        return (LabelledStatementTree)this;
    }

    public LiteralExpressionTree asLiteralExpression() {
        return (LiteralExpressionTree)this;
    }

    public MemberExpressionTree asMemberExpression() {
        return (MemberExpressionTree)this;
    }

    public MemberLookupExpressionTree asMemberLookupExpression() {
        return (MemberLookupExpressionTree)this;
    }

    public MissingPrimaryExpressionTree asMissingPrimaryExpression() {
        return (MissingPrimaryExpressionTree)this;
    }

    public ModuleImportTree asModuleImport() {
        return (ModuleImportTree)this;
    }

    public NewExpressionTree asNewExpression() {
        return (NewExpressionTree)this;
    }

    public NullTree asNull() {
        return (NullTree)this;
    }

    public ObjectLiteralExpressionTree asObjectLiteralExpression() {
        return (ObjectLiteralExpressionTree)this;
    }

    public ObjectPatternTree asObjectPattern() {
        return (ObjectPatternTree)this;
    }

    public ParenExpressionTree asParenExpression() {
        return (ParenExpressionTree)this;
    }

    public PostfixExpressionTree asPostfixExpression() {
        return (PostfixExpressionTree)this;
    }

    public ProgramTree asProgram() {
        return (ProgramTree)this;
    }

    public PropertyNameAssignmentTree asPropertyNameAssignment() {
        return (PropertyNameAssignmentTree)this;
    }

    public RestParameterTree asRestParameter() {
        return (RestParameterTree)this;
    }

    public ReturnStatementTree asReturnStatement() {
        return (ReturnStatementTree)this;
    }

    public SetAccessorTree asSetAccessor() {
        return (SetAccessorTree)this;
    }

    public SpreadExpressionTree asSpreadExpression() {
        return (SpreadExpressionTree)this;
    }

    public SuperExpressionTree asSuperExpression() {
        return (SuperExpressionTree)this;
    }

    public SwitchStatementTree asSwitchStatement() {
        return (SwitchStatementTree)this;
    }

    public TemplateLiteralExpressionTree asTemplateLiteralExpression() {
        return (TemplateLiteralExpressionTree)this;
    }

    public TemplateLiteralPortionTree asTemplateLiteralPortion() {
        return (TemplateLiteralPortionTree)this;
    }

    public TemplateSubstitutionTree asTemplateSubstitution() {
        return (TemplateSubstitutionTree)this;
    }

    public ThisExpressionTree asThisExpression() {
        return (ThisExpressionTree)this;
    }

    public ThrowStatementTree asThrowStatement() {
        return (ThrowStatementTree)this;
    }

    public TryStatementTree asTryStatement() {
        return (TryStatementTree)this;
    }

    public UnaryExpressionTree asUnaryExpression() {
        return (UnaryExpressionTree)this;
    }

    public VariableDeclarationListTree asVariableDeclarationList() {
        return (VariableDeclarationListTree)this;
    }

    public VariableDeclarationTree asVariableDeclaration() {
        return (VariableDeclarationTree)this;
    }

    public VariableStatementTree asVariableStatement() {
        return (VariableStatementTree)this;
    }

    public WhileStatementTree asWhileStatement() {
        return (WhileStatementTree)this;
    }

    public WithStatementTree asWithStatement() {
        return (WithStatementTree)this;
    }

    public YieldExpressionTree asYieldStatement() {
        return (YieldExpressionTree)this;
    }

    public final boolean isNull() {
        return this.type == ParseTreeType.NULL;
    }

    public boolean isPattern() {
        ParseTree parseTree = this;
        while (parseTree.type == ParseTreeType.PAREN_EXPRESSION) {
            parseTree = parseTree.asParenExpression().expression;
        }
        switch (parseTree.type) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return true;
            }
        }
        return false;
    }

    public boolean isLeftHandSideExpression() {
        ParseTree parseTree = this;
        while (parseTree.type == ParseTreeType.PAREN_EXPRESSION) {
            parseTree = parseTree.asParenExpression().expression;
        }
        switch (parseTree.type) {
            case THIS_EXPRESSION: 
            case SUPER_EXPRESSION: 
            case IDENTIFIER_EXPRESSION: 
            case LITERAL_EXPRESSION: 
            case ARRAY_LITERAL_EXPRESSION: 
            case OBJECT_LITERAL_EXPRESSION: 
            case NEW_EXPRESSION: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case CALL_EXPRESSION: 
            case FUNCTION_DECLARATION: 
            case TEMPLATE_LITERAL_EXPRESSION: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidAssignmentTarget() {
        ParseTree parseTree = this;
        while (parseTree.type == ParseTreeType.PAREN_EXPRESSION) {
            parseTree = parseTree.asParenExpression().expression;
        }
        switch (parseTree.type) {
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: 
            case IDENTIFIER_EXPRESSION: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case DEFAULT_PARAMETER: {
                return true;
            }
        }
        return false;
    }

    public boolean isAssignmentExpression() {
        switch (this.type) {
            case THIS_EXPRESSION: 
            case SUPER_EXPRESSION: 
            case IDENTIFIER_EXPRESSION: 
            case LITERAL_EXPRESSION: 
            case ARRAY_LITERAL_EXPRESSION: 
            case OBJECT_LITERAL_EXPRESSION: 
            case NEW_EXPRESSION: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case CALL_EXPRESSION: 
            case FUNCTION_DECLARATION: 
            case TEMPLATE_LITERAL_EXPRESSION: 
            case BINARY_OPERATOR: 
            case MISSING_PRIMARY_EXPRESSION: 
            case CONDITIONAL_EXPRESSION: 
            case UNARY_EXPRESSION: 
            case POSTFIX_EXPRESSION: 
            case PAREN_EXPRESSION: {
                return true;
            }
        }
        return false;
    }

    public boolean isMemberExpression() {
        switch (this.type) {
            case THIS_EXPRESSION: 
            case SUPER_EXPRESSION: 
            case IDENTIFIER_EXPRESSION: 
            case LITERAL_EXPRESSION: 
            case ARRAY_LITERAL_EXPRESSION: 
            case OBJECT_LITERAL_EXPRESSION: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case CALL_EXPRESSION: 
            case FUNCTION_DECLARATION: 
            case TEMPLATE_LITERAL_EXPRESSION: 
            case PAREN_EXPRESSION: {
                return true;
            }
            case NEW_EXPRESSION: {
                return this.asNewExpression().arguments != null;
            }
        }
        return false;
    }

    public boolean isExpression() {
        return this.isAssignmentExpression() || this.type == ParseTreeType.COMMA_EXPRESSION;
    }

    public boolean isAssignmentOrSpread() {
        return this.isAssignmentExpression() || this.type == ParseTreeType.SPREAD_EXPRESSION;
    }

    public boolean isRestParameter() {
        return this.type == ParseTreeType.REST_PARAMETER;
    }

    public boolean isAssignmentRestElement() {
        return this.type == ParseTreeType.ASSIGNMENT_REST_ELEMENT;
    }

    public boolean isStatement() {
        return this.isSourceElement();
    }

    public boolean isStatementStandard() {
        switch (this.type) {
            case BLOCK: 
            case VARIABLE_STATEMENT: 
            case EMPTY_STATEMENT: 
            case EXPRESSION_STATEMENT: 
            case IF_STATEMENT: 
            case DO_WHILE_STATEMENT: 
            case WHILE_STATEMENT: 
            case FOR_OF_STATEMENT: 
            case FOR_IN_STATEMENT: 
            case FOR_STATEMENT: 
            case CONTINUE_STATEMENT: 
            case BREAK_STATEMENT: 
            case RETURN_STATEMENT: 
            case YIELD_EXPRESSION: 
            case WITH_STATEMENT: 
            case SWITCH_STATEMENT: 
            case LABELLED_STATEMENT: 
            case THROW_STATEMENT: 
            case TRY_STATEMENT: 
            case DEBUGGER_STATEMENT: {
                return true;
            }
        }
        return false;
    }

    public boolean isSourceElement() {
        return this.isStatementStandard() || this.type == ParseTreeType.FUNCTION_DECLARATION;
    }

    public String toString() {
        return (Object)((Object)this.type) + "@" + this.location;
    }
}

