/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.command.line;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.stjs.generator.GenerationDirectory;
import org.stjs.generator.Generator;
import org.stjs.generator.GeneratorConfiguration;
import org.stjs.generator.GeneratorConfigurationBuilder;
import org.stjs.generator.STJSRuntimeException;

public class CommandLine {
    public static void main(String[] args) throws URISyntaxException, IOException, ClassNotFoundException {
        if (args.length != 2) {
            System.err.println("Usage: CommandLine <srcDir> <classQualifiedName>");
            return;
        }
        String path = args[0];
        String fileName = args[1];
        File sourceFile = new File(path + "/" + fileName.replaceAll("\\.", "/") + ".java");
        CommandLine.compile(path, Collections.singletonList(sourceFile), Collections.emptyList());
        CommandLine.generate(path, fileName, Collections.emptyList(), path);
    }

    static void generate(String path, String className, List<File> dependencies, String outputDir) {
        try (Generator gen = null;){
            ArrayList<URL> classpathElements = new ArrayList<URL>();
            classpathElements.add(new File(path).toURI().toURL());
            for (File dep : dependencies) {
                classpathElements.add(dep.toURI().toURL());
            }
            URLClassLoader builtProjectClassLoader = new URLClassLoader(classpathElements.toArray(new URL[classpathElements.size()]), Thread.currentThread().getContextClassLoader());
            File sourceFolder = new File(path);
            GenerationDirectory generationFolder = new GenerationDirectory(new File(outputDir), null, new URI("/"));
            GeneratorConfigurationBuilder configBuilder = new GeneratorConfigurationBuilder();
            configBuilder.allowedPackage(builtProjectClassLoader.loadClass(className).getPackage().getName());
            configBuilder.generationFolder(generationFolder);
            configBuilder.targetFolder(generationFolder.getGeneratedSourcesAbsolutePath());
            configBuilder.stjsClassLoader((ClassLoader)builtProjectClassLoader);
            GeneratorConfiguration configuration = configBuilder.build();
            gen = new Generator(configuration);
            gen.generateJavascript(className, sourceFolder);
        }
    }

    static void compile(String path, List<File> sourceFiles, List<File> dependencies) {
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new STJSRuntimeException("A Java compiler is not available for this project. You may have configured your environment to run with a JRE instead of a JDK");
            }
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            fileManager.setLocation(StandardLocation.CLASS_PATH, dependencies);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
            compiler.getTask(null, fileManager, null, null, null, compilationUnits1).call();
            fileManager.close();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

