/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.command.line;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.stjs.command.line.CommandLine;

public class ProjectCommandLine {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: st-js <srcDir> <libDir> <outputDir>");
            return;
        }
        String path = args[0];
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        String libDir = args[1];
        List<File> dependencies = ProjectCommandLine.listFiles(new File(libDir), ".jar");
        String outputDir = args[2];
        List<File> classNames = ProjectCommandLine.listFiles(new File(path), ".java");
        CommandLine.compile(path, classNames, dependencies);
        ProjectCommandLine.generate(path, classNames, dependencies, outputDir);
    }

    private static void generate(String path, List<File> files, List<File> dependencies, String outputDir) {
        File srcPath = new File(path);
        for (File file : files) {
            CommandLine.generate(path, file.getAbsolutePath().substring(srcPath.getAbsolutePath().length() + 1).replace(".java", "").replace(File.separatorChar, '.'), dependencies, outputDir);
        }
    }

    private static List<File> listFiles(File srcDir, String suffix) {
        ArrayList files = Lists.newArrayList();
        ProjectCommandLine.listFiles0(srcDir, files, suffix);
        return files;
    }

    private static void listFiles0(File srcDir, List<File> output, String suffix) {
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Not a directory: " + srcDir);
        }
        for (File file : srcDir.listFiles()) {
            if (file.isDirectory()) {
                ProjectCommandLine.listFiles0(file, output, suffix);
                continue;
            }
            if (!file.getName().endsWith(suffix)) continue;
            output.add(file);
        }
    }
}

