/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.persistence.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.statefulj.common.utils.ReflectionUtils;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.persistence.common.annotations.State;

public abstract class AbstractPersister<T>
implements Persister<T> {
    Logger logger = LoggerFactory.getLogger(AbstractPersister.class);
    private Field idField;
    private Field stateField;
    private org.statefulj.fsm.model.State<T> start;
    private Class<T> clazz;
    private HashMap<String, org.statefulj.fsm.model.State<T>> states = new HashMap();

    public AbstractPersister(List<org.statefulj.fsm.model.State<T>> states, String stateFieldName, org.statefulj.fsm.model.State<T> start, Class<T> clazz) {
        this.clazz = clazz;
        this.idField = this.findIdField(clazz);
        if (this.idField == null) {
            throw new RuntimeException("No Id field defined");
        }
        this.idField.setAccessible(true);
        this.stateField = this.findStateField(stateFieldName, clazz);
        if (this.stateField == null) {
            throw new RuntimeException("No State field defined");
        }
        if (!this.validStateField(this.stateField)) {
            throw new RuntimeException(String.format("State field, %s, of class %s, is not of type %s", this.stateField.getName(), clazz, this.getStateFieldType()));
        }
        this.stateField.setAccessible(true);
        this.start = start;
        for (org.statefulj.fsm.model.State<T> state : states) {
            this.states.put(state.getName(), state);
        }
    }

    public org.statefulj.fsm.model.State<T> getCurrent(T stateful) {
        org.statefulj.fsm.model.State<T> state = null;
        try {
            String stateKey = this.getState(stateful);
            state = stateKey == null ? this.start : this.states.get(stateKey);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        state = state == null ? this.start : state;
        return state;
    }

    public abstract void setCurrent(T var1, org.statefulj.fsm.model.State<T> var2, org.statefulj.fsm.model.State<T> var3) throws StaleStateException;

    protected abstract boolean validStateField(Field var1);

    protected abstract Field findIdField(Class<?> var1);

    protected Field findStateField(String stateFieldName, Class<?> clazz) {
        Field stateField = null;
        if (StringUtils.isEmpty((CharSequence)stateFieldName)) {
            stateField = ReflectionUtils.getFirstAnnotatedField(clazz, State.class);
        } else {
            try {
                stateField = clazz.getDeclaredField(stateFieldName);
            }
            catch (NoSuchFieldException e) {
                this.logger.error("Unable to locate state field for {}, stateFieldName={}", (Object)clazz.getName(), (Object)stateFieldName);
            }
            catch (SecurityException e) {
                this.logger.error("Security exception trying to locate state field for {}, stateFieldName={}", (Object)clazz.getName(), (Object)stateFieldName);
                this.logger.error("Exception", (Throwable)e);
            }
        }
        return stateField;
    }

    protected abstract Class<?> getStateFieldType();

    protected Field getIdField() {
        return this.idField;
    }

    protected void setIdField(Field idField) {
        this.idField = idField;
    }

    protected Field getStateField() {
        return this.stateField;
    }

    protected void setStateField(Field stateField) {
        this.stateField = stateField;
    }

    protected org.statefulj.fsm.model.State<T> getStart() {
        return this.start;
    }

    protected void setStart(org.statefulj.fsm.model.State<T> start) {
        this.start = start;
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    protected void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    protected HashMap<String, org.statefulj.fsm.model.State<T>> getStates() {
        return this.states;
    }

    protected void setStates(HashMap<String, org.statefulj.fsm.model.State<T>> states) {
        this.states = states;
    }

    protected Object getId(T obj) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return this.idField.get(obj);
    }

    protected String getState(T obj) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return (String)this.stateField.get(obj);
    }

    protected void setState(T obj, String state) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        state = state == null ? this.start.getName() : state;
        this.stateField.set(obj, state);
    }

    protected void throwStaleState(org.statefulj.fsm.model.State<T> current, org.statefulj.fsm.model.State<T> next) throws StaleStateException {
        String err = String.format("Unable to update state, entity.state=%s, db.state=%s", current.getName(), next.getName());
        throw new StaleStateException(err);
    }
}

