/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.persistence.jpa;

import java.lang.reflect.Field;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.statefulj.common.utils.ReflectionUtils;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.fsm.model.State;
import org.statefulj.persistence.common.AbstractPersister;

@Transactional
public class JPAPerister<T>
extends AbstractPersister<T>
implements Persister<T> {
    Logger logger = LoggerFactory.getLogger(JPAPerister.class);
    @PersistenceContext
    private EntityManager entityManager;

    public JPAPerister(List<State<T>> states, State<T> start, Class<T> clazz) {
        this(states, null, start, clazz);
    }

    public JPAPerister(List<State<T>> states, String stateFieldName, State<T> start, Class<T> clazz) {
        super(states, stateFieldName, start, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrent(T stateful, State<T> current, State<T> next) throws StaleStateException {
        block14: {
            try {
                Object id = this.getId(stateful);
                if (id != null && this.entityManager.contains(stateful)) {
                    String update = this.buildUpdateStatement(id, stateful, current, next, this.getIdField(), this.getStateField());
                    if (this.entityManager.createQuery(update).executeUpdate() == 0) {
                        String query = String.format("select %s from %s where %s=%s", this.getStateField().getName(), this.getClazz().getSimpleName(), this.getIdField().getName(), id);
                        String state = this.getStart().getName();
                        try {
                            state = (String)this.entityManager.createQuery(query).getSingleResult();
                        }
                        catch (NoResultException nre) {
                            // empty catch block
                        }
                        this.logger.warn("Stale State, expected={}, actual={}", (Object)current.getName(), (Object)state);
                        this.setState(stateful, state);
                        this.throwStaleState(current, next);
                    }
                    this.setState(stateful, next.getName());
                    break block14;
                }
                T t = stateful;
                synchronized (t) {
                    String state = this.getState(stateful);
                    String string = state = state == null ? this.getStart().getName() : state;
                    if (state.equals(current.getName())) {
                        this.setState(stateful, next.getName());
                    } else {
                        this.throwStaleState(current, next);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String buildUpdateStatement(Object id, T stateful, State<T> current, State<T> next, Field idField, Field stateField) {
        String where = current.equals((Object)this.getStart()) ? String.format("%s=%s and (%s='%s' or %s is null)", this.getIdField().getName(), id, this.getStateField().getName(), current.getName(), this.getStateField().getName()) : String.format("%s=%s and %s='%s'", this.getIdField().getName(), id, this.getStateField().getName(), current.getName());
        String update = String.format("update %s set %s='%s' where %s", this.getClazz().getSimpleName(), this.getStateField().getName(), next.getName(), where);
        return update;
    }

    protected boolean validStateField(Field stateField) {
        return stateField.getType().equals(String.class);
    }

    protected Field findIdField(Class<?> clazz) {
        return ReflectionUtils.getReferencedField(clazz, Id.class);
    }

    protected Class<?> getStateFieldType() {
        return String.class;
    }
}

