/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.persistence.mongo;

import com.mongodb.DBObject;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.persistence.EmbeddedId;
import org.bson.types.ObjectId;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.statefulj.common.utils.ReflectionUtils;
import org.statefulj.fsm.Persister;
import org.statefulj.fsm.StaleStateException;
import org.statefulj.fsm.model.State;
import org.statefulj.persistence.common.AbstractPersister;
import org.statefulj.persistence.mongo.MongoCascadeSupport;
import org.statefulj.persistence.mongo.StateDocumentImpl;
import org.statefulj.persistence.mongo.model.StateDocument;

public class MongoPersister<T>
extends AbstractPersister<T>
implements Persister<T>,
BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    static final FindAndModifyOptions RETURN_NEW = FindAndModifyOptions.options().returnNew(true);
    private ApplicationContext appContext;
    private String repoId;
    private MongoTemplate mongoTemplate;
    private String templateId;

    public MongoPersister(List<State<T>> states, State<T> start, Class<T> clazz, MongoTemplate mongoTemplate) {
        super(states, null, start, clazz);
        this.mongoTemplate = mongoTemplate;
    }

    public MongoPersister(List<State<T>> states, String stateFieldName, State<T> start, Class<T> clazz, MongoTemplate mongoTemplate) {
        super(states, stateFieldName, start, clazz);
        this.mongoTemplate = mongoTemplate;
    }

    public MongoPersister(List<State<T>> states, State<T> start, Class<T> clazz, String repoId) {
        this(states, null, start, clazz, repoId);
    }

    public MongoPersister(List<State<T>> states, String stateFieldName, State<T> start, Class<T> clazz, String repoId) {
        super(states, stateFieldName, start, clazz);
        this.repoId = repoId;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public void setCurrent(T stateful, State<T> current, State<T> next) throws StaleStateException {
        try {
            StateDocumentImpl stateDoc = this.getStateDocument(stateful);
            if (stateDoc != null && stateDoc.isPersisted()) {
                this.updateStateInDB(stateful, current, next, stateDoc);
            } else {
                this.updateInMemory(stateful, stateDoc, current.getName(), next.getName());
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateStateInDB(T stateful, State<T> current, State<T> next, StateDocumentImpl stateDoc) throws IllegalAccessException, StaleStateException {
        Update update;
        Query query = this.buildQuery(stateDoc, current);
        StateDocumentImpl updatedDoc = this.updateStateDoc(query, update = this.buildUpdate(current, next));
        if (updatedDoc != null) {
            this.setStateDocument(stateful, updatedDoc);
        } else {
            updatedDoc = this.findStateDoc(stateDoc.getId());
            if (updatedDoc != null) {
                String currentState = stateDoc.getState();
                this.setStateDocument(stateful, updatedDoc);
                this.throwStaleState(currentState, updatedDoc.getState());
            } else {
                throw new RuntimeException("Unable to find StateDocument with id=" + stateDoc.getId());
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.mongoTemplate == null) {
            if (this.repoId != null) {
                BeanDefinition repo = registry.getBeanDefinition(this.repoId);
                this.templateId = ((BeanReference)repo.getPropertyValues().get("mongoOperations")).getBeanName();
            }
            if (this.templateId == null) {
                throw new RuntimeException("Unable to obtain a reference to a MongoTemplate");
            }
        }
        AbstractBeanDefinition mongoCascadeSupportBean = BeanDefinitionBuilder.genericBeanDefinition(MongoCascadeSupport.class).getBeanDefinition();
        ConstructorArgumentValues args = mongoCascadeSupportBean.getConstructorArgumentValues();
        args.addIndexedArgumentValue(0, (Object)this);
        registry.registerBeanDefinition(Long.toString(new Random().nextLong()), (BeanDefinition)mongoCascadeSupportBean);
    }

    protected boolean validStateField(Field stateField) {
        return stateField.getType().equals(StateDocument.class);
    }

    protected Field findIdField(Class<?> clazz) {
        Field idField = ReflectionUtils.getReferencedField((Class)this.getClazz(), Id.class);
        if (idField == null && (idField = ReflectionUtils.getReferencedField((Class)this.getClazz(), javax.persistence.Id.class)) == null) {
            idField = ReflectionUtils.getReferencedField((Class)this.getClazz(), EmbeddedId.class);
        }
        return idField;
    }

    protected Class<?> getStateFieldType() {
        return StateDocumentImpl.class;
    }

    protected Query buildQuery(StateDocumentImpl state, State<T> current) {
        return Query.query((CriteriaDefinition)new Criteria("_id").is((Object)state.getId()).and("state").is((Object)current.getName()));
    }

    protected Update buildUpdate(State<T> current, State<T> next) {
        Update update = new Update();
        update.set("prevState", (Object)current.getName());
        update.set("state", (Object)next.getName());
        update.set("updated", (Object)Calendar.getInstance().getTime());
        return update;
    }

    protected String getState(T stateful) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        StateDocumentImpl stateDoc = this.getStateDocument(stateful);
        return stateDoc != null ? stateDoc.getState() : this.getStart().getName();
    }

    protected void setState(T stateful, String state) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        StateDocumentImpl stateDoc = this.getStateDocument(stateful);
        if (stateDoc == null) {
            stateDoc = this.createStateDocument(stateful);
        }
        stateDoc.setPrevState(stateDoc.getState());
        stateDoc.setState(state);
        stateDoc.setUpdated(Calendar.getInstance().getTime());
    }

    protected StateDocumentImpl getStateDocument(T stateful) throws IllegalArgumentException, IllegalAccessException {
        Object stateDoc = this.getStateField().get(stateful);
        if (stateDoc instanceof LazyLoadingProxy) {
            stateDoc = ((LazyLoadingProxy)stateDoc).getTarget();
        }
        return (StateDocumentImpl)stateDoc;
    }

    protected StateDocumentImpl createStateDocument(T stateful) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        StateDocumentImpl stateDoc = new StateDocumentImpl();
        stateDoc.setPersisted(false);
        stateDoc.setId(new ObjectId().toHexString());
        stateDoc.setState(this.getStart().getName());
        stateDoc.setManagedCollection(this.getMongoTemplate().getCollectionName(stateful.getClass()));
        stateDoc.setManagedField(this.getStateField().getName());
        this.setStateDocument(stateful, stateDoc);
        return stateDoc;
    }

    protected void setStateDocument(T stateful, StateDocument stateDoc) throws IllegalArgumentException, IllegalAccessException {
        this.getStateField().set(stateful, stateDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInMemory(T stateful, StateDocumentImpl stateDoc, String current, String next) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, StaleStateException {
        T t = stateful;
        synchronized (t) {
            if (stateDoc == null) {
                stateDoc = this.createStateDocument(stateful);
            }
            if (stateDoc.getState().equals(current)) {
                this.setState(stateful, next);
            } else {
                this.throwStaleState(current, next);
            }
        }
    }

    protected void throwStaleState(String current, String next) throws StaleStateException {
        String err = String.format("Unable to update state, entity.state=%s, db.state=%s", current, next);
        throw new StaleStateException(err);
    }

    protected MongoTemplate getMongoTemplate() {
        if (this.mongoTemplate == null) {
            this.mongoTemplate = (MongoTemplate)this.appContext.getBean(this.templateId);
        }
        return this.mongoTemplate;
    }

    protected StateDocumentImpl updateStateDoc(Query query, Update update) {
        return (StateDocumentImpl)this.getMongoTemplate().findAndModify(query, update, RETURN_NEW, StateDocumentImpl.class);
    }

    protected StateDocumentImpl findStateDoc(String id) {
        return (StateDocumentImpl)this.getMongoTemplate().findById((Object)id, StateDocumentImpl.class);
    }

    void onAfterSave(Object stateful, DBObject dbo) {
        if (this.getClazz().isAssignableFrom(stateful.getClass())) {
            try {
                boolean updateStateful = false;
                StateDocumentImpl stateDoc = this.getStateDocument(stateful);
                if (stateDoc == null) {
                    stateDoc = this.createStateDocument(stateful);
                    stateDoc.setUpdated(Calendar.getInstance().getTime());
                    updateStateful = true;
                }
                if (!stateDoc.isPersisted()) {
                    stateDoc.setManagedId(this.getId(stateful));
                    this.getMongoTemplate().save((Object)stateDoc);
                    stateDoc.setPersisted(true);
                    if (updateStateful) {
                        this.getMongoTemplate().save(stateful);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void onAfterDelete(Class<?> stateful, DBObject obj) {
        if (stateful != null && this.getClazz().isAssignableFrom(stateful)) {
            Criteria criteria = new Criteria("managedId").is(obj.get(this.getIdField().getName())).and("managedCollection").is((Object)this.getMongoTemplate().getCollectionName(this.getClazz())).and("managedField").is((Object)this.getStateField().getName());
            this.getMongoTemplate().remove(new Query((CriteriaDefinition)criteria), StateDocumentImpl.class);
        }
    }
}

