/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.model;

import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.streampipes.empire.cp.openrdf.utils.model.DelegatingModel;
import org.streampipes.empire.cp.openrdf.utils.model.Models2;
import org.streampipes.empire.cp.openrdf.utils.model.Statements;

public final class ConstrainedModel
extends DelegatingModel {
    private final Predicate<Statement> mConstraint;

    ConstrainedModel(Model theGraph, Predicate<Statement> theConstraint) {
        super(theGraph);
        this.mConstraint = theConstraint;
    }

    public static ConstrainedModel of(Predicate<Statement> theConstraint) {
        return ConstrainedModel.of(Models2.newModel(), theConstraint);
    }

    public static ConstrainedModel of(Model theGraph, Predicate<Statement> theConstraint) {
        return new ConstrainedModel(theGraph, theConstraint);
    }

    public static Predicate<Statement> onlyValidLiterals() {
        return theStatement -> {
            if (theStatement.getObject() instanceof Literal && !Statements.isLiteralValid((Literal)theStatement.getObject())) {
                throw new StatementViolatedConstraintException(theStatement.getObject() + " is not a well-formed literal value.");
            }
            return true;
        };
    }

    @Override
    public boolean add(Statement e) {
        this.mConstraint.test(e);
        return super.add(e);
    }

    @Override
    public boolean add(Resource theResource, IRI theURI, Value theValue, Resource ... theContexts) {
        if (theContexts == null || theContexts.length == 0) {
            return this.add(this.getValueFactory().createStatement(theResource, theURI, theValue));
        }
        boolean aAdded = true;
        for (Resource aCxt : theContexts) {
            aAdded |= this.add(this.getValueFactory().createStatement(theResource, theURI, theValue, aCxt));
        }
        return aAdded;
    }

    @Override
    public boolean addAll(Collection<? extends Statement> c) {
        ConstrainedModel.all(c, this.mConstraint);
        return super.addAll(c);
    }

    private static <T> void all(Iterable<? extends T> theObjects, Predicate<T> theConstraint) {
        for (T aObj : theObjects) {
            theConstraint.test(aObj);
        }
    }

    public static class StatementViolatedConstraintException
    extends RuntimeException {
        public StatementViolatedConstraintException(String theMessage) {
            super(theMessage);
        }
    }
}

