/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.model;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.streampipes.empire.cp.openrdf.utils.util.ModelBuildingRDFHandler;
import org.streampipes.empire.cp.openrdf.utils.util.RDFByteSource;

public final class ModelIO {
    public static final String DEFAULT_BASE_URI = "http://openrdf.clarkparsia.com/";

    private ModelIO() {
        throw new AssertionError();
    }

    public static Model read(Path theFile) throws IOException, RDFParseException {
        return ModelIO.read(theFile, Rio.getParserFormatForFileName((String)theFile.getFileName().toString()).orElse(RDFFormat.TURTLE));
    }

    public static Model read(Path theFile, RDFFormat theFormat) throws IOException, RDFParseException {
        return ModelIO.read(new InputStreamReader(Files.newInputStream(theFile, new OpenOption[0]), ModelIO.getCharset(theFormat).orElse(Charsets.UTF_8)), theFormat, DEFAULT_BASE_URI);
    }

    private static Optional<Charset> getCharset(RDFFormat theFormat) {
        return theFormat.hasCharset() ? Optional.of(theFormat.getCharset()) : Optional.empty();
    }

    public static Model read(RDFByteSource theSource) throws IOException, RDFParseException {
        return ModelIO.read(theSource.asCharSource(ModelIO.getCharset(theSource.getFormat()).orElse(Charsets.UTF_8)).openStream(), theSource.getFormat(), theSource.getBaseURI());
    }

    public static Model read(InputStream theInput, RDFFormat theFormat) throws IOException, RDFParseException {
        return ModelIO.read(new InputStreamReader(theInput, ModelIO.getCharset(theFormat).orElse(Charsets.UTF_8)), theFormat, DEFAULT_BASE_URI);
    }

    public static Model read(InputStream theInput, RDFFormat theFormat, String theBase) throws IOException, RDFParseException {
        return ModelIO.read(new InputStreamReader(theInput, ModelIO.getCharset(theFormat).orElse(Charsets.UTF_8)), theFormat, theBase);
    }

    public static Model read(Reader theInput, RDFFormat theFormat, String theBase) throws IOException, RDFParseException {
        RDFParser aParser = Rio.createParser((RDFFormat)theFormat);
        aParser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        ModelBuildingRDFHandler aHandler = new ModelBuildingRDFHandler();
        aParser.setRDFHandler((RDFHandler)aHandler);
        try {
            aParser.parse(theInput, theBase);
        }
        catch (RDFHandlerException e) {
            throw new RDFParseException((Throwable)e);
        }
        finally {
            if (theInput != null) {
                theInput.close();
            }
        }
        return aHandler.getModel();
    }

    public static void read(RDFHandler theHandler, Reader theInput, RDFFormat theFormat, String theBase) throws IOException, RDFParseException {
        RDFParser aParser = Rio.createParser((RDFFormat)theFormat);
        aParser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        aParser.setRDFHandler(theHandler);
        try {
            aParser.parse(theInput, theBase);
        }
        catch (RDFHandlerException e) {
            throw new RDFParseException((Throwable)e);
        }
        finally {
            if (theInput != null) {
                theInput.close();
            }
        }
    }

    public static void write(Model theGraph, OutputStream theStream, RDFFormat theFormat) throws IOException {
        ModelIO.write(theGraph, new OutputStreamWriter(theStream), theFormat);
    }

    public static void write(Model theGraph, Writer theWriter, RDFFormat theFormat) throws IOException {
        ModelIO.write(theGraph, Rio.createWriter((RDFFormat)theFormat, (Writer)theWriter));
    }

    public static String toString(Model theGraph, RDFFormat theFormat) {
        try {
            StringWriter aStringWriter = new StringWriter();
            ModelIO.write(theGraph, aStringWriter, theFormat);
            return aStringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void write(Model theGraph, RDFWriter theWriter) throws IOException {
        try {
            theWriter.startRDF();
            for (Statement aStmt : theGraph) {
                theWriter.handleStatement(aStmt);
            }
            theWriter.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
    }
}

