/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public final class Statements {
    private Statements() {
        throw new AssertionError();
    }

    public static Predicate<Statement> subjectIs(Resource theSubj) {
        return theStmt -> Objects.equals(theStmt.getSubject(), theSubj);
    }

    public static Predicate<Statement> predicateIs(IRI thePred) {
        return theStmt -> Objects.equals(theStmt.getPredicate(), thePred);
    }

    public static Predicate<Statement> objectIs(Value theObj) {
        return theStmt -> Objects.equals(theStmt.getObject(), theObj);
    }

    public static Predicate<Statement> contextIs(Resource theContext) {
        return theStmt -> Objects.equals(theStmt.getContext(), theContext);
    }

    public static Predicate<Statement> objectIs(Class<? extends Value> theValue) {
        return theStmt -> theValue.isInstance(theStmt.getObject());
    }

    public static Function<Statement, Statement> applyContext(Resource theContext) {
        return Statements.applyContext(theContext, (ValueFactory)SimpleValueFactory.getInstance());
    }

    public static Function<Statement, Statement> applyContext(Resource theContext, ValueFactory theValueFactory) {
        return theStmt -> {
            if (Objects.equals(theContext, theStmt.getContext())) {
                return theStmt;
            }
            return theValueFactory.createStatement(theStmt.getSubject(), theStmt.getPredicate(), theStmt.getObject(), theContext);
        };
    }

    public static Predicate<Statement> matches(Resource theSubject, IRI thePredicate, Value theObject, Resource ... theContexts) {
        return theStatement -> {
            if (theSubject != null && !theSubject.equals(theStatement.getSubject())) {
                return false;
            }
            if (thePredicate != null && !thePredicate.equals((Object)theStatement.getPredicate())) {
                return false;
            }
            if (theObject != null && !theObject.equals(theStatement.getObject())) {
                return false;
            }
            if (theContexts == null || theContexts.length == 0) {
                return true;
            }
            Resource aContext = theStatement.getContext();
            for (Resource aCxt : theContexts) {
                if (aCxt == null && aContext == null) {
                    return true;
                }
                if (aCxt == null || !aCxt.equals(aContext)) continue;
                return true;
            }
            return false;
        };
    }

    public static Function<Statement, Optional<Resource>> subjectOptional() {
        return theStatement -> Optional.of(theStatement.getSubject());
    }

    public static Function<Statement, Optional<IRI>> predicateOptional() {
        return theStatement -> Optional.of(theStatement.getPredicate());
    }

    public static Function<Statement, Optional<Value>> objectOptional() {
        return theStatement -> Optional.of(theStatement.getObject());
    }

    public static Function<Statement, Optional<Literal>> objectAsLiteral() {
        return theStatement -> theStatement.getObject() instanceof Literal ? Optional.of((Literal)theStatement.getObject()) : Optional.empty();
    }

    public static Function<Statement, Optional<Resource>> objectAsResource() {
        return theStatement -> theStatement.getObject() instanceof Resource ? Optional.of((Resource)theStatement.getObject()) : Optional.empty();
    }

    public static Function<Statement, Optional<Resource>> contextOptional() {
        return theStatement -> theStatement.getContext() != null ? Optional.of(theStatement.getContext()) : Optional.empty();
    }

    public static boolean isLiteralValid(Literal theLiteral) {
        if (Literals.isLanguageLiteral((Literal)theLiteral)) {
            String aLang = (String)theLiteral.getLanguage().get();
            if (!TurtleUtil.isLanguageStartChar((int)aLang.charAt(0))) {
                return false;
            }
            for (int aIndex = 1; aIndex < aLang.length(); ++aIndex) {
                if (TurtleUtil.isLanguageChar((int)aLang.charAt(aIndex))) continue;
                return false;
            }
        }
        if (theLiteral.getDatatype() != null && theLiteral.getDatatype().getNamespace().equals("http://www.w3.org/2001/XMLSchema#")) {
            String aTypeName = theLiteral.getDatatype().getLocalName();
            try {
                if (aTypeName.equals(XMLSchema.DATETIME.getLocalName())) {
                    theLiteral.calendarValue();
                } else if (aTypeName.equals(XMLSchema.INT.getLocalName())) {
                    theLiteral.intValue();
                } else if (aTypeName.equals(XMLSchema.FLOAT.getLocalName())) {
                    theLiteral.floatValue();
                } else if (aTypeName.equals(XMLSchema.LONG.getLocalName())) {
                    theLiteral.longValue();
                } else if (aTypeName.equals(XMLSchema.DOUBLE.getLocalName())) {
                    theLiteral.doubleValue();
                } else if (aTypeName.equals(XMLSchema.SHORT.getLocalName())) {
                    theLiteral.shortValue();
                } else if (aTypeName.equals(XMLSchema.BOOLEAN.getLocalName())) {
                    theLiteral.booleanValue();
                } else if (aTypeName.equals(XMLSchema.BYTE.getLocalName())) {
                    theLiteral.byteValue();
                } else if (aTypeName.equals(XMLSchema.DECIMAL.getLocalName())) {
                    theLiteral.decimalValue();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

