/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.query;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;

public final class ImmutableDataset
implements Dataset {
    private final ImmutableSet<IRI> mNamedGraphs;
    private final IRI mInsertURI;
    private final ImmutableSet<IRI> mRemoveGraphs;
    private final ImmutableSet<IRI> mDefaultGraphs;

    private ImmutableDataset(ImmutableSet<IRI> theDefaultGraphs, ImmutableSet<IRI> theNamedGraphs, IRI theInsertURI, ImmutableSet<IRI> theRemoveURI) {
        this.mInsertURI = theInsertURI;
        this.mRemoveGraphs = theRemoveURI;
        this.mDefaultGraphs = theDefaultGraphs;
        this.mNamedGraphs = theNamedGraphs;
    }

    public Set<IRI> getDefaultRemoveGraphs() {
        return this.mRemoveGraphs;
    }

    public IRI getDefaultInsertGraph() {
        return this.mInsertURI;
    }

    public Set<IRI> getDefaultGraphs() {
        return this.mDefaultGraphs;
    }

    public Set<IRI> getNamedGraphs() {
        return this.mNamedGraphs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mDefaultGraphs, this.mNamedGraphs, this.mInsertURI, this.mRemoveGraphs});
    }

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof ImmutableDataset) {
            ImmutableDataset aDataset = (ImmutableDataset)theObj;
            return Objects.equal(this.mDefaultGraphs, aDataset.mDefaultGraphs) && Objects.equal(this.mNamedGraphs, aDataset.mNamedGraphs) && Objects.equal(this.mRemoveGraphs, aDataset.mRemoveGraphs) && Objects.equal((Object)this.mInsertURI, (Object)aDataset.mInsertURI);
        }
        return false;
    }

    public String toString() {
        MoreObjects.ToStringHelper aStringHelper = MoreObjects.toStringHelper((String)"Dataset").add("defaultGraphs", this.mDefaultGraphs).add("namedGraphs", this.mNamedGraphs);
        if (!this.mRemoveGraphs.isEmpty()) {
            aStringHelper.add("removeGraphs", this.mRemoveGraphs);
        }
        if (this.mInsertURI != null) {
            aStringHelper.add("insertURI", (Object)this.mInsertURI);
        }
        return aStringHelper.toString();
    }

    public static ImmutableDatasetBuilder builder() {
        return new ImmutableDatasetBuilder();
    }

    public static final class ImmutableDatasetBuilder {
        private Set<IRI> mNamedGraphs = ImmutableSet.of();
        private IRI mInsertURI = null;
        private Set<IRI> mRemoveGraphs = ImmutableSet.of();
        private Set<IRI> mDefaultGraphs = ImmutableSet.of();

        public ImmutableDataset build() {
            return new ImmutableDataset(ImmutableSet.copyOf(this.mDefaultGraphs), ImmutableSet.copyOf(this.mNamedGraphs), this.mInsertURI, ImmutableSet.copyOf(this.mRemoveGraphs));
        }

        public ImmutableDatasetBuilder insertGraph(IRI theInsertGraph) {
            this.mInsertURI = theInsertGraph;
            return this;
        }

        public ImmutableDatasetBuilder defaultGraphs(IRI theDefaultGraph, IRI ... theOtherGraphs) {
            this.defaultGraphs((Iterable<IRI>)ImmutableSet.copyOf((Object[])ObjectArrays.concat((Object)theDefaultGraph, (Object[])theOtherGraphs)));
            return this;
        }

        public ImmutableDatasetBuilder defaultGraphs(Iterable<IRI> theDefaultGraphs) {
            this.mDefaultGraphs = ImmutableSet.copyOf(theDefaultGraphs);
            return this;
        }

        public ImmutableDatasetBuilder removeGraphs(IRI theGraph, IRI ... theOtherGraphs) {
            this.removeGraphs((Iterable<IRI>)ImmutableSet.copyOf((Object[])ObjectArrays.concat((Object)theGraph, (Object[])theOtherGraphs)));
            return this;
        }

        public ImmutableDatasetBuilder removeGraphs(Iterable<IRI> theRemoveGraphs) {
            this.mRemoveGraphs = ImmutableSet.copyOf(theRemoveGraphs);
            return this;
        }

        public ImmutableDatasetBuilder namedGraphs(IRI theGraph, IRI ... theOtherGraphs) {
            this.namedGraphs((Iterable<IRI>)ImmutableSet.copyOf((Object[])ObjectArrays.concat((Object)theGraph, (Object[])theOtherGraphs)));
            return this;
        }

        public ImmutableDatasetBuilder namedGraphs(Iterable<IRI> theNamedGraphs) {
            this.mNamedGraphs = ImmutableSet.copyOf(theNamedGraphs);
            return this;
        }
    }
}

