/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.query;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelVisitorBase;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public final class SesameQueryUtils {
    private SesameQueryUtils() {
        throw new AssertionError();
    }

    public static IRI getIRI(BindingSet theBindingSet, String theKey) {
        Value aVal = theBindingSet.getValue(theKey);
        if (aVal instanceof IRI) {
            return (IRI)aVal;
        }
        return null;
    }

    public static Literal getLiteral(BindingSet theBindingSet, String theKey) {
        Value aVal = theBindingSet.getValue(theKey);
        if (aVal instanceof Literal) {
            return (Literal)aVal;
        }
        return null;
    }

    public static Resource getResource(BindingSet theBindingSet, String theKey) {
        Value aVal = theBindingSet.getValue(theKey);
        if (aVal instanceof Resource) {
            return (Resource)aVal;
        }
        return null;
    }

    public static BNode getBNode(BindingSet theBindingSet, String theKey) {
        Value aVal = theBindingSet.getValue(theKey);
        if (aVal instanceof BNode) {
            return (BNode)aVal;
        }
        return null;
    }

    public static Collection<String> getProjection(TupleExpr theExpr) {
        final HashSet aVars = Sets.newHashSet();
        try {
            theExpr.visit((QueryModelVisitor)new AbstractQueryModelVisitor<RuntimeException>(){

                public void meet(ProjectionElem theProjectionElem) throws RuntimeException {
                    super.meet(theProjectionElem);
                    aVars.add(theProjectionElem.getTargetName());
                    aVars.add(theProjectionElem.getSourceName());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aVars;
    }

    public static String getARQSPARQLQueryString(Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof IRI) {
            IRI aURI = (IRI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("<_:").append(((BNode)theValue).getID()).append(">");
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"\"\"").append(SesameQueryUtils.escape(aLit.getLabel())).append("\"\"\"").append(aLit.getLanguage().isPresent() ? "@" + (String)aLit.getLanguage().get() : "");
            if (aLit.getDatatype() != null && !Literals.isLanguageLiteral((Literal)aLit)) {
                aBuffer.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String getSPARQLQueryString(Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof IRI) {
            IRI aURI = (IRI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("_:").append(((BNode)theValue).getID());
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"\"\"").append(SesameQueryUtils.escape(aLit.getLabel())).append("\"\"\"").append(aLit.getLanguage().isPresent() ? "@" + (String)aLit.getLanguage().get() : "");
            if (aLit.getDatatype() != null && !Literals.isLanguageLiteral((Literal)aLit)) {
                aBuffer.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String getSerqlQueryString(Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof IRI) {
            IRI aURI = (IRI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("_:").append(((BNode)theValue).getID());
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"").append(SesameQueryUtils.escape(aLit.getLabel())).append("\"").append(aLit.getLanguage() != null ? "@" + aLit.getLanguage() : "");
            if (aLit.getDatatype() != null && aLit.getLanguage() == null) {
                aBuffer.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String escape(String theString) {
        theString = theString.replaceAll("\"", "\\\\\"");
        StringBuffer aBuffer = new StringBuffer();
        Matcher aMatcher = Pattern.compile("\\\\([^tnrbf\"'\\\\])").matcher(theString);
        while (aMatcher.find()) {
            aMatcher.appendReplacement(aBuffer, String.format("\\\\\\\\%s", aMatcher.group(1)));
        }
        aMatcher.appendTail(aBuffer);
        return aBuffer.toString();
    }

    public static void setLimit(ParsedQuery theQuery, int theLimit) {
        try {
            SliceMutator aLimitSetter = SliceMutator.changeLimit(theLimit);
            theQuery.getTupleExpr().visit((QueryModelVisitor)aLimitSetter);
            if (!aLimitSetter.limitWasSet()) {
                Slice aSlice = new Slice();
                aSlice.setLimit((long)theLimit);
                aSlice.setArg(theQuery.getTupleExpr());
                theQuery.setTupleExpr((TupleExpr)aSlice);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setOffset(ParsedQuery theQuery, int theOffset) {
        try {
            SliceMutator aLimitSetter = SliceMutator.changeOffset(theOffset);
            theQuery.getTupleExpr().visit((QueryModelVisitor)aLimitSetter);
            if (!aLimitSetter.offsetWasSet()) {
                Slice aSlice = new Slice(theQuery.getTupleExpr());
                aSlice.setOffset((long)theOffset);
                theQuery.setTupleExpr((TupleExpr)aSlice);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SliceMutator
    extends QueryModelVisitorBase<Exception> {
        private boolean mLimitWasSet = false;
        private boolean mOffsetWasSet = false;
        private final int mNewLimit;
        private final int mNewOffset;

        private SliceMutator(int theNewLimit, int theNewOffset) {
            this.mNewLimit = theNewLimit;
            this.mNewOffset = theNewOffset;
        }

        static SliceMutator changeLimit(int theNewLimit) {
            return new SliceMutator(theNewLimit, -1);
        }

        static SliceMutator changeOffset(int theNewOffset) {
            return new SliceMutator(-1, theNewOffset);
        }

        static SliceMutator changeLimitAndOffset(int theNewLimit, int theNewOffset) {
            return new SliceMutator(theNewLimit, theNewOffset);
        }

        public void reset() {
            this.mLimitWasSet = false;
            this.mOffsetWasSet = false;
        }

        public boolean limitWasSet() {
            return this.mLimitWasSet;
        }

        public boolean offsetWasSet() {
            return this.mOffsetWasSet;
        }

        public void meet(Slice theSlice) {
            if (this.mNewLimit > 0) {
                this.mLimitWasSet = true;
                theSlice.setLimit((long)this.mNewLimit);
            }
            if (this.mNewOffset > 0) {
                this.mOffsetWasSet = true;
                theSlice.setOffset((long)this.mNewOffset);
            }
        }
    }
}

