/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.repository;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.empire.cp.openrdf.utils.repository.ConnectionClosingGraphQueryResult;
import org.streampipes.empire.cp.openrdf.utils.repository.ConnectionClosingRepositoryResult;
import org.streampipes.empire.cp.openrdf.utils.repository.ConnectionClosingTupleQueryResult;
import org.streampipes.empire.cp.openrdf.utils.repository.RepositoryConnections;

public final class Repositories {
    private static final Logger LOGGER = LoggerFactory.getLogger(Repositories.class);

    public Repositories() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long size(Repository theRepository) throws RepositoryException {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepository.getConnection();
            long l = aConn.size(new Resource[0]);
            return l;
        }
        finally {
            RepositoryConnections.closeQuietly(aConn);
        }
    }

    public static void clear(Repository theRepository) throws RepositoryException {
        try (RepositoryConnection aConn = theRepository.getConnection();){
            RepositoryConnections.clear(aConn, new Resource[0]);
        }
    }

    public static void add(Repository theRepository, Graph theGraph) throws RepositoryException {
        try (RepositoryConnection aConn = theRepository.getConnection();){
            RepositoryConnections.add(aConn, theGraph);
        }
    }

    public static void remove(Repository theRepository, Graph theGraph) throws RepositoryException {
        try (RepositoryConnection aConn = theRepository.getConnection();){
            RepositoryConnections.remove(aConn, theGraph);
        }
    }

    public static boolean contains(Repository theRepository, Statement theStmt) throws RepositoryException {
        try (RepositoryConnection aConn = theRepository.getConnection();){
            boolean bl = theStmt.getContext() != null ? aConn.hasStatement(theStmt, true, new Resource[]{theStmt.getContext()}) : aConn.hasStatement(theStmt, true, new Resource[0]);
            return bl;
        }
    }

    public static void add(Repository theRepo, File theFile) throws RDFParseException, IOException {
        Repositories.add(theRepo, new FileInputStream(theFile), Rio.getParserFormatForFileName((String)theFile.getName()).orElse(RDFFormat.TURTLE));
    }

    public static void add(Repository theRepo, InputStream theStream, RDFFormat theFormat) throws RDFParseException, IOException {
        Repositories.add(theRepo, new InputStreamReader(theStream, Charsets.UTF_8), theFormat);
    }

    public static void add(Repository theRepo, Reader theStream, RDFFormat theFormat) throws RDFParseException, IOException {
        Repositories.add(theRepo, theStream, theFormat, null, null);
    }

    public static void add(Repository theRepo, Reader theStream, RDFFormat theFormat, Resource theContext) throws IOException, RDFParseException {
        Repositories.add(theRepo, theStream, theFormat, theContext, null);
    }

    public static void add(Repository theRepo, Reader theStream, RDFFormat theFormat, Resource theContext, String theBase) throws RDFParseException, IOException {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepo.getConnection();
            RepositoryConnections.add(aConn, theStream, theFormat, theContext, theBase);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            RepositoryConnections.closeQuietly(aConn);
            Closeables.close((Closeable)theStream, (boolean)false);
        }
    }

    public static void writeRepository(Repository theRepo, File theFile, RDFFormat theFormat) throws RepositoryException, IOException {
        Repositories.writeRepository(theRepo, Rio.createWriter((RDFFormat)theFormat, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(theFile), Charsets.UTF_8)));
    }

    public static void writeRepository(Repository theRepo, OutputStream theStream, RDFFormat theFormat) throws RepositoryException, IOException {
        Repositories.writeRepository(theRepo, Rio.createWriter((RDFFormat)theFormat, (Writer)new OutputStreamWriter(theStream, Charsets.UTF_8)));
    }

    public static void writeRepository(Repository theRepo, Writer theWriter, RDFFormat theFormat) throws RepositoryException, IOException {
        Repositories.writeRepository(theRepo, Rio.createWriter((RDFFormat)theFormat, (Writer)theWriter));
    }

    private static void writeRepository(Repository theRepo, RDFWriter theWriter) throws IOException, RepositoryException {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepo.getConnection();
            aConn.exportStatements(null, null, null, true, (RDFHandler)theWriter, new Resource[0]);
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        finally {
            RepositoryConnections.closeQuietly(aConn);
        }
    }

    public static TupleQueryResult selectQuery(Repository theRepo, QueryLanguage theLang, String theQuery) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepo.getConnection();
            return new ConnectionClosingTupleQueryResult(aConn, aConn.prepareTupleQuery(theLang, theQuery).evaluate());
        }
        catch (RepositoryException e) {
            RepositoryConnections.closeQuietly(aConn);
            throw e;
        }
    }

    public static GraphQueryResult constructQuery(Repository theRepo, QueryLanguage theLang, String theQuery) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepo.getConnection();
            return new ConnectionClosingGraphQueryResult(aConn, aConn.prepareGraphQuery(theLang, theQuery).evaluate());
        }
        catch (RepositoryException e) {
            RepositoryConnections.closeQuietly(aConn);
            throw e;
        }
    }

    public static RepositoryResult<Statement> getStatements(Repository theRepository) {
        return Repositories.getStatements(theRepository, null, null, null, new Resource[0]);
    }

    public static RepositoryResult<Statement> getStatements(Repository theRepo, Resource theSubj, IRI thePred, Value theObj, Resource ... theContext) {
        RepositoryConnection aConn = null;
        try {
            aConn = theRepo.getConnection();
            return ConnectionClosingRepositoryResult.newResult(aConn, aConn.getStatements(theSubj, thePred, theObj, true, theContext));
        }
        catch (Exception ex) {
            RepositoryConnections.closeQuietly(aConn);
            LOGGER.error("There was an error getting statements, returning empty iteration.", (Throwable)ex);
            return new RepositoryResult(Repositories.emptyStatementIteration());
        }
    }

    private static CloseableIteration<Statement, RepositoryException> emptyStatementIteration() {
        return new EmptyIteration();
    }
}

