/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.repository;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryConnections {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryConnections.class);

    public RepositoryConnections() {
        throw new AssertionError();
    }

    public static void clear(RepositoryConnection theConnection, Resource ... theContexts) throws RepositoryException {
        try {
            theConnection.begin();
            theConnection.clear(theContexts);
            theConnection.commit();
        }
        catch (RepositoryException e) {
            theConnection.rollback();
            throw e;
        }
    }

    public static void add(RepositoryConnection theConnection, Graph theGraph) throws RepositoryException {
        try {
            theConnection.begin();
            theConnection.add((Iterable)theGraph, new Resource[0]);
            theConnection.commit();
        }
        catch (RepositoryException e) {
            theConnection.rollback();
            throw e;
        }
    }

    public static void remove(RepositoryConnection theConnection, Graph theGraph) throws RepositoryException {
        try {
            theConnection.begin();
            theConnection.remove((Iterable)theGraph, new Resource[0]);
            theConnection.commit();
        }
        catch (RepositoryException e) {
            theConnection.rollback();
            throw e;
        }
    }

    public static void closeQuietly(RepositoryConnection theConn) {
        if (theConn != null) {
            try {
                theConn.close();
            }
            catch (RepositoryException e) {
                LOGGER.error("There was an error while closing the RepositoryConnection.", (Throwable)e);
            }
        }
    }

    public static boolean contains(RepositoryConnection theConnection, Statement theStatement) throws RepositoryException {
        return theStatement.getContext() == null ? theConnection.hasStatement(theStatement, true, new Resource[0]) : theConnection.hasStatement(theStatement, true, new Resource[]{theStatement.getContext()});
    }

    public static void add(RepositoryConnection theRepo, File theFile) throws RDFParseException, IOException {
        RepositoryConnections.add(theRepo, new FileInputStream(theFile), Rio.getParserFormatForFileName((String)theFile.getName()).orElse(RDFFormat.TURTLE));
    }

    public static void add(RepositoryConnection theRepo, InputStream theStream, RDFFormat theFormat) throws RDFParseException, IOException {
        RepositoryConnections.add(theRepo, new InputStreamReader(theStream, Charsets.UTF_8), theFormat);
    }

    public static void add(RepositoryConnection theRepo, Reader theStream, RDFFormat theFormat) throws RDFParseException, IOException {
        RepositoryConnections.add(theRepo, theStream, theFormat, null, null);
    }

    public static void add(RepositoryConnection theRepo, Reader theStream, RDFFormat theFormat, Resource theContext) throws IOException, RDFParseException {
        RepositoryConnections.add(theRepo, theStream, theFormat, theContext, null);
    }

    public static void add(RepositoryConnection theConn, Reader theStream, RDFFormat theFormat, Resource theContext, String theBase) throws RDFParseException, IOException {
        RDFParser aParser = Rio.createParser((RDFFormat)theFormat);
        aParser.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)false);
        aParser.getParserConfig().set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
        aParser.getParserConfig().set(BasicParserSettings.VERIFY_RELATIVE_URIS, (Object)false);
        try {
            theConn.begin();
            RDFInserter aInserter = new RDFInserter(theConn);
            if (theContext != null) {
                aInserter.enforceContext(new Resource[]{theContext});
            }
            aParser.setRDFHandler((RDFHandler)aInserter);
            aParser.parse(theStream, theBase == null ? (theContext != null ? theContext.stringValue() : "http://openrdf.clarkparsia.com") : theBase);
            theConn.commit();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            Closeables.close((Closeable)theStream, (boolean)false);
        }
    }
}

