/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.streampipes.empire.cp.openrdf.utils.util.AdunaIterations;

public final class SailConnections {
    private static final Logger LOGGER = LoggerFactory.getLogger(SailConnections.class);

    public SailConnections() {
        throw new AssertionError();
    }

    public static void clear(SailConnection theConnection, Resource ... theContexts) throws SailException {
        try {
            theConnection.begin();
            theConnection.clear(theContexts);
            theConnection.commit();
        }
        catch (SailException e) {
            theConnection.rollback();
            throw e;
        }
    }

    public static void add(SailConnection theConnection, Graph theGraph) throws SailException {
        try {
            theConnection.begin();
            for (Statement aStmt : theGraph) {
                if (aStmt.getContext() != null) {
                    theConnection.addStatement(aStmt.getSubject(), aStmt.getPredicate(), aStmt.getObject(), new Resource[]{aStmt.getContext()});
                    continue;
                }
                theConnection.addStatement(aStmt.getSubject(), aStmt.getPredicate(), aStmt.getObject(), new Resource[0]);
            }
            theConnection.commit();
        }
        catch (SailException e) {
            theConnection.rollback();
            throw e;
        }
    }

    public static void remove(SailConnection theConnection, Graph theGraph) throws SailException {
        try {
            theConnection.begin();
            for (Statement aStmt : theGraph) {
                if (aStmt.getContext() != null) {
                    theConnection.removeStatements(aStmt.getSubject(), aStmt.getPredicate(), aStmt.getObject(), new Resource[]{aStmt.getContext()});
                    continue;
                }
                theConnection.removeStatements(aStmt.getSubject(), aStmt.getPredicate(), aStmt.getObject(), new Resource[0]);
            }
            theConnection.commit();
        }
        catch (SailException e) {
            theConnection.rollback();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(SailConnection theConnection, Statement theStmt) throws SailException {
        CloseableIteration aIter = theStmt.getContext() == null ? theConnection.getStatements(theStmt.getSubject(), theStmt.getPredicate(), theStmt.getObject(), true, new Resource[0]) : theConnection.getStatements(theStmt.getSubject(), theStmt.getPredicate(), theStmt.getObject(), true, new Resource[]{theStmt.getContext()});
        try {
            boolean bl = aIter.hasNext();
            return bl;
        }
        finally {
            AdunaIterations.closeQuietly(aIter);
        }
    }

    public static void closeQuietly(SailConnection theConnection) {
        if (theConnection != null) {
            try {
                theConnection.close();
            }
            catch (SailException e) {
                LOGGER.warn("An error while closing a SailConnection was ignored", (Throwable)e);
            }
        }
    }
}

