/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.streampipes.empire.cp.openrdf.utils.sail.SailConnections;
import org.streampipes.empire.cp.openrdf.utils.util.AdunaIterations;

public final class Sails {
    public Sails() {
        throw new AssertionError();
    }

    public static void clear(Sail theSail) throws SailException {
        try (SailConnection aConn = theSail.getConnection();){
            SailConnections.clear(aConn, new Resource[0]);
        }
    }

    public static void add(Sail theSail, Graph theGraph) throws SailException {
        try (SailConnection aConn = theSail.getConnection();){
            SailConnections.add(aConn, theGraph);
        }
    }

    public static void remove(Sail theSail, Graph theGraph) throws SailException {
        try (SailConnection aConn = theSail.getConnection();){
            SailConnections.remove(aConn, theGraph);
        }
    }

    public static boolean contains(Sail theSail, Statement theStmt) throws SailException {
        SailConnection aConn = theSail.getConnection();
        CloseableIteration aIter = null;
        try {
            aIter = theStmt.getContext() != null ? aConn.getStatements(theStmt.getSubject(), theStmt.getPredicate(), theStmt.getObject(), true, new Resource[]{theStmt.getContext()}) : aConn.getStatements(theStmt.getSubject(), theStmt.getPredicate(), theStmt.getObject(), true, new Resource[0]);
            boolean bl = aIter.hasNext();
            return bl;
        }
        catch (Exception e) {
            throw new SailException((Throwable)e);
        }
        finally {
            AdunaIterations.closeQuietly(aIter);
            aConn.close();
        }
    }
}

