/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.util;

import java.util.Optional;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdunaIterations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdunaIterations.class);

    private AdunaIterations() {
        throw new AssertionError();
    }

    public static void closeQuietly(CloseableIteration<?, ?> theCloseableIteration) {
        try {
            if (theCloseableIteration != null) {
                Iterations.closeCloseable(theCloseableIteration);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Ignoring error while closing iteration.", (Throwable)e);
        }
    }

    public static <T, E extends Exception> Optional<T> singleResult(CloseableIteration<T, E> theIter) throws E {
        if (theIter == null) {
            return Optional.empty();
        }
        try {
            Optional optional = theIter.hasNext() ? Optional.of(theIter.next()) : Optional.empty();
            return optional;
        }
        finally {
            theIter.close();
        }
    }

    public static <T, E extends Exception> void consume(CloseableIteration<T, E> theIter) throws E {
        if (theIter == null) {
            return;
        }
        try {
            while (theIter.hasNext()) {
                theIter.next();
            }
        }
        finally {
            theIter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> long size(CloseableIteration<T, E> theIter) throws E {
        if (theIter == null) {
            return 0L;
        }
        try {
            long aCount = 0L;
            while (theIter.hasNext()) {
                theIter.next();
                ++aCount;
            }
            long l = aCount;
            return l;
        }
        finally {
            theIter.close();
        }
    }
}

