/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.empire.cp.openrdf.utils.util;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.streampipes.empire.cp.openrdf.utils.model.Models2;

public class ResourceBuilder
implements Value {
    private final Model mGraph;
    private final Resource mRes;
    private final ValueFactory mValueFactory;

    public ResourceBuilder(Resource theRes) {
        this(Models2.newModel(), (ValueFactory)SimpleValueFactory.getInstance(), theRes);
    }

    protected ResourceBuilder(Model theGraph, ValueFactory theValueFactory, Resource theRes) {
        this.mRes = theRes;
        this.mGraph = theGraph;
        this.mValueFactory = theValueFactory;
    }

    public ResourceBuilder addProperty(IRI theProperty, URI theURI) {
        return this.addProperty(theProperty, (Value)this.mValueFactory.createIRI(theURI.toString()));
    }

    public ResourceBuilder addProperty(IRI theProperty, List<? extends Value> theList) {
        BNode aListRes = this.mValueFactory.createBNode();
        this.mGraph.add(this.getResource(), theProperty, (Value)aListRes, new Resource[0]);
        Iterator<? extends Value> aResIter = theList.iterator();
        while (aResIter.hasNext()) {
            this.mGraph.add((Resource)aListRes, RDF.FIRST, aResIter.next(), new Resource[0]);
            if (aResIter.hasNext()) {
                BNode aNextListElem = this.mValueFactory.createBNode();
                this.mGraph.add((Resource)aListRes, RDF.REST, (Value)aNextListElem, new Resource[0]);
                aListRes = aNextListElem;
                continue;
            }
            this.mGraph.add((Resource)aListRes, RDF.REST, (Value)RDF.NIL, new Resource[0]);
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Value theValue) {
        if (theValue != null) {
            this.mGraph.add(this.mRes, theProperty, theValue, new Resource[0]);
        }
        return this;
    }

    public Resource getResource() {
        return this.mRes;
    }

    public Model model() {
        return this.mGraph;
    }

    public ResourceBuilder addProperty(IRI theProperty, ResourceBuilder theBuilder) {
        if (theBuilder != null) {
            this.addProperty(theProperty, (Value)theBuilder.getResource());
            this.mGraph.addAll((Collection)Sets.newHashSet((Iterable)theBuilder.mGraph));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, String theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Integer theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.intValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Long theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.longValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Short theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.shortValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Double theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.doubleValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Date theValue) {
        if (theValue != null) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(theValue);
            try {
                return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(DatatypeFactory.newInstance().newXMLGregorianCalendar(c).toXMLFormat(), XMLSchema.DATETIME));
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Float theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.floatValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Boolean theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, (Value)this.mValueFactory.createLiteral(theValue.booleanValue()));
        }
        return this;
    }

    public ResourceBuilder addProperty(IRI theProperty, Object theObject) {
        if (theObject == null) {
            return this;
        }
        if (theObject instanceof Boolean) {
            return this.addProperty(theProperty, (Boolean)theObject);
        }
        if (theObject instanceof Long) {
            return this.addProperty(theProperty, (Long)theObject);
        }
        if (theObject instanceof Integer) {
            return this.addProperty(theProperty, (Integer)theObject);
        }
        if (theObject instanceof Short) {
            return this.addProperty(theProperty, (Short)theObject);
        }
        if (theObject instanceof Float) {
            return this.addProperty(theProperty, (Float)theObject);
        }
        if (theObject instanceof Date) {
            return this.addProperty(theProperty, (Date)theObject);
        }
        if (theObject instanceof Double) {
            return this.addProperty(theProperty, (Double)theObject);
        }
        if (theObject instanceof Value) {
            return this.addProperty(theProperty, (Value)theObject);
        }
        if (theObject instanceof List) {
            try {
                return this.addProperty(theProperty, (List)theObject);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                return this;
            }
        }
        if (theObject instanceof ResourceBuilder) {
            return this.addProperty(theProperty, (ResourceBuilder)theObject);
        }
        if (theObject instanceof URI) {
            return this.addProperty(theProperty, (URI)theObject);
        }
        return this.addProperty(theProperty, theObject.toString());
    }

    public ResourceBuilder addLabel(String theLabel) {
        return this.addProperty(RDFS.LABEL, theLabel);
    }

    public ResourceBuilder addType(IRI theType) {
        return this.addProperty(RDF.TYPE, (Value)theType);
    }

    public String stringValue() {
        return this.mRes.stringValue();
    }
}

