/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.messaging.kafka.config;

import java.util.Properties;
import java.util.function.Supplier;
import org.streampipes.model.grounding.KafkaTransportProtocol;

public abstract class AbstractConfigFactory {
    private static final String COLON = ":";
    protected KafkaTransportProtocol protocol;

    public AbstractConfigFactory(KafkaTransportProtocol protocol) {
        this.protocol = protocol;
    }

    public abstract Properties makeProperties();

    protected <T> T getConfigOrDefault(Supplier<T> function, T defaultValue) {
        return function.get() != null ? function.get() : defaultValue;
    }

    protected String getBrokerUrl() {
        return this.protocol.getBrokerHostname() + COLON + this.protocol.getKafkaPort();
    }
}

