/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.messaging.kafka.config;

import java.util.Properties;
import java.util.UUID;
import org.streampipes.messaging.kafka.config.AbstractConfigFactory;
import org.streampipes.model.grounding.KafkaTransportProtocol;

public class ConsumerConfigFactory
extends AbstractConfigFactory {
    private static final String ENABLE_AUTO_COMMIT_CONFIG_DEFAULT = "true";
    private static final String AUTO_COMMIT_INTERVAL_MS_CONFIG_DEFAULT = "10000";
    private static final String SESSION_TIMEOUT_MS_CONFIG_DEFAULT = "30000";
    private static final Integer FETCH_MAX_BYTES_CONFIG_DEFAULT = 0x4C4B4C;
    private static final String KEY_DESERIALIZER_CLASS_CONFIG_DEFAULT = "org.apache.kafka.common.serialization.StringDeserializer";
    private static final String VALUE_DESERIALIZER_CLASS_CONFIG_DEFAULT = "org.apache.kafka.common.serialization.ByteArrayDeserializer";

    public ConsumerConfigFactory(KafkaTransportProtocol protocol) {
        super(protocol);
    }

    @Override
    public Properties makeProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerUrl());
        props.put("group.id", this.getConfigOrDefault(() -> ((KafkaTransportProtocol)this.protocol).getGroupId(), UUID.randomUUID().toString()));
        props.put("enable.auto.commit", ENABLE_AUTO_COMMIT_CONFIG_DEFAULT);
        props.put("auto.commit.interval.ms", AUTO_COMMIT_INTERVAL_MS_CONFIG_DEFAULT);
        props.put("session.timeout.ms", SESSION_TIMEOUT_MS_CONFIG_DEFAULT);
        props.put("fetch.max.bytes", this.getConfigOrDefault(() -> ((KafkaTransportProtocol)this.protocol).getMessageMaxBytes(), FETCH_MAX_BYTES_CONFIG_DEFAULT));
        props.put("key.deserializer", KEY_DESERIALIZER_CLASS_CONFIG_DEFAULT);
        props.put("value.deserializer", VALUE_DESERIALIZER_CLASS_CONFIG_DEFAULT);
        props.put("client.id", UUID.randomUUID().toString());
        return props;
    }
}

