/*
 * Decompiled with CFR 0.152.
 */
package org.streampipes.messaging.kafka.config;

import java.util.Properties;
import org.streampipes.messaging.kafka.config.AbstractConfigFactory;
import org.streampipes.model.grounding.KafkaTransportProtocol;

public class ProducerConfigFactory
extends AbstractConfigFactory {
    private static final String ACKS_CONFIG_DEFAULT = "all";
    private static final Integer RETRIES_CONFIG_DEFAULT = 0;
    private static final Integer BATCH_SIZE_CONFIG_DEFAULT = 0x190000;
    private static final Integer LINGER_MS_DEFAULT = 20;
    private static final Integer BUFFER_MEMORY_CONFIG_DEFAULT = 0x2000000;
    private static final String KEY_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.StringSerializer";
    private static final String VALUE_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.ByteArraySerializer";

    public ProducerConfigFactory(KafkaTransportProtocol protocol) {
        super(protocol);
    }

    @Override
    public Properties makeProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.getBrokerUrl());
        props.put("acks", this.getConfigOrDefault(() -> ((KafkaTransportProtocol)this.protocol).getAcks(), ACKS_CONFIG_DEFAULT));
        props.put("retries", RETRIES_CONFIG_DEFAULT);
        props.put("batch.size", this.getConfigOrDefault(() -> ((KafkaTransportProtocol)this.protocol).getBatchSize(), BATCH_SIZE_CONFIG_DEFAULT));
        props.put("linger.ms", this.getConfigOrDefault(() -> ((KafkaTransportProtocol)this.protocol).getLingerMs(), LINGER_MS_DEFAULT));
        props.put("buffer.memory", BUFFER_MEMORY_CONFIG_DEFAULT);
        props.put("key.serializer", KEY_SERIALIZER_DEFAULT);
        props.put("value.serializer", VALUE_SERIALIZER_DEFAULT);
        return props;
    }
}

