/*
 * Decompiled with CFR 0.152.
 */
package org.summerclouds.conductor.api;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.summerclouds.common.core.M;
import org.summerclouds.common.core.console.Console;
import org.summerclouds.common.core.error.NotFoundException;
import org.summerclouds.common.core.error.UsageException;
import org.summerclouds.common.core.log.Log;
import org.summerclouds.common.core.node.MProperties;
import org.summerclouds.common.core.tool.MCast;
import org.summerclouds.common.core.tool.MString;
import org.summerclouds.common.core.tool.MSystem;
import org.summerclouds.common.core.tool.MThread;
import org.summerclouds.common.core.tool.MValidator;
import org.summerclouds.common.core.util.MUri;
import org.summerclouds.conductor.api.Conductor;
import org.summerclouds.conductor.api.Context;
import org.summerclouds.conductor.api.OrderImpl;
import org.summerclouds.conductor.api.Project;
import org.summerclouds.conductor.api.Step;
import org.summerclouds.conductor.api.StopLifecycleException;

public class ConUtil {
    public static final Object consoleLock = new Object();
    private static final Log log = Log.getLog(Conductor.class);
    public static final String PROPERTY_FAE = "conductor.fae";
    public static final String PROPERTY_CMD_PATH = "conductor.cmd.";
    public static final String PROPERTY_PATH = "conductor.path";
    public static final String DEFAULT_PATHES_UNIX = "/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin";
    public static final String DEFAULT_PATHES_WINDOWS = "C:\\Program Files;C:\\Winnt;C:\\Winnt\\System32";
    public static final String PROPERTY_VERSION = "conductor.version";
    public static final String PROPERTY_LIFECYCLE = "conductor.lifecycle";
    public static final String PROPERTY_DOWNLOAD_SNAPSHOTS = "conductor.downloadSnapshots";
    public static final String ENV_HOME = "CONDUCTOR_HOME";
    public static final String ENV_HOME_DEFAULT = ".conductor";
    public static final String PROPERTY_ROOT = "conductor.root";
    public static final String PROPERTY_HOME = "conductor.home";
    public static final String PROPERTY_VALIDATORS = "conductor.validators";
    public static final String PROPERTY_PARALLEL = "conductor.parallel";
    public static final String PROPERTY_THREADS = "conductor.threads";
    private static final Object[] SCAN_PACKAGES = new Object[]{"org.summerclouds.conductor"};
    public static final String PROPERTY_STEP_IGNORE_RETURN_CODE = "step.ignoreReturnCode";
    public static final String PROPERTY_Y = "conductor.confirm.confirm";
    public static final String PROPERTY_CONFIRM_STEPS = "conductor.confirm.steps";
    public static final String PROPERTY_CONFIRM_CMDS = "conductor.confirm.cmds";
    public static final String PROPERTY_CONFIRM_BEEP = "conductor.confirm.beep";
    public static final String PROPERTY_VERBOSE = "conductor.verbose";
    public static final String PROPERTY_CONCATENATE = "conductor.concatenate";

    public static void orderProjects(final Conductor con, List<Project> projects, String[] orderStrings) {
        final OrderImpl[] orders = new OrderImpl[orderStrings.length];
        for (int i = 0; i < orderStrings.length; ++i) {
            orders[i] = new OrderImpl(con, orderStrings[i], projects);
        }
        projects.sort(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                int orderIdx = 0;
                for (OrderImpl order : orders) {
                    int partial;
                    ++orderIdx;
                    if (order.getType() == OrderImpl.ORDER_TYPE.DEPENDENCY) {
                        if (con.isVerboseOutput()) {
                            System.out.println(" >>> DOrder: " + o1.getName() + " vs. " + o2.getName());
                        }
                        partial = 1.compareDependency(con, order.getName(), o1, o2, 0, orderIdx >= orders.length);
                        if (con.isVerboseOutput()) {
                            System.out.println(" === DOrder: " + o1.getName() + " vs. " + o2.getName() + ": " + partial);
                        }
                        if (partial == 0) continue;
                        if (!order.isOrderAsc()) {
                            partial *= -1;
                        }
                        return partial;
                    }
                    partial = this.compareNumber((String[])o1.getLabels().getOrNull(order.getName()), (String[])o2.getLabels().getOrNull(order.getName()));
                    if (con.isVerboseOutput()) {
                        System.out.println(" === IOrder: " + o1.getName() + " vs. " + o2.getName() + ": " + partial);
                    }
                    if (partial == 0) continue;
                    if (!order.isOrderAsc()) {
                        partial *= -1;
                    }
                    return partial;
                }
                return 0;
            }

            private int compareNumber(String[] o1, String[] o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null || o1.length == 0) {
                    return -1;
                }
                if (o2 == null || o2.length == 0) {
                    return 1;
                }
                if (MValidator.isNumber((String)o1[0]) && MValidator.isNumber((String)o2[0])) {
                    return Double.compare(MCast.todouble((Object)o1[0], (double)0.0), MCast.todouble((Object)o2[0], (double)0.0));
                }
                return o1[0].compareTo(o2[0]);
            }

            private static int compareDependency(Conductor con2, String labelName, Project o1, Project o2, int depth, boolean reverse) {
                if (depth > 1000) {
                    throw new UsageException("dependencies too deep", new Object[0]);
                }
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                for (String dependency2 : o2.getLabels().getOrDefault(labelName, M.EMPTY_STRING_ARRAY)) {
                    if (dependency2.equals(o1.getName())) {
                        return -1;
                    }
                    Project depProject2 = (Project)con2.getProjects().get(dependency2);
                    int parentCompare2 = 1.compareDependency(con2, labelName, o1, depProject2, depth + 1, false);
                    if (con2.isVerboseOutput()) {
                        System.out.println(" --> Order: " + o1.getName() + " vs. " + o2.getName() + ": " + parentCompare2);
                    }
                    if (parentCompare2 >= 0) continue;
                    return -1;
                }
                if (reverse) {
                    for (String dependency1 : o1.getLabels().getOrDefault(labelName, M.EMPTY_STRING_ARRAY)) {
                        if (dependency1.equals(o2.getName())) {
                            return 1;
                        }
                        Project depProject1 = (Project)con2.getProjects().get(dependency1);
                        int parentCompare1 = 1.compareDependency(con2, labelName, o2, depProject1, depth + 1, true);
                        if (con2.isVerboseOutput()) {
                            System.out.println(" <-- Order: " + o2.getName() + " vs. " + o1.getName() + ": " + parentCompare1);
                        }
                        if (parentCompare1 <= 0) continue;
                        return -1;
                    }
                }
                return 0;
            }
        });
    }

    public static String[] execute(Conductor con, String name, File rootDir, String cmd, boolean infoOut) throws IOException {
        if (con != null && con.getProperties().getBoolean(PROPERTY_CONFIRM_CMDS, false) && !ConUtil.confirmAction(con, null, null, "Press ENTER to execute " + cmd)) {
            return new String[]{"", "", "0"};
        }
        log.i(name, new Object[]{"execute", cmd, rootDir});
        final String shortName = ConUtil.shorten(name);
        final Console console = ConUtil.getConsole();
        final boolean output = infoOut || log.isLevelEnabled(Log.LEVEL.DEBUG);
        final StringBuilder stdOutBuilder = new StringBuilder();
        final StringBuilder stdErrBuilder = new StringBuilder();
        int exitCode = MSystem.execute((String)shortName, (File)rootDir, (String)cmd, (MSystem.ExecuteControl)new MSystem.ExecuteControl(){

            public void stdin(PrintWriter writer) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stdout(String line) {
                if (output) {
                    Object object = consoleLock;
                    synchronized (object) {
                        console.print("[");
                        console.setColor(Console.COLOR.GREEN, null);
                        console.print(shortName);
                        console.cleanup();
                        console.print("] ");
                        console.println(line);
                        console.flush();
                    }
                }
                if (stdOutBuilder.length() > 0) {
                    stdOutBuilder.append("\n");
                }
                stdOutBuilder.append(line);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stderr(String line) {
                if (output) {
                    Object object = consoleLock;
                    synchronized (object) {
                        console.print("[");
                        console.setColor(Console.COLOR.RED, null);
                        console.print(shortName);
                        console.cleanup();
                        console.print("] ");
                        console.println(line);
                        console.flush();
                    }
                }
                if (stdErrBuilder.length() > 0) {
                    stdErrBuilder.append("\n");
                }
                stdErrBuilder.append(line);
            }
        });
        String stderr = stdErrBuilder.toString();
        String stdout = stdOutBuilder.toString();
        log.i(name, new Object[]{"exitCode", exitCode});
        return new String[]{stdout, stderr, String.valueOf(exitCode)};
    }

    private static String shorten(String name) {
        if (name == null) {
            return "";
        }
        if (name.length() < 40) {
            return name;
        }
        if (name.endsWith("-spring-boot-starter")) {
            name = name.substring(0, name.length() - 13);
        } else if (name.endsWith("-maven-plugin")) {
            name = name.substring(0, name.length() - 7);
        }
        return MString.truncateNice((String)name, (int)40, (int)15);
    }

    public static boolean confirmAction(Conductor con, Step step, List<Project> projects, String msg) {
        int c;
        Console console = ConUtil.getConsole();
        console.cleanup();
        console.setColor(Console.COLOR.BRIGHT_RED, Console.COLOR.BRIGHT_BLACK);
        console.println("================================================");
        console.println(" ENTER - run, c - cancel, s - skip, i - inspect ");
        console.println(" x - run and disable configrmation mode");
        console.println("================================================");
        console.cleanup();
        console.print(msg);
        console.flush();
        if (con != null && con.getProperties().getBoolean(PROPERTY_CONFIRM_BEEP, false)) {
            for (int i = 0; i < 3; ++i) {
                console.beep();
                MThread.sleep((long)200L);
            }
        }
        do {
            if ((c = console.read()) == 10) {
                console.println();
                return true;
            }
            if (c == 120) {
                console.println();
                if (con != null) {
                    ((MProperties)con.getProperties()).setBoolean(PROPERTY_CONFIRM_STEPS, false);
                    ((MProperties)con.getProperties()).setBoolean(PROPERTY_CONFIRM_CMDS, false);
                }
                return true;
            }
            if (c == 105) {
                console.println();
                if (projects != null) {
                    for (Project project : projects) {
                        System.out.println("- Project " + project.getName());
                        System.out.println("    Directory : " + String.valueOf(project.getRootDir()));
                        System.out.println("    Path      : " + project.getPath());
                        System.out.println("    Labels    : " + String.valueOf(project.getLabels()));
                        System.out.println("    Properties: " + String.valueOf(project.getProperties()));
                    }
                }
                if (step != null) {
                    System.out.println("- Step " + step.getTitle());
                    System.out.println("    Target    : " + step.getTarget());
                    System.out.println("    Condition : " + step.getCondition());
                    System.out.println("    Selector  : " + String.valueOf(step.getSelector()));
                    System.out.println("    Order     : " + Arrays.toString(step.getOrderBy()));
                    System.out.println("    Properties: " + String.valueOf(step.getProperties()));
                }
            }
            if (c != 115) continue;
            console.println();
            return false;
        } while (c != 99);
        console.println();
        throw new StopLifecycleException(null, "Canceled by user");
    }

    public static Console getConsole() {
        Console ret = Console.get();
        log.t("Console", new Object[]{ret.getClass()});
        return ret;
    }

    public static String cmdLocationOrNull(Conductor con, String cmd) {
        try {
            return ConUtil.cmdLocation(con, cmd);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static String cmdLocation(Conductor con, String cmd) throws NotFoundException {
        String path;
        if (con != null && (path = con.getProperties().getString(PROPERTY_CMD_PATH + cmd.toUpperCase(), null)) != null) {
            return path;
        }
        String[] pathes = null;
        String systemPath = System.getenv("PATH");
        pathes = MSystem.isWindows() ? con.getProperties().getString(PROPERTY_PATH, DEFAULT_PATHES_WINDOWS + (String)(systemPath == null ? "" : ";" + systemPath)).split(";") : con.getProperties().getString(PROPERTY_PATH, DEFAULT_PATHES_UNIX + (String)(systemPath == null ? "" : ":" + systemPath)).split(":");
        for (String path2 : pathes) {
            File file = new File(path2 + File.separator + cmd);
            if (!file.exists() || !file.isFile() || !file.canExecute() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        throw new NotFoundException("Command not found", new Object[]{cmd});
    }

    public static MUri getDefaultConfiguration(String name) {
        String ext = MString.afterLastIndex((String)name, (char)'.');
        name = MString.beforeLastIndex((String)name, (char)'.');
        MUri uri = MUri.toUri((String)("mvn:org.summerclouds/conductor-plugin/1.2.0/" + ext + "/" + name));
        return uri;
    }

    public static File getFile(File root, String path) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(root, path);
        }
        return f;
    }

    public static File getHome() {
        String home = System.getenv(ENV_HOME);
        if (MString.isEmpty((String)home)) {
            return new File(MSystem.getUserHome(), ENV_HOME_DEFAULT).getAbsoluteFile();
        }
        return new File(home);
    }

    public static File createTempFile(Conductor con, Class<?> owner, String suffix) throws IOException {
        File tmp = new File(ConUtil.getHome(), "tmp");
        if (tmp.exists() && tmp.isDirectory()) {
            File file = new File(tmp, owner.getSimpleName() + "-" + String.valueOf(UUID.randomUUID()) + "." + suffix);
            file.deleteOnExit();
            return file;
        }
        File file = File.createTempFile(owner.getSimpleName(), suffix);
        file.deleteOnExit();
        return file;
    }

    public static Object[] getMainPackageName() {
        return SCAN_PACKAGES;
    }

    public static String escapeArgumentsForShell(Context context, List<String> args) {
        StringBuffer out = new StringBuffer();
        for (String arg : args) {
            if (arg == null) {
                arg = "";
            } else {
                if (arg.equals("@")) {
                    for (String arg2 : ConUtil.getContextArgs(context)) {
                        arg2 = ConUtil.escapeArgument(arg2);
                        if (out.length() > 0) {
                            out.append(' ');
                        }
                        out.append(arg2);
                    }
                    continue;
                }
                if (arg.startsWith("\\@")) {
                    arg = arg.substring(1);
                }
            }
            arg = ConUtil.escapeArgument(arg);
            if (out.length() > 0) {
                out.append(' ');
            }
            out.append(arg);
        }
        return out.toString();
    }

    private static String escapeArgument(String arg) {
        if (MSystem.isWindows()) {
            return ConUtil.escapeArgumentCmd(arg);
        }
        return ConUtil.escapeArgumentBash(arg);
    }

    private static String escapeArgumentBash(String arg) {
        if (!((String)arg).matches(".*[\\s|&;<>()$`\"'\\[\\]*?#~=%+\\\\].*")) {
            return arg;
        }
        arg = ((String)arg).replaceAll("\\'", "'\\\\''");
        arg = "'" + (String)arg + "'";
        return arg;
    }

    private static String escapeArgumentCmd(String arg) {
        if (!((String)arg).matches(".*[\\s|&<>\"'^].*")) {
            return arg;
        }
        arg = ((String)arg).replaceAll("([|&<>\"^])", "^$1");
        arg = "\"" + (String)arg + "\"";
        return arg;
    }

    private static List<String> getContextArgs(Context context) {
        LinkedList<String> out = new LinkedList<String>();
        int i = 0;
        while (context.getProperties().containsKey((Object)String.valueOf(i))) {
            out.add(context.getProperties().getString(String.valueOf(i), ""));
            ++i;
        }
        return out;
    }
}

