/*
 * Decompiled with CFR 0.152.
 */
package org.summerclouds.conductor.api;

import java.util.List;
import org.summerclouds.common.core.console.Console;
import org.summerclouds.common.core.tool.MValidator;
import org.summerclouds.conductor.api.Conductor;
import org.summerclouds.conductor.api.Project;

public class OrderImpl {
    private ORDER_TYPE type;
    private String name;
    private boolean orderAsc;

    public OrderImpl(Conductor con, String definition, List<Project> projects) {
        this.name = definition;
        this.orderAsc = true;
        if (this.name.endsWith(" desc")) {
            this.orderAsc = false;
            this.name = this.name.substring(0, this.name.length() - 5);
        } else if (this.name.endsWith(" asc")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
        this.name = this.name.trim();
        this.type = ORDER_TYPE.INDEX;
        if (this.name.startsWith("@")) {
            this.name = this.name.substring(1);
            this.type = ORDER_TYPE.DEPENDENCY;
        } else if (this.name.startsWith("#")) {
            this.name = this.name.substring(1);
            this.type = ORDER_TYPE.INDEX;
        } else {
            ORDER_TYPE[] newType = new ORDER_TYPE[]{ORDER_TYPE.DEPENDENCY};
            for (Project p : con.getProjects()) {
                String[] value = (String[])p.getLabels().getOrNull(this.name);
                if (value == null || value.length == 0) continue;
                if (!MValidator.isInteger((Object)value[0])) break;
                newType[0] = ORDER_TYPE.INDEX;
                break;
            }
            this.type = newType[0];
            if (con.isVerboseOutput()) {
                Console.get().println("--- Found order type " + String.valueOf((Object)this.type) + " for label " + this.name);
            }
        }
    }

    public ORDER_TYPE getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOrderAsc() {
        return this.orderAsc;
    }

    public static enum ORDER_TYPE {
        DEPENDENCY,
        INDEX;

    }
}

