/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.ParserException;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpMethod;
import swim.http.HttpParser;
import swim.http.HttpRequest;
import swim.http.HttpVersion;
import swim.uri.Uri;
import swim.util.Builder;

final class HttpRequestParser<T>
extends Parser<HttpRequest<T>> {
    final HttpParser http;
    final Parser<HttpMethod> method;
    final StringBuilder uri;
    final Parser<HttpVersion> version;
    final Parser<? extends HttpHeader> header;
    final Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers;
    final int step;

    HttpRequestParser(HttpParser http, Parser<HttpMethod> method, StringBuilder uri, Parser<HttpVersion> version, Parser<? extends HttpHeader> header, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        this.http = http;
        this.method = method;
        this.uri = uri;
        this.version = version;
        this.header = header;
        this.headers = headers;
        this.step = step;
    }

    HttpRequestParser(HttpParser http) {
        this(http, null, null, null, null, null, 1);
    }

    public Parser<HttpRequest<T>> feed(Input input) {
        return HttpRequestParser.parse(input, this.http, this.method, this.uri, this.version, this.header, this.headers, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> Parser<HttpRequest<T>> parse(Input input, HttpParser http, Parser<HttpMethod> method, StringBuilder uri, Parser<HttpVersion> version22222, Parser<? extends HttpHeader> header32222, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        void version22222;
        void header32222;
        block58: {
            int c = 0;
            if (step == 1) {
                if (method == null) {
                    if (input.isDone()) {
                        return HttpRequestParser.done();
                    }
                    method = http.parseMethod(input);
                } else {
                    method = method.feed(input);
                }
                if (method.isDone()) {
                    step = 2;
                } else if (method.isError()) {
                    return method.asError();
                }
            }
            if (step == 2) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 3) {
                if (uri == null) {
                    uri = new StringBuilder();
                }
                while (input.isCont() && (c = input.head()) != 32) {
                    input = input.step();
                    uri.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 4;
                }
            }
            if (step == 4) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 5;
                } else if (!input.isEmpty()) {
                    return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 5) {
                void version22222;
                if (version22222 == null) {
                    Parser<HttpVersion> version22222 = http.parseVersion(input);
                } else {
                    Object version22222;
                    Parser version22222 = version22222.feed(input);
                }
                if (version22222.isDone()) {
                    step = 6;
                } else if (version22222.isError()) {
                    return version22222.asError();
                }
            }
            if (step == 6) {
                if (input.isCont() && input.head() == 13) {
                    input = input.step();
                    step = 7;
                } else if (!input.isEmpty()) {
                    return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                }
            }
            if (step == 7) {
                if (input.isCont() && input.head() == 10) {
                    input = input.step();
                    step = 8;
                } else if (!input.isEmpty()) {
                    return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                }
            }
            while (true) {
                block59: {
                    block60: {
                        if (step != 8) break block59;
                        if (!input.isCont()) break block60;
                        c = input.head();
                        if (Http.isTokenChar(c)) {
                            step = 9;
                            break block59;
                        } else {
                            if (Http.isSpace(c)) {
                                return HttpRequestParser.error((Diagnostic)Diagnostic.message((String)"unsupported header line extension", (Input)input));
                            }
                            if (c != 13) {
                                return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                            }
                            input = input.step();
                            step = 12;
                            break block58;
                        }
                    }
                    if (input.isDone()) {
                        return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                    }
                }
                if (step == 9) {
                    void header32222;
                    if (header32222 == null) {
                        Parser<HttpHeader> header32222 = http.parseHeader(input);
                    } else {
                        void header32222;
                        Parser header32222 = header32222.feed(input);
                    }
                    if (header32222.isDone()) {
                        step = 10;
                    } else if (header32222.isError()) {
                        return header32222.asError();
                    }
                }
                if (step == 10) {
                    if (input.isCont() && input.head() == 13) {
                        input = input.step();
                        step = 11;
                    } else if (!input.isEmpty()) {
                        return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                    }
                }
                if (step != 11) break block58;
                if (!input.isCont() || input.head() != 10) break;
                if (headers == null) {
                    headers = FingerTrieSeq.builder();
                }
                headers.add((Object)((HttpHeader)header32222.bind()));
                Object header32222 = null;
                input = input.step();
                step = 8;
            }
            if (!input.isEmpty()) {
                return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (step == 12) {
            if (input.isCont() && input.head() == 10) {
                Uri requestUri;
                input = input.step();
                try {
                    requestUri = Uri.parse((String)uri.toString());
                }
                catch (ParserException cause) {
                    return HttpRequestParser.error((Throwable)cause);
                }
                if (headers == null) {
                    HttpRequest request = http.request((HttpMethod)method.bind(), requestUri, (HttpVersion)version22222.bind(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
                    return HttpRequestParser.done(request);
                }
                HttpRequest request = http.request((HttpMethod)method.bind(), requestUri, (HttpVersion)version22222.bind(), (FingerTrieSeq<HttpHeader>)((FingerTrieSeq)headers.bind()));
                return HttpRequestParser.done(request);
            }
            if (!input.isEmpty()) {
                return HttpRequestParser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (input.isError()) {
            return HttpRequestParser.error((Throwable)input.trap());
        }
        return new HttpRequestParser<T>(http, method, uri, (Parser<HttpVersion>)version22222, (Parser<? extends HttpHeader>)header32222, (Builder<HttpHeader, FingerTrieSeq<HttpHeader>>)headers, step);
    }

    static <T> Parser<HttpRequest<T>> parse(Input input, HttpParser http) {
        return HttpRequestParser.parse(input, http, null, null, null, null, null, 1);
    }
}

